/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils;

import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testng.AssertJUnit;

public class NucleusTestUtils {
    protected static final int DEFAULT_TIMEOUT_MSEC = 480000;
    private static boolean verbose = true;
    private static Map<String, String> env;
    private static String[] envp;
    private static String[] envProps;
    protected static final File nucleusRoot;

    private static File initNucleusRoot() {
        env = new HashMap<String, String>(System.getenv());
        for (String propertyKey : envProps) {
            String propertyValue = System.getProperty(propertyKey);
            if (propertyValue == null) continue;
            NucleusTestUtils.putEnv(propertyKey, propertyValue);
        }
        Object nucleusRootProp = System.getProperty("nucleus.home");
        if (nucleusRootProp == null) {
            String basedir = System.getProperty("basedir");
            AssertJUnit.assertNotNull((Object)basedir);
            nucleusRootProp = basedir + "/../../distributions/nucleus/target/stage/nucleus";
        }
        System.out.println("nucleus.home=" + (String)nucleusRootProp);
        return new File((String)nucleusRootProp);
    }

    protected NucleusTestUtils() {
    }

    public static File getNucleusRoot() {
        return nucleusRoot;
    }

    public static void putEnv(String name, String value) {
        env.put(name, value);
        if (!env.isEmpty()) {
            envp = new String[env.size()];
            int i = 0;
            for (Map.Entry<String, String> me : env.entrySet()) {
                NucleusTestUtils.envp[i++] = me.getKey() + "=" + me.getValue();
            }
        } else {
            envp = null;
        }
    }

    public static boolean nadmin(int timeout, String ... args) {
        return NucleusTestUtils.nadminWithOutput((int)timeout, (String[])args).returnValue;
    }

    public static boolean nadmin(String ... args) {
        return NucleusTestUtils.nadmin(480000, args);
    }

    public static NadminReturn nadminWithOutput(String ... args) {
        return NucleusTestUtils.nadminWithOutput(480000, args);
    }

    public static NadminReturn nadminWithOutput(int timeout, String ... args) {
        File cmd = new File(nucleusRoot, NucleusTestUtils.isWindows() ? "bin/nadmin.bat" : "bin/nadmin");
        if (!cmd.canExecute() && !(cmd = new File(nucleusRoot, NucleusTestUtils.isWindows() ? "bin/asadmin.bat" : "bin/asadmin")).canExecute()) {
            cmd = new File(nucleusRoot, NucleusTestUtils.isWindows() ? "bin/nadmin.bat" : "bin/nadmin");
        }
        return NucleusTestUtils.cmdWithOutput(cmd, timeout, args);
    }

    public static NadminReturn nadminDetachWithOutput(String ... args) {
        File cmd = new File(nucleusRoot, NucleusTestUtils.isWindows() ? "bin/nadmin.bat" : "bin/nadmin");
        if (!cmd.canExecute() && !(cmd = new File(nucleusRoot, NucleusTestUtils.isWindows() ? "bin/asadmin.bat" : "bin/asadmin")).canExecute()) {
            cmd = new File(nucleusRoot, NucleusTestUtils.isWindows() ? "bin/nadmin.bat" : "bin/nadmin");
        }
        return NucleusTestUtils.cmdDetachWithOutput(cmd, 480000, args);
    }

    public static NadminReturn cmdWithOutput(File cmd, int timeout, String ... args) {
        int exit;
        ArrayList<String> command = new ArrayList<String>();
        command.add(cmd.toString());
        command.add("--echo");
        command.addAll(Arrays.asList(args));
        ProcessManager processManager = new ProcessManager(command);
        processManager.setTimeoutMsec(timeout);
        processManager.setEcho(false);
        processManager.setEnvironment(envp);
        Object myErr = "";
        try {
            exit = processManager.execute();
        }
        catch (ProcessManagerTimeoutException tex) {
            myErr = "\nProcessManagerTimeoutException: command timed out after " + timeout + " ms.";
            exit = 1;
        }
        catch (ProcessManagerException ex) {
            ex.printStackTrace();
            myErr = "\n" + ex.getMessage();
            exit = 1;
        }
        NadminReturn ret = new NadminReturn(exit, processManager.getStdout(), processManager.getStderr() + (String)myErr, args[0]);
        NucleusTestUtils.write(ret.outAndErr);
        return ret;
    }

    public static NadminReturn cmdDetachWithOutput(File cmd, int timeout, String ... args) {
        int exit;
        ArrayList<String> command = new ArrayList<String>();
        command.add(cmd.toString());
        command.add("--echo");
        command.add("--detach");
        command.addAll(Arrays.asList(args));
        ProcessManager pm = new ProcessManager(command);
        pm.setTimeoutMsec(timeout);
        pm.setEcho(false);
        pm.setEnvironment(envp);
        Object myErr = "";
        try {
            exit = pm.execute();
        }
        catch (ProcessManagerTimeoutException tex) {
            myErr = "\nProcessManagerTimeoutException: command timed out after " + timeout + " ms.";
            exit = 1;
        }
        catch (ProcessManagerException ex) {
            exit = 1;
        }
        NadminReturn ret = new NadminReturn(exit, pm.getStdout(), pm.getStderr() + (String)myErr, args[0]);
        NucleusTestUtils.write(ret.outAndErr);
        return ret;
    }

    private static boolean validResults(String text, String ... invalidResults) {
        for (String result : invalidResults) {
            if (!text.contains(result)) continue;
            return false;
        }
        return true;
    }

    private static void write(String text) {
        if (verbose && !text.isEmpty()) {
            System.out.print(text);
        }
    }

    protected static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    }

    public static boolean matchString(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return b.indexOf(a) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURL(String urlstr) {
        StringWriter ow = null;
        BufferedReader ir = null;
        try {
            String string;
            block17: {
                URL u = new URL(urlstr);
                URLConnection urlc = u.openConnection();
                ir = new BufferedReader(new InputStreamReader(urlc.getInputStream(), "ISO-8859-1"));
                try {
                    String line;
                    ow = new StringWriter();
                    while ((line = ir.readLine()) != null) {
                        ow.write(line);
                        ow.write("\n");
                    }
                    string = ow.getBuffer().toString();
                    if (ow == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (ow != null) {
                            ow.close();
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        System.out.println("unable to fetch URL:" + urlstr + ", reason: " + ex.getMessage());
                        String string2 = "";
                        return string2;
                    }
                }
                ow.close();
            }
            return string;
        }
        finally {
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(NucleusTestUtils.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void deleteDirectoryContents(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        System.out.println("Deleting contents of directory : " + dir);
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    NucleusTestUtils.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
        }
    }

    public static void deleteDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    NucleusTestUtils.deleteDirectory(f);
                    continue;
                }
                f.delete();
            }
        }
        dir.delete();
    }

    public static void touchDirectory(File dir) {
        long timestamp;
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    NucleusTestUtils.touchDirectory(f);
                    continue;
                }
                timestamp = System.currentTimeMillis();
                f.setLastModified(timestamp);
            }
        }
        timestamp = System.currentTimeMillis();
        dir.setLastModified(timestamp);
        System.out.println("Touched contents of directory : " + dir);
    }

    static {
        envProps = new String[]{"AS_ADMIN_PASSWORDFILE", "AS_LOGFILE", "AS_ADMIN_USER", "P_ADMIN_PASSWORDFILE", "P_ADMIN_USER", "P_ADMIN_READTIMEOUT", "C_ADMIN_READTIMEOUT"};
        nucleusRoot = NucleusTestUtils.initNucleusRoot();
    }

    public static class NadminReturn {
        public boolean returnValue;
        public String out;
        public String err;
        public String outAndErr;

        NadminReturn(int exit, String out, String err, String cmd) {
            this.returnValue = exit == 0 && NucleusTestUtils.validResults(out, String.format("Command %s failed.", cmd));
            this.out = out;
            this.err = err;
            this.outAndErr = this.out + this.err;
        }
    }
}

