/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils.junit;

import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestLoggingExtension
implements BeforeEachCallback,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    private static final System.Logger LOG = System.getLogger(TestLoggingExtension.class.getName());
    private static final String START_TIME_METHOD = "start time method";
    private static final String START_TIME_CLASS = "start time class";
    private ExtensionContext.Namespace namespaceClass;
    private ExtensionContext.Namespace namespaceMethod;

    public void beforeAll(ExtensionContext context) throws Exception {
        this.namespaceClass = ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestClass()});
        context.getStore(this.namespaceClass).put((Object)START_TIME_CLASS, (Object)LocalDateTime.now());
        LOG.log(System.Logger.Level.INFO, "Starting test {0}", new Object[]{context.getTestClass().orElse(null)});
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Method testMethod = context.getRequiredTestMethod();
        Class testClass = context.getRequiredTestClass();
        this.namespaceMethod = ExtensionContext.Namespace.create((Object[])new Object[]{testClass, testMethod});
        context.getStore(this.namespaceMethod).put((Object)START_TIME_METHOD, (Object)LocalDateTime.now());
        LOG.log(System.Logger.Level.INFO, "Starting test method {0}.{1}", testClass.getSimpleName(), testMethod.getName());
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Method testMethod = context.getRequiredTestMethod();
        Class testClass = context.getRequiredTestClass();
        LocalDateTime startTime = (LocalDateTime)context.getStore(this.namespaceMethod).remove((Object)START_TIME_METHOD, LocalDateTime.class);
        if (startTime == null) {
            return;
        }
        LOG.log(System.Logger.Level.INFO, "Test method {0}.{1}, started at {2}, test time: {3} ms", testClass.getSimpleName(), testMethod.getName(), DateTimeFormatter.ISO_LOCAL_TIME.format(startTime), startTime.until(LocalDateTime.now(), ChronoUnit.MILLIS));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        LocalDateTime startTime = (LocalDateTime)context.getStore(this.namespaceClass).remove((Object)START_TIME_CLASS, LocalDateTime.class);
        if (startTime == null) {
            return;
        }
        LOG.log(System.Logger.Level.INFO, "Test {0}, started at {1}, test time: {2} ms", context.getTestClass().orElse(null), DateTimeFormatter.ISO_LOCAL_TIME.format(startTime), startTime.until(LocalDateTime.now(), ChronoUnit.MILLIS));
    }
}

