/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.module;

import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resources.admin.cli.SunResourcesXML;
import org.glassfish.resources.api.Resource;
import org.glassfish.resources.api.ResourceConflictException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtilities {
    private static final Logger _logger = LogDomains.getLogger(ResourceUtilities.class, (String)"javax.enterprise.resource.resourceadapter");
    private static final StringManager localStrings = StringManager.getManager(ResourceUtilities.class);

    private ResourceUtilities() {
    }

    public static Set<Resource> getResourceConfigConflicts(Set<Resource> resSet, Resources resources) {
        HashSet<Resource> conflicts = new HashSet<Resource>();
        if (resSet != null) {
            for (Resource res : resSet) {
                boolean duplicate = ResourceUtilities.hasDuplicate(resources, res);
                if (!duplicate) continue;
                conflicts.add(res);
            }
        }
        return conflicts;
    }

    private static boolean hasDuplicate(Resources resources, Resource res) {
        String id = ResourceUtilities.getIdToCompare(res);
        return resources.getResourceByName(res.getClass(), id) != null;
    }

    private static String getIdToCompare(Resource res) {
        HashMap attrs = res.getAttributes();
        String type = res.getType();
        String id = "jdbc-connection-pool".equals(type) || "connector-connection-pool".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ("security-map".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ("resource-adapter-config".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "resource-adapter-name") : ("work-security-map".equals(type) ? ResourceUtilities.getNamedAttributeValue(attrs, "name") : ResourceUtilities.getNamedAttributeValue(attrs, "jndi-name"))));
        return id;
    }

    private static String getNamedAttributeValue(HashMap attributes, String name) {
        return (String)attributes.get(name);
    }

    public static Set<Resource> resolveResourceDuplicatesConflictsWithinArchive(List<SunResourcesXML> sunResList) throws ResourceConflictException {
        boolean conflictExist = false;
        StringBuffer conflictingResources = new StringBuffer();
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        for (SunResourcesXML sunResXML : sunResList) {
            List resources = sunResXML.getResourcesList();
            for (Resource res : resources) {
                Iterator resSetIter = resourceSet.iterator();
                boolean addResource = true;
                while (resSetIter.hasNext()) {
                    Resource existingRes = (Resource)resSetIter.next();
                    if (existingRes.equals((Object)res)) {
                        addResource = false;
                        _logger.warning(localStrings.getString("duplicate.resource.sun.resource.xml", (Object)ResourceUtilities.getIdToCompare(res), (Object)sunResXML.getXMLPath()));
                        break;
                    }
                    if (!existingRes.isAConflict(res)) continue;
                    addResource = false;
                    conflictingResources.append("\n");
                    String message = localStrings.getString("conflict.resource.sun.resource.xml", (Object)ResourceUtilities.getIdToCompare(res), (Object)sunResXML.getXMLPath());
                    conflictingResources.append(message);
                    _logger.warning(message);
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    ResourceUtilities.logAttributes(res);
                }
                if (!addResource) continue;
                resourceSet.add(res);
            }
        }
        if (conflictingResources.toString().length() > 0) {
            throw new ResourceConflictException(conflictingResources.toString());
        }
        return resourceSet;
    }

    public static void getResourceConflictsWithDomainXML(List<Resource> resList, Resources resources) throws ResourceConflictException {
        if (resList != null) {
            Iterator<Resource> iterRes = resList.iterator();
            StringBuffer conflictingResources = new StringBuffer();
            while (iterRes.hasNext()) {
                Resource res = iterRes.next();
                String id = ResourceUtilities.getIdToCompare(res);
                if (resources.getResourceByName(res.getClass(), id) == null) continue;
                conflictingResources.append("\n");
                String message = localStrings.getString("conflict.resource.with.domain.xml", (Object)ResourceUtilities.getIdToCompare(res));
                conflictingResources.append(message);
                _logger.warning(message);
                if (!_logger.isLoggable(Level.FINE)) continue;
                ResourceUtilities.logAttributes(res);
            }
            if (conflictingResources.toString().length() > 0) {
                throw new ResourceConflictException(conflictingResources.toString());
            }
        }
    }

    private static void logAttributes(Resource res) {
        StringBuffer message = new StringBuffer();
        Set entries = res.getAttributes().entrySet();
        for (Map.Entry entry : entries) {
            message.append(entry.getKey());
            message.append("=");
            message.append(entry.getValue());
            message.append(" ");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(localStrings.getString("resource.attributes", (Object)message.toString()));
        }
    }
}

