/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.ejb.entitybean.container;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBHomeInvocationHandler;
import com.sun.ejb.containers.EJBLocalHomeInvocationHandler;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.spi.container.BeanStateSynchronization;
import com.sun.enterprise.security.SecurityManager;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.persistence.ejb.entitybean.container.EntityContainer;
import org.glassfish.persistence.ejb.entitybean.container.EntityContextImpl;
import org.glassfish.persistence.ejb.entitybean.container.ReadOnlyBeanInfo;
import org.glassfish.persistence.ejb.entitybean.container.ReadOnlyContextImpl;
import org.glassfish.persistence.ejb.entitybean.container.ReadOnlyEJBHomeImpl;
import org.glassfish.persistence.ejb.entitybean.container.ReadOnlyEJBLocalHomeImpl;
import org.glassfish.persistence.ejb.entitybean.container.cache.EJBObjectCache;
import org.glassfish.persistence.ejb.entitybean.container.cache.FIFOEJBObjectCache;
import org.glassfish.persistence.ejb.entitybean.container.cache.UnboundedEJBObjectCache;
import org.glassfish.persistence.ejb.entitybean.container.distributed.DistributedEJBServiceFactory;
import org.glassfish.persistence.ejb.entitybean.container.distributed.DistributedReadOnlyBeanService;
import org.glassfish.persistence.ejb.entitybean.container.distributed.ReadOnlyBeanRefreshEventHandler;

public class ReadOnlyBeanContainer
extends EntityContainer
implements ReadOnlyBeanRefreshEventHandler {
    private long refreshPeriodInMillis = 0L;
    private int beanLevelSequenceNum = 1;
    private long beanLevelLastRefreshRequestedAt = 0L;
    private volatile long currentTimeInMillis = System.currentTimeMillis();
    private TimerTask refreshTask = null;
    private EJBObjectCache robCache;
    private DistributedReadOnlyBeanService distributedReadOnlyBeanService;
    private volatile Map<FinderResultsKey, FinderResultsValue> finderResultsCache = new ConcurrentHashMap<FinderResultsKey, FinderResultsValue>();
    private static final int FINDER_LOCK_SIZE = 8192;
    private Object[] finderLocks = new Object[8192];
    private boolean RELATIVE_TIME_CHECK_MODE = false;

    protected ReadOnlyBeanContainer(EjbDescriptor desc, ClassLoader loader) throws Exception {
        super(BaseContainer.ContainerType.ENTITY, desc, loader);
        long idleTimeoutInMillis;
        EjbEntityDescriptor ed = (EjbEntityDescriptor)desc;
        this.refreshPeriodInMillis = (long)ed.getIASEjbExtraDescriptors().getRefreshPeriodInSeconds() * 1000L;
        if (this.refreshPeriodInMillis > 0L) {
            long timerFrequency = 1L;
            String refreshRateStr = System.getProperty("com.sun.ejb.containers.readonly.timer.frequency", "1");
            try {
                timerFrequency = Integer.parseInt(refreshRateStr);
                if (timerFrequency < 0L) {
                    timerFrequency = 1L;
                }
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Invalid timer frequency " + refreshRateStr);
            }
            try {
                this.RELATIVE_TIME_CHECK_MODE = Boolean.valueOf(System.getProperty("com.sun.ejb.containers.readonly.relative.refresh.mode"));
                _logger.log(Level.FINE, "RELATIVE_TIME_CHECK_MODE: " + this.RELATIVE_TIME_CHECK_MODE);
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "(Ignorable) Exception while initializing RELATIVE_TIME_CHECK_MODE", ex);
            }
            Timer timer = this.ejbContainerUtilImpl.getTimer();
            if (this.RELATIVE_TIME_CHECK_MODE) {
                this.refreshTask = new CurrentTimeRefreshTask();
                timer.scheduleAtFixedRate(this.refreshTask, timerFrequency * 1000L, timerFrequency * 1000L);
            } else {
                this.refreshTask = new RefreshTask();
                timer.scheduleAtFixedRate(this.refreshTask, this.refreshPeriodInMillis, this.refreshPeriodInMillis);
            }
        } else {
            this.refreshPeriodInMillis = 0L;
        }
        for (int i = 0; i < 8192; ++i) {
            this.finderLocks[i] = new Object();
        }
        long l = idleTimeoutInMillis = this.cacheProp.cacheIdleTimeoutInSeconds <= 0 ? -1L : (long)this.cacheProp.cacheIdleTimeoutInSeconds * 1000L;
        if (this.cacheProp.maxCacheSize <= 0 && idleTimeoutInMillis <= 0L) {
            this.robCache = new UnboundedEJBObjectCache(this.ejbDescriptor.getName());
            this.robCache.init(8192, this.cacheProp.numberOfVictimsToSelect, 0L, 1.0f, null);
        } else {
            int cacheSize = this.cacheProp.maxCacheSize <= 0 ? 8192 : this.cacheProp.maxCacheSize;
            this.robCache = new FIFOEJBObjectCache(this.ejbDescriptor.getName());
            this.robCache.init(cacheSize, this.cacheProp.numberOfVictimsToSelect, idleTimeoutInMillis, 1.0f, null);
        }
        this.distributedReadOnlyBeanService = DistributedEJBServiceFactory.getDistributedEJBService().getDistributedReadOnlyBeanService();
        this.distributedReadOnlyBeanService.addReadOnlyBeanRefreshEventHandler(this.getContainerId(), this.getClassLoader(), this);
    }

    private void updateBeanLevelRefresh() {
        ++this.beanLevelSequenceNum;
        this.beanLevelLastRefreshRequestedAt = this.currentTimeInMillis;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "updating bean-level refresh for  read-only bean " + this.ejbDescriptor.getName() + " at " + new Date(this.beanLevelLastRefreshRequestedAt) + " beanLevelSequenceNum = " + this.beanLevelSequenceNum);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Clearing " + this.finderResultsCache.size() + " items from " + "finder results cache");
        }
        this.finderResultsCache = new ConcurrentHashMap<FinderResultsKey, FinderResultsValue>();
    }

    @Override
    protected void callEJBStore(EntityBean ejb, EntityContextImpl context) {
    }

    @Override
    protected ComponentContext _getContext(EjbInvocation inv) {
        ComponentContext ctx = super._getContext(inv);
        InvocationInfo info = inv.invocationInfo;
        if (info.isTxRequiredLocalCMPField && !inv.foundInTxCache) {
            EntityContextImpl entityCtx = (EntityContextImpl)ctx;
            super.afterBegin(entityCtx);
            inv.foundInTxCache = true;
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void callEJBLoad(EntityBean ejb, EntityContextImpl entityCtx, boolean activeTx) throws Exception {
        assert (entityCtx instanceof ReadOnlyContextImpl);
        ReadOnlyContextImpl context = (ReadOnlyContextImpl)entityCtx;
        ReadOnlyBeanInfo robInfo = context.getReadOnlyBeanInfo();
        int pkLevelSequenceNum = 0;
        long pkLastRefreshedAt = 0L;
        ReadOnlyBeanInfo readOnlyBeanInfo = robInfo;
        synchronized (readOnlyBeanInfo) {
            int currentBeanLevelSequenceNum = this.beanLevelSequenceNum;
            if (robInfo.beanLevelSequenceNum != currentBeanLevelSequenceNum) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "REFRESH DUE TO BEAN-LEVEL UPDATE: Bean-level sequence num = " + this.beanLevelSequenceNum + robInfo + " current time is " + new Date());
                }
                robInfo.refreshNeeded = true;
            } else if (this.RELATIVE_TIME_CHECK_MODE && this.refreshPeriodInMillis > 0L && this.currentTimeInMillis - robInfo.lastRefreshedAt > this.refreshPeriodInMillis) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "REFRESH DUE TO STALE PK: robInfo.lastRefreshedAt: " + robInfo.lastRefreshedAt + "; current (approx) time is " + this.currentTimeInMillis);
                }
                robInfo.refreshNeeded = true;
            }
            if (robInfo.refreshNeeded) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, " PK-LEVEL REFRESH : " + robInfo + " current time is " + new Date());
                }
                try {
                    if (this.isContainerManagedPers) {
                        BeanStateSynchronization beanStateSynch = (BeanStateSynchronization)ejb;
                        beanStateSynch.ejb__refresh(entityCtx.getPrimaryKey());
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, " PK-LEVEL REFRESH DONE :" + robInfo + " current time is " + new Date());
                        }
                    } else if (ejb instanceof BeanStateSynchronization) {
                        BeanStateSynchronization beanStateSynch = (BeanStateSynchronization)ejb;
                        beanStateSynch.ejb__refresh(entityCtx.getPrimaryKey());
                    }
                }
                finally {
                    robInfo.refreshNeeded = false;
                }
                this.updateAfterRefresh(robInfo);
            }
            pkLevelSequenceNum = robInfo.pkLevelSequenceNum;
            pkLastRefreshedAt = robInfo.lastRefreshedAt;
        }
        if (entityCtx.isNewlyActivated() || context.getPKLevelSequenceNum() != pkLevelSequenceNum) {
            this.callLoad(ejb, context, pkLevelSequenceNum, pkLastRefreshedAt, this.currentTimeInMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callLoad(EntityBean ejb, ReadOnlyContextImpl context, int pkLevelSequenceNum, long pkLastRefreshedAt, long currentTime) throws Exception {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Calling ejbLoad for read-only bean " + this.ejbDescriptor.getName() + " primary key " + context.getPrimaryKey() + " at " + new Date(currentTime));
        }
        try {
            context.setInEjbLoad(true);
            ejb.ejbLoad();
            if (pkLevelSequenceNum > 0) {
                context.setPKLevelSequenceNum(pkLevelSequenceNum);
            }
            context.setLastRefreshedAt(pkLastRefreshedAt);
        }
        finally {
            context.setInEjbLoad(false);
        }
    }

    @Override
    protected void callEJBRemove(EntityBean ejb, EntityContextImpl context) throws Exception {
        Object pk = context.getPrimaryKey();
        this.robCache.removeAll(pk);
    }

    @Override
    protected void doConcreteContainerShutdown(boolean appBeingUndeployed) {
        this.distributedReadOnlyBeanService.removeReadOnlyBeanRefreshEventHandler(this.getContainerId());
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
        this.robCache.clear();
        super.doConcreteContainerShutdown(appBeingUndeployed);
    }

    @Override
    protected void preInvokeNoTx(EjbInvocation inv) {
        EntityContextImpl context = (EntityContextImpl)inv.context;
        if (context.isInState(EJBContextImpl.BeanState.DESTROYED)) {
            return;
        }
        if (!inv.invocationInfo.isCreateHomeFinder) {
            EntityBean e = (EntityBean)context.getEJB();
            try {
                this.callEJBLoad(e, context, false);
            }
            catch (NoSuchEntityException ex) {
                _logger.log(Level.FINE, "Exception in preInvokeNoTx()", ex);
                this.forceDestroyBean(context);
                throw new NoSuchObjectLocalException("NoSuchEntityException thrown by ejbLoad, EJB instance discarded");
            }
            catch (Exception ex) {
                this.forceDestroyBean(context);
                throw new EJBException(ex);
            }
            context.setNewlyActivated(false);
        }
    }

    @Override
    protected void afterNewlyActivated(EntityContextImpl context) {
        ReadOnlyBeanInfo robInfo = this.addToCache(context.getPrimaryKey(), true);
        assert (context instanceof ReadOnlyContextImpl);
        ReadOnlyContextImpl readOnlyContext = (ReadOnlyContextImpl)context;
        readOnlyContext.setReadOnlyBeanInfo(robInfo);
    }

    @Override
    protected void addPooledEJB(EntityContextImpl ctx) {
        try {
            assert (ctx instanceof ReadOnlyContextImpl);
            ReadOnlyContextImpl readOnlyCtx = (ReadOnlyContextImpl)ctx;
            if (readOnlyCtx.getReadOnlyBeanInfo() != null) {
                readOnlyCtx.setReadOnlyBeanInfo(null);
                this.robCache.remove(ctx.getPrimaryKey(), true);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "entitybean.container.addPooledEJB", ex);
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ex);
            throw ejbEx;
        }
        finally {
            super.addPooledEJB(ctx);
        }
    }

    @Override
    protected void forceDestroyBean(EJBContextImpl context) {
        try {
            ReadOnlyContextImpl readOnlyCtx = (ReadOnlyContextImpl)context;
            if (readOnlyCtx.getReadOnlyBeanInfo() != null) {
                readOnlyCtx.setReadOnlyBeanInfo(null);
                this.robCache.remove(readOnlyCtx.getPrimaryKey(), true);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "entitybean.container.forceDestroyBean", ex);
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ex);
            throw ejbEx;
        }
        finally {
            super.forceDestroyBean(context);
        }
    }

    public void preInvoke(EjbInvocation inv) {
        if (inv.invocationInfo != null && inv.invocationInfo.startsWithCreate) {
            String msg = "Error for ejb " + this.ejbDescriptor.getName() + ". create is not allowed for read-only entity beans";
            if (this.isContainerManagedPers) {
                throw new EJBException(msg);
            }
            CreateException ce = new CreateException(msg);
            throw new BaseContainer.PreInvokeException((Exception)ce);
        }
        super.preInvoke(inv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeTargetBeanMethod(Method beanClassMethod, EjbInvocation inv, Object target, Object[] params, SecurityManager mgr) throws Throwable {
        Object returnValue = null;
        if (inv.invocationInfo.startsWithFind) {
            FinderResultsKey key = new FinderResultsKey(inv.method, params);
            FinderResultsValue value = this.finderResultsCache.get(key);
            if (value != null) {
                if (this.RELATIVE_TIME_CHECK_MODE && this.refreshPeriodInMillis > 0L) {
                    long timeLeft = this.currentTimeInMillis - value.lastRefreshedAt;
                    if (timeLeft >= this.refreshPeriodInMillis) {
                        returnValue = value.value;
                    }
                } else {
                    returnValue = value.value;
                }
            }
            if (returnValue == null) {
                int hashCode = key.getExtendedHC();
                if (hashCode < 0) {
                    hashCode = -hashCode;
                }
                int index = hashCode & 0x1FFF;
                Object object = this.finderLocks[index];
                synchronized (object) {
                    value = this.finderResultsCache.get(key);
                    if (value == null) {
                        returnValue = super.invokeTargetBeanMethod(beanClassMethod, inv, target, params, mgr);
                        this.finderResultsCache.put(key, new FinderResultsValue(returnValue, this.currentTimeInMillis));
                    } else {
                        returnValue = value.value;
                    }
                }
            }
        } else {
            returnValue = super.invokeTargetBeanMethod(beanClassMethod, inv, target, params, mgr);
        }
        return returnValue;
    }

    @Override
    protected void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException, RemoteException {
        String msg = "Error for ejb " + this.ejbDescriptor.getName() + ". remove is not allowed for read-only entity beans";
        if (this.isContainerManagedPers) {
            if (local) {
                throw new EJBException(msg);
            }
            throw new RemoteException(msg);
        }
    }

    @Override
    protected void initializeHome() throws Exception {
        super.initializeHome();
        if (this.isRemote) {
            ((ReadOnlyEJBHomeImpl)this.ejbHomeImpl).setReadOnlyBeanContainer(this);
        }
        if (this.isLocal) {
            ReadOnlyEJBLocalHomeImpl readOnlyLocalHomeImpl = (ReadOnlyEJBLocalHomeImpl)this.ejbLocalHomeImpl;
            readOnlyLocalHomeImpl.setReadOnlyBeanContainer(this);
        }
    }

    @Override
    protected EJBHomeInvocationHandler getEJBHomeInvocationHandler(Class homeIntfClass) throws Exception {
        return new ReadOnlyEJBHomeImpl((com.sun.enterprise.deployment.EjbDescriptor)this.ejbDescriptor, homeIntfClass);
    }

    @Override
    protected EJBLocalHomeInvocationHandler getEJBLocalHomeInvocationHandler(Class homeIntfClass) throws Exception {
        return new ReadOnlyEJBLocalHomeImpl((com.sun.enterprise.deployment.EjbDescriptor)this.ejbDescriptor, homeIntfClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefreshFlag(Object primaryKey) {
        try {
            this.handleRefreshRequest(primaryKey);
        }
        finally {
            this.distributedReadOnlyBeanService.notifyRefresh(this.getContainerId(), primaryKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRefreshRequest(Object primaryKey) {
        ReadOnlyBeanInfo robInfo = (ReadOnlyBeanInfo)this.robCache.get(primaryKey, false);
        if (robInfo != null) {
            ReadOnlyBeanInfo readOnlyBeanInfo = robInfo;
            synchronized (readOnlyBeanInfo) {
                robInfo.refreshNeeded = true;
                robInfo.lastRefreshRequestedAt = this.currentTimeInMillis;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Updating refresh time for read-only bean " + this.ejbDescriptor.getName() + " primary key " + primaryKey + " at " + new Date(robInfo.lastRefreshRequestedAt) + " pkLevelSequenceNum = " + robInfo.pkLevelSequenceNum);
                }
            }
        } else {
            _logger.log(Level.FINE, "Refresh event for unknown read-only bean PK = " + primaryKey + " at " + new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshAll() {
        try {
            this.handleRefreshAllRequest();
        }
        finally {
            this.distributedReadOnlyBeanService.notifyRefreshAll(this.getContainerId());
        }
    }

    @Override
    public void handleRefreshAllRequest() {
        _logger.log(Level.FINE, "Received refreshAll request...");
        this.updateBeanLevelRefresh();
    }

    @Override
    protected EntityContextImpl createEntityContextInstance(EntityBean ejb, EntityContainer entityContainer) {
        return new ReadOnlyContextImpl((EnterpriseBean)ejb, (BaseContainer)entityContainer);
    }

    private ReadOnlyBeanInfo addToCache(Object primaryKey, boolean incrementRefCount) {
        ReadOnlyBeanInfo robInfo = (ReadOnlyBeanInfo)this.robCache.get(primaryKey, incrementRefCount);
        if (robInfo == null) {
            ReadOnlyBeanInfo otherRobInfo;
            ReadOnlyBeanInfo newRobInfo = new ReadOnlyBeanInfo();
            newRobInfo.primaryKey = primaryKey;
            newRobInfo.beanLevelSequenceNum = -1;
            newRobInfo.refreshNeeded = true;
            newRobInfo.pkLevelSequenceNum = 1;
            newRobInfo.lastRefreshRequestedAt = 0L;
            newRobInfo.lastRefreshedAt = 0L;
            if (this.ejbDescriptor.isLocalInterfacesSupported()) {
                newRobInfo.cachedEjbLocalObject = this.getEJBLocalObjectForPrimaryKey(primaryKey);
            }
            if (this.ejbDescriptor.isRemoteInterfacesSupported()) {
                newRobInfo.cachedEjbObject = this.getEJBObjectStub(primaryKey, null);
            }
            robInfo = (otherRobInfo = (ReadOnlyBeanInfo)this.robCache.put(primaryKey, newRobInfo, incrementRefCount)) == null ? newRobInfo : otherRobInfo;
        }
        return robInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invokeFindByPrimaryKey(Method method, EjbInvocation inv, Object[] args) throws Throwable {
        ReadOnlyBeanInfo robInfo;
        Object returnValue = null;
        ReadOnlyBeanInfo readOnlyBeanInfo = robInfo = this.addToCache(args[0], false);
        synchronized (readOnlyBeanInfo) {
            Object object = returnValue = inv.isLocal ? robInfo.cachedEjbLocalObject : robInfo.cachedEjbObject;
            if (robInfo.refreshNeeded) {
                _logger.log(Level.FINE, "ReadOnlyBeanContainer calling ejb.ejbFindByPK... for pk=" + args[0]);
                returnValue = super.invokeFindByPrimaryKey(method, inv, args);
                robInfo.refreshNeeded = false;
                this.updateAfterRefresh(robInfo);
            }
        }
        return returnValue;
    }

    @Override
    public Object postFind(EjbInvocation inv, Object primaryKeys, Object[] findParams) throws FinderException {
        Object returnValue = super.postFind(inv, primaryKeys, findParams);
        if (!inv.method.getName().equals("findByPrimaryKey")) {
            if (primaryKeys instanceof Enumeration) {
                Enumeration e = (Enumeration)primaryKeys;
                while (e.hasMoreElements()) {
                    Object primaryKey = e.nextElement();
                    if (primaryKey == null) continue;
                    this.updateRobInfoAfterFinder(primaryKey);
                }
            } else if (primaryKeys instanceof Collection) {
                Collection c = (Collection)primaryKeys;
                for (Object primaryKey : c) {
                    if (primaryKey == null) continue;
                    this.updateRobInfoAfterFinder(primaryKey);
                }
            } else if (primaryKeys != null) {
                this.updateRobInfoAfterFinder(primaryKeys);
            }
        }
        return returnValue;
    }

    private void updateRobInfoAfterFinder(Object primaryKey) {
        this.addToCache(primaryKey, false);
    }

    private void updateAfterRefresh(ReadOnlyBeanInfo robInfo) {
        robInfo.beanLevelSequenceNum = this.beanLevelSequenceNum;
        ++robInfo.pkLevelSequenceNum;
        robInfo.lastRefreshedAt = this.currentTimeInMillis;
    }

    private static final class FinderResultsKey {
        private static final Object[] EMPTY_PARAMS = new Object[0];
        private Method finderMethod;
        private Object[] params;
        private int hc;
        private int extendedHC;

        public FinderResultsKey(Method method, Object[] params) {
            this.finderMethod = method;
            this.extendedHC = this.hc = this.finderMethod.hashCode();
            for (Object param : this.params = params == null ? EMPTY_PARAMS : params) {
                this.extendedHC += param.hashCode();
            }
        }

        public int hashCode() {
            return this.hc;
        }

        public int getExtendedHC() {
            return this.extendedHC;
        }

        public boolean equals(Object o) {
            boolean equal = false;
            if (o instanceof FinderResultsKey) {
                FinderResultsKey other = (FinderResultsKey)o;
                if (this.params.length == other.params.length && this.finderMethod.equals(other.finderMethod)) {
                    equal = true;
                    for (int i = 0; i < this.params.length; ++i) {
                        Object nextParam = this.params[i];
                        Object nextParamOther = other.params[i];
                        equal = nextParam instanceof EJBLocalObject ? this.compareEJBLocalObject((EJBLocalObject)nextParam, nextParamOther) : (nextParam instanceof EJBObject ? this.compareEJBObject((EJBObject)nextParam, nextParamOther) : nextParam.equals(nextParamOther));
                        if (!equal) break;
                    }
                }
            }
            return equal;
        }

        private boolean compareEJBLocalObject(EJBLocalObject localObj1, Object other) {
            boolean equal = false;
            if (other instanceof EJBLocalObject) {
                equal = localObj1.isIdentical((EJBLocalObject)other);
            }
            return equal;
        }

        private boolean compareEJBObject(EJBObject ejbObj1, Object other) {
            boolean equal = false;
            if (other instanceof EJBObject) {
                try {
                    equal = ejbObj1.isIdentical((EJBObject)other);
                }
                catch (RemoteException re) {
                    equal = false;
                }
            }
            return equal;
        }
    }

    private static final class FinderResultsValue {
        long lastRefreshedAt;
        Object value;

        public FinderResultsValue(Object v, long time) {
            this.value = v;
            this.lastRefreshedAt = time;
        }
    }

    private final class CurrentTimeRefreshTask
    extends TimerTask {
        private CurrentTimeRefreshTask() {
        }

        @Override
        public void run() {
            ReadOnlyBeanContainer.this.currentTimeInMillis = System.currentTimeMillis();
        }
    }

    private final class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        @Override
        public void run() {
            ReadOnlyBeanContainer.this.updateBeanLevelRefresh();
        }
    }
}

