/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.logging;

import com.sun.jdo.spi.persistence.utility.logging.AbstractLoggerFactory;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import com.sun.jdo.spi.persistence.utility.logging.LoggerJDK14;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.SimpleFormatter;
import org.glassfish.persistence.common.I18NHelper;

public class LoggerFactoryJDK14
extends AbstractLoggerFactory {
    private static final ResourceBundle _messages = I18NHelper.loadBundle(LoggerFactoryJDK14.class);

    protected static ResourceBundle getMessages() {
        return _messages;
    }

    protected LoggerJDK14 findLogger(String absoluteLoggerName) {
        return (LoggerJDK14)LogManager.getLogManager().getLogger(absoluteLoggerName);
    }

    @Override
    protected Logger createLogger(final String absoluteLoggerName, final String bundleName, final ClassLoader loader) {
        return (Logger)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                LoggerJDK14 logger = null;
                ClassLoader pushed = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    LoggerFactoryJDK14.this.setContextClassLoader(loader);
                }
                try {
                    logger = LoggerFactoryJDK14.this.createLogger(absoluteLoggerName, bundleName);
                    LogManager.getLogManager().addLogger(logger);
                    LoggerFactoryJDK14.this.configureFileHandler(logger);
                    LoggerJDK14 loggerJDK14 = logger;
                    return loggerJDK14;
                }
                catch (Exception ex) {
                    MessageFormat messageFormat = new MessageFormat(LoggerFactoryJDK14.getMessages().getString("errorlogger.create.exception"));
                    AbstractLoggerFactory.getErrorLogger().log(1000, messageFormat.format(new String[]{absoluteLoggerName}), ex);
                }
                finally {
                    LoggerFactoryJDK14.this.setContextClassLoader(pushed);
                }
                return logger;
            }
        });
    }

    protected void setContextClassLoader(ClassLoader loader) {
        if (loader != null) {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    protected LoggerJDK14 createLogger(String absoluteLoggerName, String bundleName) {
        LoggerJDK14 result = new LoggerJDK14(absoluteLoggerName, bundleName);
        return result;
    }

    protected void configureFileHandler(LoggerJDK14 logger) {
        String name = logger.getName();
        String baseName = name + ".FileHandler";
        LogManager logManager = LogManager.getLogManager();
        String pattern = logManager.getProperty(baseName + ".pattern");
        if (pattern != null) {
            int defaultLimit = 0;
            String limit = logManager.getProperty(baseName + ".limit");
            if (limit != null) {
                try {
                    defaultLimit = Integer.parseInt(limit);
                    if (defaultLimit < 0) {
                        defaultLimit = 0;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            int defaultCount = 1;
            String count = logManager.getProperty(baseName + ".count");
            if (count != null) {
                try {
                    defaultCount = Integer.parseInt(count);
                    if (defaultCount < 1) {
                        defaultCount = 1;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            boolean defaultAppend = false;
            String append = logManager.getProperty(baseName + ".append");
            if (append != null) {
                defaultAppend = Boolean.valueOf(append);
            }
            FileHandler fileHandler = null;
            try {
                fileHandler = new FileHandler(pattern, defaultLimit, defaultCount, defaultAppend);
            }
            catch (Exception e) {
                MessageFormat messageFormat = new MessageFormat(LoggerFactoryJDK14.getMessages().getString("errorlogger.filehandler.initialize.exception"));
                LoggerFactoryJDK14.getErrorLogger().log(900, messageFormat.format(new String[]{name}), e);
            }
            if (fileHandler != null) {
                String level = logManager.getProperty(baseName + ".level");
                if (level != null) {
                    try {
                        fileHandler.setLevel(Level.parse(level));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                Formatter defaultFormatter = null;
                String formatter = logManager.getProperty(baseName + ".formatter");
                if (formatter != null) {
                    try {
                        Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(formatter);
                        defaultFormatter = (Formatter)clz.newInstance();
                    }
                    catch (Exception e) {
                        MessageFormat messageFormat = new MessageFormat(LoggerFactoryJDK14.getMessages().getString("errorlogger.formatter.initialize.exception"));
                        LoggerFactoryJDK14.getErrorLogger().log(900, messageFormat.format(new String[]{name}), e);
                    }
                }
                if (defaultFormatter == null) {
                    defaultFormatter = new SimpleFormatter();
                }
                try {
                    fileHandler.setFormatter(defaultFormatter);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                logger.addHandler(fileHandler);
            }
        }
    }
}

