/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class BucketizedHashtable
implements Cloneable,
Map,
Serializable {
    private int bucketSize;
    private Hashtable[] hashtables = null;

    public BucketizedHashtable(int bucketSize, int initialCapacity, float loadFactor) {
        if (bucketSize <= 0 || initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.bucketSize = bucketSize;
        this.hashtables = new Hashtable[bucketSize];
        int initialHashtableSize = (int)Math.ceil((double)initialCapacity / (double)bucketSize);
        for (int i = 0; i < bucketSize; ++i) {
            this.hashtables[i] = new Hashtable(initialHashtableSize, loadFactor);
        }
    }

    public BucketizedHashtable(int bucketSize, int initialCapacity) {
        this(bucketSize, initialCapacity, 0.75f);
    }

    public BucketizedHashtable(int bucketSize) {
        this(bucketSize, 11 * bucketSize, 0.75f);
    }

    public BucketizedHashtable() {
        this(11, 121, 0.75f);
    }

    public Object get(Object key) {
        return this.hashtables[this.getBucketIndex(key)].get(key);
    }

    public Object remove(Object key) {
        return this.hashtables[this.getBucketIndex(key)].remove(key);
    }

    public Object put(Object key, Object value) {
        return this.hashtables[this.getBucketIndex(key)].put(key, value);
    }

    public void putAll(Map t) {
        if (t instanceof BucketizedHashtable) {
            BucketizedHashtable bt = (BucketizedHashtable)t;
            for (int i = 0; i < bt.bucketSize; ++i) {
                this.putAllFromMapWithEntrySet(bt.hashtables[i]);
            }
        } else {
            this.putAllFromMapWithEntrySet(t);
        }
    }

    public boolean containsKey(Object key) {
        return this.hashtables[this.getBucketIndex(key)].containsKey(key);
    }

    public boolean containsValue(Object value) {
        for (int i = 0; i < this.bucketSize; ++i) {
            if (!this.hashtables[i].containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        int totalSize = 0;
        for (int i = 0; i < this.bucketSize; ++i) {
            totalSize += this.hashtables[i].size();
        }
        return totalSize;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.bucketSize; ++i) {
            h += this.hashtables[i].hashCode();
        }
        return h;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.bucketSize; ++i) {
            if (this.hashtables[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        for (int i = 0; i < this.bucketSize; ++i) {
            this.hashtables[i].clear();
        }
    }

    public Set entrySet() {
        if (this.bucketSize == 1) {
            return this.hashtables[0].entrySet();
        }
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        if (this.bucketSize == 1) {
            return this.hashtables[0].keySet();
        }
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        if (this.bucketSize == 1) {
            return this.hashtables[0].values();
        }
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BucketizedHashtable)) {
            return false;
        }
        BucketizedHashtable bt = (BucketizedHashtable)o;
        if (bt.bucketSize != this.bucketSize || bt.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.bucketSize; ++i) {
            if (this.hashtables[i].equals(bt.hashtables[i])) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            BucketizedHashtable bt = (BucketizedHashtable)super.clone();
            bt.bucketSize = this.bucketSize;
            bt.hashtables = new Hashtable[this.bucketSize];
            for (int i = 0; i < this.bucketSize; ++i) {
                bt.hashtables[i] = (Hashtable)this.hashtables[i].clone();
            }
            return bt;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        buf.append(this.hashtables[0].toString());
        for (int i = 1; i < this.bucketSize; ++i) {
            buf.append(", ");
            buf.append(this.hashtables[i].toString());
        }
        buf.append("]");
        return buf.toString();
    }

    private void putAllFromMapWithEntrySet(Map t) {
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    private int getBucketIndex(Object key) {
        int index = key.hashCode() % this.bucketSize;
        return index >= 0 ? index : index + this.bucketSize;
    }
}

