/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.mapping.impl;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingReferenceKeyElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingTableElementImpl;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.dbschema.util.NameUtil;

public class MappingClassElementImpl
extends MappingElementImpl
implements MappingClassElement {
    public static final int CLONE_FIELDS = 1;
    public static final int CLONE_DEEP = 2;
    public static final int CLONE_MASK = 3;
    public static final int NAVIGABLE = 4;
    PersistenceClassElement _persistenceElement;
    private boolean _isModified;
    private int _properties;
    private ArrayList _tables;
    private ArrayList _fields;
    private static final int CURRENT_VERSION_NO = 5;
    private int versionNo = 5;
    private String _databaseRoot;
    private int _consistencyLevel = 0;

    public MappingClassElementImpl() {
        this((String)null);
    }

    public MappingClassElementImpl(String name) {
        super(name);
        this._properties |= 4;
    }

    public MappingClassElementImpl(PersistenceClassElement element) {
        this(element != null ? element.getName() : null);
        this.setPersistenceElement(element);
    }

    public int getVersionNumber() {
        return this.versionNo;
    }

    private void setVersionNumber(int version) {
        this.versionNo = version;
    }

    public boolean hasOldVersionNumber() {
        return this.getVersionNumber() < 5;
    }

    public static MappingClassElement forName(String name, Model model) {
        return model.getMappingClass(name);
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        boolean noChange = o != null && n != null && o.equals(n);
        super.firePropertyChange(name, o, n);
        if (!"modified".equals(name) && !noChange) {
            this.setModified(true);
        }
    }

    protected final void fireVetoableChange(String name, Object o, Object n) throws PropertyVetoException {
        boolean noChange = o != null && n != null && o.equals(n);
        super.fireVetoableChange(name, o, n);
        if (!"modified".equals(name) && !noChange) {
            this.fireVetoableChange("modified", Boolean.FALSE, Boolean.TRUE);
        }
    }

    public final PersistenceClassElement getPersistenceElement() {
        return this._persistenceElement;
    }

    public void setPersistenceElement(PersistenceClassElement element) {
        this._persistenceElement = element;
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void setModified(boolean flag) {
        boolean oldFlag = this.isModified();
        if (flag != oldFlag) {
            this._isModified = flag;
            this.firePropertyChange("modified", JavaTypeHelper.valueOf((boolean)oldFlag), JavaTypeHelper.valueOf((boolean)flag));
        }
    }

    public int getConsistencyLevel() {
        return this._consistencyLevel;
    }

    public void setConsistencyLevel(int level) throws ModelException {
        Integer old = new Integer(this.getConsistencyLevel());
        Integer newLevel = new Integer(level);
        try {
            this.fireVetoableChange("consistencyLevel", old, newLevel);
            this._consistencyLevel = level;
            this.firePropertyChange("consistencyLevel", old, newLevel);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public String getDatabaseRoot() {
        return this._databaseRoot;
    }

    public void setDatabaseRoot(SchemaElement root) throws ModelException {
        String old = this.getDatabaseRoot();
        String newRoot = root != null ? root.getName().getFullName() : null;
        try {
            this.fireVetoableChange("schema", old, newRoot);
            this._databaseRoot = newRoot;
            this.firePropertyChange("schema", old, newRoot);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public ArrayList getTables() {
        if (this._tables == null) {
            this._tables = new ArrayList();
        }
        return this._tables;
    }

    public MappingTableElement getTable(String name) {
        for (MappingTableElement table : this.getTables()) {
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addTable(TableElement table) throws ModelException {
        if (table == null) throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"mapping.table.null_argument"));
        ArrayList tables = this.getTables();
        if (tables.isEmpty()) {
            this.setPrimaryTable(table);
            return;
        } else {
            HashMap<MappingTableElement, ForeignKeyElement> newSecondaryTables = new HashMap<MappingTableElement, ForeignKeyElement>();
            Iterator<Object> iterator = tables.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                if (!((MappingTableElement)iterator.next()).isEqual(table)) continue;
                return;
            }
            for (MappingTableElement mappingTable : tables) {
                String absoluteTableName = NameUtil.getAbsoluteTableName((String)this._databaseRoot, (String)mappingTable.getTable());
                ForeignKeyElement[] foreignKeys = TableElement.forName((String)absoluteTableName).getForeignKeys();
                int count = foreignKeys != null ? foreignKeys.length : 0;
                for (int i = 0; i < count; ++i) {
                    ForeignKeyElement fk = foreignKeys[i];
                    if (table != fk.getReferencedTable()) continue;
                    newSecondaryTables.put(mappingTable, fk);
                    found = true;
                }
            }
            if (!found) throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"mapping.table.foreign_key_not_found", (Object)table));
            for (MappingTableElement mappingTable : newSecondaryTables.keySet()) {
                MappingReferenceKeyElement refKey = this.addSecondaryTable(mappingTable, table);
                refKey.addColumnPairs(((ForeignKeyElement)newSecondaryTables.get(mappingTable)).getColumnPairs());
            }
        }
    }

    public void setPrimaryTable(TableElement table) throws ModelException {
        UniqueKeyElement[] uniqueKeys;
        ArrayList tables = this.getTables();
        if (!tables.isEmpty()) {
            throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"mapping.table.primary_table_defined", (Object)table));
        }
        UniqueKeyElement key = table.getPrimaryKey();
        MappingTableElementImpl mappingTable = new MappingTableElementImpl(table, (MappingClassElement)this);
        SchemaElement schema = table.getDeclaringSchema();
        String currentRoot = this.getDatabaseRoot();
        if (currentRoot == null) {
            this.setDatabaseRoot(schema);
        } else if (!currentRoot.equals(schema.getName().getFullName())) {
            throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"mapping.table.schema_mismatch", (String)table.toString(), (String)currentRoot));
        }
        try {
            this.fireVetoableChange("tables", null, null);
            tables.add(mappingTable);
            this.firePropertyChange("tables", null, null);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
        if (key == null && (uniqueKeys = table.getUniqueKeys()) != null && uniqueKeys.length > 0) {
            key = uniqueKeys[0];
        }
        if (key != null) {
            ColumnElement[] columns = key.getColumns();
            int count = columns != null ? columns.length : 0;
            for (int i = 0; i < count; ++i) {
                mappingTable.addKeyColumn(columns[i]);
            }
        }
    }

    public MappingReferenceKeyElement addSecondaryTable(MappingTableElement parentTable, TableElement table) throws ModelException {
        ArrayList tables = this.getTables();
        if (parentTable == null || table == null) {
            throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"mapping.element.null_argument"));
        }
        if (!tables.contains(parentTable)) {
            throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"mapping.table.parent_table_not_found", (String)parentTable.getTable()));
        }
        Iterator iterator = parentTable.getReferencingKeys().iterator();
        MappingTableElementImpl mappingTable = new MappingTableElementImpl(table, (MappingClassElement)this);
        MappingReferenceKeyElementImpl key = new MappingReferenceKeyElementImpl(mappingTable);
        while (iterator.hasNext()) {
            MappingTableElement compareTable = ((MappingReferenceKeyElement)iterator.next()).getTable();
            if (!compareTable.isEqual(table)) continue;
            throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"mapping.table.secondary_table_defined", (Object[])new Object[]{table, parentTable.getTable()}));
        }
        try {
            this.fireVetoableChange("tables", null, null);
            parentTable.addReferencingKey(key);
            tables.add(mappingTable);
            this.firePropertyChange("tables", null, null);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
        return key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeTable(MappingTableElement table) throws ModelException {
        if (table == null) throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"mapping.element.null_argument"));
        ArrayList tables = this.getTables();
        Iterator iterator = null;
        boolean found = false;
        try {
            this.fireVetoableChange("tables", null, null);
            found = tables.remove(table);
            this.firePropertyChange("tables", null, null);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
        for (MappingTableElement nextTable : tables) {
            nextTable.removeReference(table);
        }
        if (!found) throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"mapping.element.element_not_removed", (Object)table));
        ArrayList<MappingFieldElementImpl> fieldsToRemove = new ArrayList<MappingFieldElementImpl>();
        for (MappingFieldElementImpl mappingFieldElementImpl : this.getFields()) {
            if (!mappingFieldElementImpl.isMappedToTable(table)) continue;
            fieldsToRemove.add(mappingFieldElementImpl);
        }
        for (MappingFieldElement mappingFieldElement : fieldsToRemove) {
            boolean versionField = mappingFieldElement.isVersion();
            this.removeField(mappingFieldElement);
            if (!versionField) continue;
            MappingFieldElementImpl mappingFieldElementImpl = new MappingFieldElementImpl(mappingFieldElement.getName(), this);
            mappingFieldElementImpl.setVersion(true);
            this.addField(mappingFieldElementImpl);
        }
    }

    public ArrayList getFields() {
        if (this._fields == null) {
            this._fields = new ArrayList();
        }
        return this._fields;
    }

    public MappingFieldElement getField(String name) {
        for (MappingFieldElement field : this.getFields()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public void addField(MappingFieldElement field) throws ModelException {
        ArrayList fields = this.getFields();
        if (!fields.contains(field)) {
            try {
                this.fireVetoableChange("fields", null, null);
                fields.add(field);
                this.firePropertyChange("fields", null, null);
            }
            catch (PropertyVetoException e) {
                throw new ModelVetoException(e);
            }
        }
    }

    public void removeField(MappingFieldElement field) throws ModelException {
        try {
            this.fireVetoableChange("fields", null, null);
            if (!this.getFields().remove(field)) {
                throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"mapping.element.element_not_removed", (Object)field));
            }
            this.firePropertyChange("fields", null, null);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    public List getVersionFields() {
        ArrayList<MappingFieldElement> versionFields = new ArrayList<MappingFieldElement>();
        if (16 == this.getConsistencyLevel()) {
            for (MappingFieldElement fieldCandidate : this.getFields()) {
                if (!fieldCandidate.isVersion()) continue;
                versionFields.add(fieldCandidate);
            }
        }
        return versionFields;
    }

    public boolean isNavigable() {
        return (this._properties & 4) > 0;
    }

    public void setNavigable(boolean flag) throws ModelException {
        Boolean old = JavaTypeHelper.valueOf((boolean)this.isNavigable());
        Boolean newFlag = JavaTypeHelper.valueOf((boolean)flag);
        try {
            this.fireVetoableChange("navigable", old, newFlag);
            this._properties = flag ? this._properties | 4 : this._properties & 0xFFFFFFFB;
            this.firePropertyChange("navigable", old, newFlag);
        }
        catch (PropertyVetoException e) {
            throw new ModelVetoException(e);
        }
    }

    protected static ArrayList toColumnObjects(String schemaName, ArrayList columnNames) {
        Iterator iterator = columnNames.iterator();
        ArrayList<DBMemberElement> objects = new ArrayList<DBMemberElement>();
        while (iterator.hasNext()) {
            String columnName = (String)iterator.next();
            String absoluteColumnName = NameUtil.getAbsoluteMemberName((String)schemaName, (String)columnName);
            TableElement table = TableElement.forName((String)NameUtil.getTableName((String)absoluteColumnName));
            objects.add(table.getMember(DBIdentifier.create((String)absoluteColumnName)));
        }
        return objects;
    }

    public String getKeyClass() {
        return this.getPersistenceElement().getKeyClass();
    }

    public void setFields(ArrayList fields) {
        this._fields = fields;
    }

    public int getProperties() {
        return this._properties;
    }

    public void postUnarchive() throws ModelException {
        switch (this.versionNo) {
            case 0: 
            case 1: {
                throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"file.incompatible_version", (String)this.getName()));
            }
            case 2: {
                this.stripSchemaName();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new ModelException(I18NHelper.getMessage((ResourceBundle)MappingClassElementImpl.getMessages(), (String)"file.incompatible_version", (String)this.getName()));
            }
        }
    }

    public void preArchive() {
        this.setVersionNumber(5);
    }

    protected void stripSchemaName() {
        Iterator i;
        String schemaName = null;
        if (this._tables != null && !this._tables.isEmpty()) {
            schemaName = NameUtil.getSchemaName((String)((MappingTableElement)this._tables.get(0)).getTable());
        }
        this._databaseRoot = schemaName;
        if (this._tables != null) {
            i = this._tables.iterator();
            while (i.hasNext()) {
                ((MappingTableElementImpl)i.next()).stripSchemaName();
            }
        }
        if (this._fields != null) {
            i = this._fields.iterator();
            while (i.hasNext()) {
                ((MappingFieldElementImpl)i.next()).stripSchemaName();
            }
        }
    }
}

