/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.ClassPath;
import com.sun.jdo.api.persistence.enhancer.util.ClassPathElement;
import com.sun.jdo.api.persistence.enhancer.util.DirectoryClassPackageEnumerator;
import com.sun.jdo.api.persistence.enhancer.util.FilePath;
import java.io.File;
import java.util.Enumeration;

class DirectoryClassPathElement
extends ClassPathElement {
    private File directory;
    private boolean exists;

    public ClassFileSource sourceOf(String className) {
        File f = this.fileOf(className);
        if (f != null && f.exists()) {
            return new ClassFileSource(className, f);
        }
        return null;
    }

    public Enumeration classesInPackage(String packageName) {
        if (!this.exists) {
            return null;
        }
        return new DirectoryClassPackageEnumerator(this.directory, packageName);
    }

    boolean matches(File matchDirectory) {
        String dir = FilePath.canonicalize(this.directory);
        String matchDir = FilePath.canonicalize(matchDirectory);
        return FilePath.canonicalNamesEqual(dir, matchDir);
    }

    DirectoryClassPathElement(File dirSpec) {
        this.directory = dirSpec;
        this.checkValid();
    }

    private File fileOf(String className) {
        if (this.exists && this.directory.isDirectory()) {
            StringBuffer newPath = new StringBuffer(this.directory.getPath());
            if (newPath.charAt(newPath.length() - 1) != File.separatorChar) {
                newPath.append(File.separatorChar);
            }
            newPath.append(ClassPath.fileNameOf(className));
            File f = new File(newPath.toString());
            if (f.isFile()) {
                return f;
            }
        }
        return null;
    }

    private boolean isValid() {
        return this.exists;
    }

    private void checkValid() {
        this.exists = this.directory.isDirectory();
    }
}

