/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import com.sun.jdo.api.persistence.enhancer.util.ClassPath;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class DirectoryClassPackageEnumerator
implements Enumeration,
FilenameFilter {
    private String[] matches;
    private int nextMatch = -1;
    String searchPackage;

    DirectoryClassPackageEnumerator(File directory, String packageName) {
        this.searchPackage = packageName;
        String packageDirName = directory.getPath() + File.separator + packageName.replace('/', File.separatorChar);
        File packageDir = new File(packageDirName);
        if (packageDir.isDirectory()) {
            this.matches = packageDir.list(this);
            if (this.matches != null && this.matches.length > 0) {
                this.nextMatch = 0;
            }
        }
    }

    public boolean hasMoreElements() {
        return this.nextMatch >= 0;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        String next = this.matches[this.nextMatch++];
        if (this.nextMatch >= this.matches.length) {
            this.nextMatch = -1;
        }
        return ClassPath.classNameOf(this.searchPackage + "/" + next);
    }

    public boolean accept(File dir, String name) {
        int nameLength = name.length();
        boolean isOk = nameLength > 6 && name.regionMatches(true, nameLength - 6, ".class", 0, 6);
        return isOk;
    }
}

