/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.connection;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;

public class SSLHostNameVerifier
implements HostnameVerifier {
    @Override
    public boolean verify(String hostname, SSLSession session) {
        if (session != null) {
            Certificate[] certs = null;
            try {
                certs = session.getPeerCertificates();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (certs == null) {
                String msg = LbLogUtil.getStringManager().getString("NoPeerCert", (Object)hostname);
                LbLogUtil.getLogger().warning(msg);
                return false;
            }
            for (int i = 0; i < certs.length; ++i) {
                if (certs[i] instanceof X509Certificate) {
                    X500Principal prin = ((X509Certificate)certs[i]).getSubjectX500Principal();
                    String hName = null;
                    String dn = prin.getName();
                    int cnIdx = dn.indexOf("CN=");
                    if (cnIdx != -1) {
                        String cnStr = dn.substring(cnIdx, dn.length());
                        int commaIdx = cnStr.indexOf(",");
                        if (commaIdx == -1) {
                            commaIdx = dn.length();
                        }
                        hName = dn.substring(cnIdx + 3, commaIdx);
                    }
                    if (!hostname.equals(hName)) continue;
                    return true;
                }
                String msg = LbLogUtil.getStringManager().getString("NotX905Cert", (Object)hostname);
                LbLogUtil.getLogger().warning(msg);
            }
            if (hostname.equals(session.getPeerHost())) {
                return true;
            }
        }
        if (session != null) {
            String msg = LbLogUtil.getStringManager().getString("NotCertMatch", (Object)hostname, (Object)new String(session.getId()));
            LbLogUtil.getLogger().warning(msg);
        }
        return false;
    }
}

