/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="create-jms-resource")
@PerLookup
@I18n(value="create.jms.resource")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DOMAIN})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.POST, path="create-jms-resource", description="create-jms-resource")})
public class CreateJMSResource
implements AdminCommand {
    @Param(name="resType")
    String resourceType;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(name="property", optional=true, separator=58)
    Properties props;
    @Param(optional=true)
    String target = "server";
    @Param(name="description", optional=true)
    String description;
    @Param(optional=true, defaultValue="false")
    Boolean force;
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Domain domain;
    private static final String QUEUE = "javax.jms.Queue";
    private static final String TOPIC = "javax.jms.Topic";
    private static final String QUEUE_CF = "javax.jms.QueueConnectionFactory";
    private static final String TOPIC_CF = "javax.jms.TopicConnectionFactory";
    private static final String UNIFIED_CF = "javax.jms.ConnectionFactory";
    private static final String DEFAULT_JMS_ADAPTER = "jmsra";
    private static final String DEFAULT_OPERAND = "DEFAULT";
    private static final String JNDINAME_APPENDER = "-Connection-Pool";
    private String jndiNameForConnectionPool;
    private static final String NAME = "Name";
    private static final String IMQ_DESTINATION_NAME = "imqDestinationName";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJMSResource.class);
    Hashtable mapping = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.resourceType == null) {
            report.setMessage(localStrings.getLocalString("create.jms.resource.noResourceType", "No Resoruce Type specified for JMS Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.jndiName == null) {
            report.setMessage(localStrings.getLocalString("create.jms.resource.noJndiName", "No JNDI name specified for JMS Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!(this.resourceType.equals(TOPIC_CF) || this.resourceType.equals(QUEUE_CF) || this.resourceType.equals(UNIFIED_CF) || this.resourceType.equals(TOPIC) || this.resourceType.equals(QUEUE))) {
            report.setMessage(localStrings.getLocalString("create.jms.resource.InvalidResourceType", "Invalid Resource Type specified for JMS Resource."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        this.jndiNameForConnectionPool = this.jndiName + JNDINAME_APPENDER;
        if (this.force.booleanValue()) {
            Resource res = null;
            res = this.resourceType.equals(TOPIC) || this.resourceType.equals(QUEUE) ? ConnectorsUtil.getResourceByName((Resources)this.domain.getResources(), AdminObjectResource.class, (String)this.jndiName) : ConnectorsUtil.getResourceByName((Resources)this.domain.getResources(), ConnectorResource.class, (String)this.jndiName);
            if (res != null) {
                ActionReport deleteReport = report.addSubActionsReport();
                ParameterMap parameters = new ParameterMap();
                parameters.set((Object)DEFAULT_OPERAND, (Object)this.jndiName);
                parameters.set((Object)"target", (Object)this.target);
                this.commandRunner.getCommandInvocation("delete-jms-resource", deleteReport, context.getSubject()).parameters(parameters).execute();
                if (ActionReport.ExitCode.FAILURE.equals((Object)deleteReport.getActionExitCode())) {
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        this.populateJmsRAMap();
        if (this.props != null) {
            Enumeration<Object> en = this.props.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String raKey = this.getMappedName(key);
                if (raKey == null) {
                    raKey = key;
                }
                this.props.put(raKey, (String)this.props.get(key));
                if (raKey.equals(key)) continue;
                this.props.remove(key);
            }
        }
        ActionReport subReport = report.addSubActionsReport();
        if (this.resourceType.equals(TOPIC_CF) || this.resourceType.equals(QUEUE_CF) || this.resourceType.equals(UNIFIED_CF)) {
            ConnectorConnectionPool cpool = (ConnectorConnectionPool)ConnectorsUtil.getResourceByName((Resources)this.domain.getResources(), ConnectorConnectionPool.class, (String)this.jndiNameForConnectionPool);
            boolean createdPool = false;
            if (cpool == null || !this.filterForTarget(this.jndiNameForConnectionPool)) {
                ParameterMap parameters = this.populateConnectionPoolParameters();
                this.commandRunner.getCommandInvocation("create-connector-connection-pool", subReport, context.getSubject()).parameters(parameters).execute();
                createdPool = true;
                if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                    report.setMessage(localStrings.getLocalString("create.jms.resource.cannotCreateConnectionPool", "Unable to create connection pool."));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
            ParameterMap params = this.populateConnectionResourceParameters();
            this.commandRunner.getCommandInvocation("create-connector-resource", subReport, context.getSubject()).parameters(params).execute();
            if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                report.setMessage(localStrings.getLocalString("create.jms.resource.cannotCreateConnectorResource", "Unable to create connection resource."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                if (createdPool) {
                    this.commandRunner.getCommandInvocation("delete-connector-connection-pool", subReport, context.getSubject()).parameters(this.populateConnectionPoolParameters()).execute();
                }
                return;
            }
        } else if (this.resourceType.equals(TOPIC) || this.resourceType.equals(QUEUE)) {
            ParameterMap aoAttrList = new ParameterMap();
            try {
                Properties properties = this.validateDestinationResourceProps(this.props, this.jndiName);
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<Object, Object> prop : properties.entrySet()) {
                    builder.append(prop.getKey()).append("=").append(prop.getValue()).append(":");
                }
                String propString = builder.toString();
                int lastColonIndex = propString.lastIndexOf(":");
                if (lastColonIndex >= 0) {
                    propString = propString.substring(0, lastColonIndex);
                }
                aoAttrList.set((Object)"property", (Object)propString);
            }
            catch (Exception e) {
                report.setMessage(localStrings.getLocalString("create.jms.resource.cannotCreateAdminObjectWithRootCause", "Unable to create admin object. Reason: " + e.getMessage(), new Object[]{e.getMessage()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            aoAttrList.set((Object)DEFAULT_OPERAND, (Object)this.jndiName);
            aoAttrList.set((Object)"restype", (Object)this.resourceType);
            aoAttrList.set((Object)"raname", (Object)DEFAULT_JMS_ADAPTER);
            aoAttrList.set((Object)"target", (Object)this.target);
            if (this.enabled != null) {
                aoAttrList.set((Object)"enabled", (Object)Boolean.toString(this.enabled));
            }
            this.commandRunner.getCommandInvocation("create-admin-object", subReport, context.getSubject()).parameters(aoAttrList).execute();
            if (ActionReport.ExitCode.FAILURE.equals((Object)subReport.getActionExitCode())) {
                report.setMessage(localStrings.getLocalString("create.jms.resource.cannotCreateAdminObject", "Unable to create admin object."));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }

    private boolean filterForTarget(String jndiName) {
        if (this.target != null) {
            List resourceRefs = null;
            Cluster cluster = this.domain.getClusterNamed(this.target);
            if (cluster != null) {
                resourceRefs = cluster.getResourceRef();
            } else {
                Server server = this.domain.getServerNamed(this.target);
                if (server != null) {
                    resourceRefs = server.getResourceRef();
                }
            }
            if (resourceRefs != null && resourceRefs.size() != 0) {
                for (ResourceRef resource : resourceRefs) {
                    if (!jndiName.equalsIgnoreCase(resource.getRef())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void populateJmsRAMap() {
        this.mapping = new Hashtable();
        this.mapping.put(IMQ_DESTINATION_NAME, NAME);
        this.mapping.put("imqDestinationDescription", "Description");
        this.mapping.put("imqConnectionURL", "ConnectionURL");
        this.mapping.put("imqDefaultUsername", "UserName");
        this.mapping.put("imqDefaultPassword", "Password");
        this.mapping.put("imqConfiguredClientID", "ClientId");
        this.mapping.put("imqAddressList", "AddressList");
        this.mapping.put("MessageServiceAddressList", "AddressList");
    }

    public String getMappedName(String key) {
        return (String)this.mapping.get(key);
    }

    private ParameterMap populateConnectionPoolParameters() {
        String steadyPoolSize = null;
        String maxPoolSize = null;
        String poolResizeQuantity = null;
        String idleTimeoutInSecs = null;
        String maxWaitTimeInMillis = null;
        String failAllConnections = null;
        String transactionSupport = null;
        ParameterMap parameters = new ParameterMap();
        if (this.props != null) {
            Enumeration<Object> keys = this.props.keys();
            Properties tmpProps = new Properties();
            while (keys.hasMoreElements()) {
                String password;
                String propKey = (String)keys.nextElement();
                if ("steady-pool-size".equals(propKey)) {
                    steadyPoolSize = this.props.getProperty(propKey);
                    continue;
                }
                if ("max-pool-size".equals(propKey)) {
                    maxPoolSize = this.props.getProperty(propKey);
                    continue;
                }
                if ("pool-resize-quantity".equals(propKey)) {
                    poolResizeQuantity = this.props.getProperty(propKey);
                    continue;
                }
                if ("idle-timeout-in-seconds".equals(propKey)) {
                    idleTimeoutInSecs = this.props.getProperty(propKey);
                    continue;
                }
                if ("max-wait-time-in-millis".equals(propKey)) {
                    maxWaitTimeInMillis = this.props.getProperty(propKey);
                    continue;
                }
                if ("transaction-support".equals(propKey)) {
                    transactionSupport = this.props.getProperty(propKey);
                    continue;
                }
                if ("fail-all-connections".equals(propKey)) {
                    failAllConnections = this.props.getProperty(propKey);
                    continue;
                }
                if ("AddressList".equals(propKey)) {
                    String addressListProp = this.props.getProperty(propKey);
                    this.props.setProperty(propKey, "\"" + addressListProp + "\"");
                } else if ("Password".equals(propKey) && this.isPasswordAlias(password = this.props.getProperty(propKey))) {
                    this.props.setProperty(propKey, "\"" + password + "\"");
                }
                tmpProps.setProperty(propKey, this.props.getProperty(propKey));
            }
            if (tmpProps.size() > 0) {
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<Object, Object> prop : tmpProps.entrySet()) {
                    builder.append(prop.getKey()).append("=").append(prop.getValue()).append(":");
                }
                String propString = builder.toString();
                int lastColonIndex = propString.lastIndexOf(":");
                if (lastColonIndex >= 0) {
                    propString = propString.substring(0, lastColonIndex);
                }
                parameters.set((Object)"property", (Object)propString);
            }
        }
        parameters.set((Object)DEFAULT_OPERAND, (Object)this.jndiNameForConnectionPool);
        parameters.set((Object)"poolname", (Object)this.jndiName);
        if (this.description != null) {
            parameters.set((Object)"description", (Object)this.description);
        }
        String raName = DEFAULT_JMS_ADAPTER;
        parameters.set((Object)"raname", (Object)raName);
        parameters.set((Object)"connectiondefinition", (Object)this.resourceType);
        parameters.set((Object)"maxpoolsize", (Object)(maxPoolSize == null ? "250" : maxPoolSize));
        parameters.set((Object)"steadypoolsize", (Object)(steadyPoolSize == null ? "1" : steadyPoolSize));
        if (poolResizeQuantity != null) {
            parameters.set((Object)"poolresize", (Object)poolResizeQuantity);
        }
        if (idleTimeoutInSecs != null) {
            parameters.set((Object)"idletimeout", (Object)idleTimeoutInSecs);
        }
        if (maxWaitTimeInMillis != null) {
            parameters.set((Object)"maxwait", (Object)maxWaitTimeInMillis);
        }
        if (failAllConnections != null) {
            parameters.set((Object)"failconnection", (Object)failAllConnections);
        }
        if (transactionSupport != null) {
            parameters.set((Object)"transactionsupport", (Object)transactionSupport);
        }
        return parameters;
    }

    private boolean isPasswordAlias(String password) {
        return password != null && password.startsWith("${ALIAS=");
    }

    private ParameterMap populateConnectionResourceParameters() {
        ParameterMap parameters = new ParameterMap();
        parameters.set((Object)"jndi_name", (Object)this.jndiName);
        parameters.set((Object)DEFAULT_OPERAND, (Object)this.jndiName);
        parameters.set((Object)"enabled", (Object)Boolean.toString(this.enabled));
        parameters.set((Object)"poolname", (Object)this.jndiNameForConnectionPool);
        parameters.set((Object)"target", (Object)this.target);
        if (this.description != null) {
            parameters.set((Object)"description", (Object)this.description);
        }
        return parameters;
    }

    private Properties validateDestinationResourceProps(Properties props, String jndiName) throws Exception {
        String providedDestinationName = null;
        if (props != null) {
            providedDestinationName = this.getProvidedDestinationName(props);
        } else {
            props = new Properties();
        }
        if (providedDestinationName != null) {
            if (!this.isSyntaxValid(providedDestinationName)) {
                throw new Exception(localStrings.getLocalString("admin.mbeans.rmb.destination_name_invalid", "Destination Resource " + jndiName + " has an invalid destination name " + providedDestinationName, new Object[]{jndiName, providedDestinationName}));
            }
        } else {
            String newDestName = this.computeDestinationName(jndiName);
            props.put(NAME, newDestName);
        }
        return props;
    }

    private String getProvidedDestinationName(Properties props) {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)props.get(key);
            if (!NAME.equals(key) && !IMQ_DESTINATION_NAME.equals(key) || value == null || value.length() == 0) continue;
            return value;
        }
        return null;
    }

    private boolean isSyntaxValid(String name) {
        if (name.startsWith("mq.")) {
            return false;
        }
        try {
            CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
            if (!asciiEncoder.canEncode(name)) {
                return false;
            }
        }
        catch (Exception asciiEncoder) {
            // empty catch block
        }
        char[] namechars = name.toCharArray();
        if (Character.isJavaIdentifierStart(namechars[0]) || namechars[0] == '*' || namechars[0] == '>') {
            for (int i = 1; i < namechars.length; ++i) {
                if (Character.isJavaIdentifierPart(namechars[i]) || namechars[i] == '.' || namechars[i] == '*' || namechars[i] == '>') continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private String computeDestinationName(String providedJndiName) {
        char[] jndiName = providedJndiName.toCharArray();
        char[] finalName = new char[jndiName.length];
        finalName[0] = Character.isJavaIdentifierStart(jndiName[0]) ? jndiName[0] : 95;
        for (int i = 1; i < jndiName.length; ++i) {
            finalName[i] = Character.isJavaIdentifierPart(jndiName[i]) ? jndiName[i] : 95;
        }
        return new String(finalName);
    }
}

