/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-jms-resources")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.jms.resources")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DOMAIN})
public class ListJMSResources
implements AdminCommand {
    private static final String JMSRA = "jmsra";
    private static final String QUEUE = "javax.jms.Queue";
    private static final String TOPIC = "javax.jms.Topic";
    private static final String QUEUE_CF = "javax.jms.QueueConnectionFactory";
    private static final String TOPIC_CF = "javax.jms.TopicConnectionFactory";
    private static final String UNIFIED_CF = "javax.jms.ConnectionFactory";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListJMSResources.class);
    @Param(name="resType", optional=true)
    String resourceType;
    @Param(primary=true, optional=true)
    String target = "server";
    @Inject
    Domain domain;
    @Inject
    Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ArrayList<String> list = new ArrayList<String>();
        Properties extraProperties = new Properties();
        Collection adminObjectResourceList = this.domain.getResources().getResources(AdminObjectResource.class);
        Collection connectorResourcesList = this.domain.getResources().getResources(ConnectorResource.class);
        Object[] connectorResources = connectorResourcesList.toArray();
        Object[] adminObjectResources = adminObjectResourceList.toArray();
        if (this.resourceType == null) {
            try {
                for (Object r : adminObjectResources) {
                    AdminObjectResource adminObject = (AdminObjectResource)r;
                    if (!JMSRA.equalsIgnoreCase(adminObject.getResAdapter())) continue;
                    list.add(adminObject.getJndiName());
                }
                for (Object c : connectorResources) {
                    ConnectorResource cr = (ConnectorResource)c;
                    ConnectorConnectionPool cp = (ConnectorConnectionPool)this.domain.getResources().getResourceByName(ConnectorConnectionPool.class, cr.getPoolName());
                    if (cp == null || !JMSRA.equalsIgnoreCase(cp.getResourceAdapterName())) continue;
                    list.add(cr.getJndiName());
                }
                if (list.isEmpty()) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(localStrings.getLocalString("nothingToList", "Nothing to list."));
                    extraProperties.put("jmsResources", list);
                } else {
                    List<String> resourceList = null;
                    resourceList = CommandTarget.DOMAIN.isValid(this.habitat, this.target) ? list : this.filterListForTarget(list);
                    if (resourceList == null) {
                        resourceList = list;
                    }
                    for (String jndiName : resourceList) {
                        ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                        part.setMessage(jndiName);
                    }
                    extraProperties.put("jmsResources", resourceList);
                }
                report.setExtraProperties(extraProperties);
            }
            catch (Exception e) {
                report.setMessage(localStrings.getLocalString("list.jms.resources.fail", "Unable to list JMS Resources") + " " + e.getLocalizedMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
                return;
            }
        }
        if (this.resourceType.equals(TOPIC_CF) || this.resourceType.equals(QUEUE_CF) || this.resourceType.equals(UNIFIED_CF)) {
            for (Object c : connectorResources) {
                ConnectorResource cr = (ConnectorResource)c;
                ConnectorConnectionPool cp = (ConnectorConnectionPool)this.domain.getResources().getResourceByName(ConnectorConnectionPool.class, cr.getPoolName());
                if (cp == null || !this.resourceType.equals(cp.getConnectionDefinitionName()) || !JMSRA.equalsIgnoreCase(cp.getResourceAdapterName())) continue;
                list.add(cp.getName());
            }
        } else if (this.resourceType.equals(TOPIC) || this.resourceType.equals(QUEUE)) {
            for (Object r : adminObjectResources) {
                AdminObjectResource res = (AdminObjectResource)r;
                if (!this.resourceType.equals(res.getResType())) continue;
                list.add(res.getJndiName());
            }
        }
        List resourceList = this.filterListForTarget(list);
        for (String jndiName : list) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(jndiName);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private List filterListForTarget(List<String> list) {
        ArrayList<String> resourceList = new ArrayList<String>();
        if (this.target != null) {
            List resourceRefs = null;
            Cluster cluster = this.domain.getClusterNamed(this.target);
            if (cluster != null) {
                resourceRefs = cluster.getResourceRef();
            } else {
                Server server = this.domain.getServerNamed(this.target);
                if (server != null) {
                    resourceRefs = server.getResourceRef();
                }
            }
            if (resourceRefs != null && resourceRefs.size() != 0) {
                for (String jndiName : list) {
                    for (ResourceRef resource : resourceRefs) {
                        if (!jndiName.equals(resource.getRef())) continue;
                        resourceList.add(jndiName);
                    }
                }
            }
        }
        return resourceList;
    }
}

