/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-jms-host")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jms.host")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteJMSHost
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJMSHost.class);
    @Param(optional=true)
    String target = "server";
    @Param(name="jms_host_name", primary=true)
    String jmsHostName;
    Config config;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Cluster cluster;
        Server targetServer;
        ActionReport report = context.getActionReport();
        Config targetConfig = this.domain.getConfigNamed(this.target);
        if (targetConfig != null) {
            this.config = targetConfig;
        }
        if ((targetServer = this.domain.getServerNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
        }
        if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
            this.config = this.domain.getConfigNamed(cluster.getConfigRef());
        }
        if (this.jmsHostName == null) {
            report.setMessage(localStrings.getLocalString("delete.jms.host.noHostName", "No JMS Host Name specified for JMS Host."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        JmsService jmsService = this.config.getJmsService();
        if (jmsService == null) {
            report.setMessage(localStrings.getLocalString("list.jms.host.invalidTarget", "Invalid Target specified."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        JmsHost jmsHost = null;
        for (JmsHost r : jmsService.getJmsHost()) {
            if (!this.jmsHostName.equals(r.getName())) continue;
            jmsHost = r;
            break;
        }
        if (jmsHost == null) {
            report.setMessage(localStrings.getLocalString("list.jms.host.noJmsHostFound", "JMS Host {0} does not exist.", new Object[]{this.jmsHostName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        final JmsHost jHost = jmsHost;
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<JmsService>(){

                public Object run(JmsService param) throws PropertyVetoException, TransactionFailure {
                    return param.getJmsHost().remove(jHost);
                }
            }, (ConfigBeanProxy)jmsService);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.jms.host.fail", "Unable to delete jms host {0}.", new Object[]{this.jmsHostName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

