/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar.uninstaller;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class GlassFishOSGiModuleUninstaller
implements BundleActivator,
BundleListener {
    private static Logger logger = Logger.getLogger("embedded-glassfish");
    private final String uberSymbolicName = "org.glassfish.embedded.glassfish-activator";
    private Bundle myself;

    public void start(BundleContext bundleContext) throws Exception {
        this.myself = bundleContext.getBundle();
        bundleContext.addBundleListener((BundleListener)this);
        logger.info("EmbeddedGlassFishUninstaller started");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        logger.info("EmbeddedGlassFishUninstaller stopped");
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        String uninstalledBundle;
        if (bundleEvent.getType() == 16 && "org.glassfish.embedded.glassfish-activator".equals(uninstalledBundle = bundleEvent.getBundle().getSymbolicName())) {
            logger.info("Embedded GlassFish UberJar is uninstalled. Hence uninstalling all the GlassFish bundles.");
            BundleContext context = this.myself.getBundleContext();
            ArrayList<Bundle> uninstalled = new ArrayList<Bundle>();
            logger.info("BundleContext = " + String.valueOf(context));
            for (Bundle b : context.getBundles()) {
                if (b.getLocation().indexOf("glassfish-embedded") == -1) continue;
                try {
                    b.uninstall();
                    uninstalled.add(b);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            logger.info("Finished uninstalling all GlassFish bundles");
        }
    }
}

