/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar.builder.installroot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class InstallRootBuilderUtil {
    private static final Logger logger = Logger.getLogger("embedded-glassfish");
    private static String resourceroot = "glassfish8/glassfish/";

    public static void buildInstallRoot(String installRoot) throws Exception {
        String resourceName;
        ClassLoader cl = InstallRootBuilderUtil.class.getClassLoader();
        URL resource = cl.getResource(resourceName = resourceroot + "lib/");
        URLConnection urlConn = resource.openConnection();
        if (urlConn instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection)urlConn).getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.indexOf(resourceName) == -1 || entryName.endsWith("/")) continue;
                InstallRootBuilderUtil.copy(cl.getResourceAsStream(entryName), installRoot, entryName.substring(entryName.indexOf(resourceName) + resourceroot.length()));
            }
            jarFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream stream, String destDir, String path) {
        if (stream != null) {
            try {
                File f = new File(destDir, path);
                if (!f.exists()) {
                    f.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(new File(destDir, path));
                    byte[] data = new byte[2048];
                    int count = 0;
                    while ((count = stream.read(data)) != -1) {
                        fos.write(data, 0, count);
                    }
                    logger.fine("Created " + String.valueOf(f));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

