/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar.builder.installroot;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.uberjar.builder.installroot.InstallRootBuilderUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class InstallRootBuilder
implements BundleActivator {
    private static final Logger logger = Logger.getLogger("embedded-glassfish");
    private static String resourceroot = "glassfish8/glassfish/";

    public void start(BundleContext context) throws Exception {
        String installRoot = context.getProperty("com.sun.aas.installRoot");
        this.buildInstallRoot(context.getBundle(), installRoot);
    }

    public void stop(BundleContext context) throws Exception {
        logger.fine("InstallRootBuilder stopped");
    }

    public void buildInstallRoot(Bundle bundle, String installRoot) throws Exception {
        List<String> resources = this.getResources(bundle, resourceroot + "lib/");
        for (String resource : resources) {
            InstallRootBuilderUtil.copy(bundle.getResource(resource).openConnection().getInputStream(), installRoot, resource.substring(resourceroot.length()));
        }
    }

    private List<String> getResources(Bundle b, String ... subpaths) {
        ArrayList<String> resources = new ArrayList<String>();
        if (subpaths == null || subpaths.length == 0) {
            subpaths = new String[]{"/"};
        }
        for (String subpath : subpaths) {
            Enumeration e = b.getEntryPaths(subpath);
            while (e != null && e.hasMoreElements()) {
                String entryPath = (String)e.nextElement();
                if (entryPath.endsWith("/")) {
                    resources.addAll(this.getResources(b, entryPath));
                    continue;
                }
                resources.add(entryPath);
            }
        }
        return resources;
    }
}

