/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar.activator;

import com.sun.enterprise.glassfish.bootstrap.cfg.OsgiPlatform;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;

public class UberJarGlassFishActivator
implements BundleActivator {
    private static Logger logger = Logger.getLogger("embedded-glassfish");
    private static final String UBER_JAR_URI = "org.glassfish.embedded.osgimain.jarURI";
    public static final String AUTO_START_BUNDLES_PROP = "org.glassfish.embedded.osgimain.autostartBundles";

    public void start(BundleContext bundleContext) throws Exception {
        this.privilegedStart(bundleContext);
    }

    private void privilegedStart(final BundleContext bundleContext) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    Properties props = new Properties();
                    props.setProperty("GlassFish_Platform", OsgiPlatform.Felix.name());
                    logger.info("ThreadContextClassLoader = " + String.valueOf(Thread.currentThread().getContextClassLoader()) + ", classloader = " + String.valueOf(this.getClass().getClassLoader()));
                    Framework framework = (Framework)bundleContext.getBundle(0L);
                    logger.info("framework bundle = " + String.valueOf(framework));
                    props.put("Framework", framework);
                    props.setProperty(UberJarGlassFishActivator.UBER_JAR_URI, bundleContext.getBundle().getLocation());
                    long startTime = System.currentTimeMillis();
                    GlassFishRuntime gfr = GlassFishRuntime.bootstrap(new BootstrapProperties(props), this.getClass().getClassLoader());
                    long timeTaken = System.currentTimeMillis() - startTime;
                    logger.info("created gfr = " + String.valueOf(gfr) + ", timeTaken = " + timeTaken);
                    startTime = System.currentTimeMillis();
                    GlassFish gf = gfr.newGlassFish(new GlassFishProperties(props));
                    timeTaken = System.currentTimeMillis() - startTime;
                    System.out.println("created gf = " + String.valueOf(gf) + ", timeTaken = " + timeTaken);
                    startTime = System.currentTimeMillis();
                    gf.start();
                    timeTaken = System.currentTimeMillis() - startTime;
                    System.out.println("started gf, timeTaken = " + timeTaken);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return null;
            }
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        logger.info("EmbeddedGlassFishActivator is stopped");
    }
}

