/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar.bootstrap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFish;

public class Util {
    private static Logger logger = Logger.getLogger("embedded-glassfish");
    private static final Map<String, GlassFish> gfMap = new HashMap<String, GlassFish>();
    private static String MODULES_DIR_PREFIX = "modules";
    private static String MODULES_DIR_SUFFIX = "_jar/";
    private static final String JARFILE_URL_PREFIX = "jar:file:";
    private static final String JARENTRY_PREFIX = "!/";

    public static Logger getLogger() {
        return logger;
    }

    public static synchronized void addServer(String serverId, GlassFish glassfish) {
        gfMap.put(serverId, glassfish);
    }

    public static synchronized void removeServer(String serverId) {
        gfMap.remove(serverId);
    }

    public static GlassFish getServer(String serverId) {
        return gfMap.get(serverId);
    }

    public static URI whichJar(Class clazz) {
        logger.finer("ResourceName = " + clazz.getName().replace(".", "/") + ".class");
        URL url = clazz.getClassLoader().getResource(clazz.getName().replace(".", "/") + ".class");
        logger.finer("url = " + String.valueOf(url));
        if (url != null) {
            URLConnection con = null;
            try {
                con = url.openConnection();
                logger.finer("con = " + String.valueOf(con));
                if (con instanceof JarURLConnection) {
                    return ((JarURLConnection)JarURLConnection.class.cast(con)).getJarFileURL().toURI();
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isUber(URI uri) {
        String uriString = uri.toString();
        String jarFileName = uriString.substring(uriString.lastIndexOf("/") + 1);
        return jarFileName.indexOf("glassfish-embedded") != -1;
    }

    public static List<URL> getModuleJarURLs(File modulesJarFile) {
        ArrayList<URL> moduleJarURLs = new ArrayList<URL>();
        try (JarFile modulesJar = new JarFile(modulesJarFile);){
            Enumeration<JarEntry> entries = modulesJar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.isDirectory() || !entry.getName().startsWith(MODULES_DIR_PREFIX) || !entry.getName().endsWith(MODULES_DIR_SUFFIX)) continue;
                moduleJarURLs.add(new URL(JARFILE_URL_PREFIX + modulesJar.getName() + JARENTRY_PREFIX + entry.getName()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return moduleJarURLs;
    }

    static void copyWithoutClose(InputStream in, FileOutputStream out, long size) throws IOException {
        ReadableByteChannel inChannel = Channels.newChannel(in);
        FileChannel outChannel = out.getChannel();
        outChannel.transferFrom(inChannel, 0L, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(InputStream in, FileOutputStream out, long size) throws IOException {
        try {
            Util.copyWithoutClose(in, out, size);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

