TCK Results
===========

As required by the
[Eclipse Foundation Technology Compatibility Kit License](https://www.eclipse.org/legal/tck.php),
following is a summary of the TCK results for releases of Jakarta Concurrency.

# 2.3 Certification Request

- [x] Organization Name ("Organization") and, if applicable, URL: <br/>
  Eclipse Foundation
- [x] Product Name, Version and download URL (if applicable): <br/>
  [GlassFish 5.1](https://eclipse-ee4j.github.io/glassfish/download)
- [x] Specification Name, Version and download URL: <br/>
   [Jakarta Server Pages 2.3](https://jakarta.ee/specifications/pages/2.3/)
- [x] TCK Version, digital SHA-256 fingerprint and download URL: <br/>
  [Jakarta Server Pages TCK 2.3.0](https://download.eclipse.org/jakartaee/pages/2.3/eclipse-pages-tck-2.3.0.zip), SHA-256: 38dc605251653f6ec69a6f3c3f5fb678f0e4305a9abd8a7e47781c1ebad0e7e8
- [x] Public URL of TCK Results Summary: <br/>
  [TCK results summary](https://eclipse-ee4j.github.io/glassfish/certifications/jakarta-pages/2.3/TCK-Results)
- [x] Any Additional Specification Certification Requirements: <br/>
  None
- [x] Java runtime used to run the implementation: <br/>
  Oracle JDK 1.8.0_202
- [x] Summary of the information for the certification environment, operating system, cloud, ...: <br/>
  Linux
- [x] By checking this box I acknowledge that the Organization I represent accepts the terms of the [EFTL](https://www.eclipse.org/legal/tck.php).
- [x] By checking this box I attest that all TCK requirements have been met, including any compatibility rules.

Test results:

```
[javatest.batch] Number of Tests Passed      = 704
[javatest.batch] Number of Tests Failed      = 0
[javatest.batch] Number of Tests with Errors = 0
[javatest.batch] ********************************************************************************
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/arrayelresolver/URLClient.java#arrayElResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/beanelresolver/URLClient.java#beanElResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/compelresolver/URLClient.java#compositeElResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/createmethexpr/URLClient.java#createMethodExpressionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/createvalexpr/URLClient.java#createValueExpressionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/elresolver/URLClient.java#elResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/listelresolver/URLClient.java#listElResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/mapelresolver/URLClient.java#mapElResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/methodinfo/URLClient.java#methodInfoTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/resourcebundleelresolver/URLClient.java#resourceBundleElResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_el/valexpression/URLClient.java#valueExpressionEvaluateTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/elexception/URLClient.java#elExceptionCauseCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/elexception/URLClient.java#elExceptionCauseMessageCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/elexception/URLClient.java#elExceptionDefaultCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/elexception/URLClient.java#elExceptionGetRootCauseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/elexception/URLClient.java#elExceptionMessageCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/elexception/URLClient.java#elExceptionToStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/elparseexception/URLClient.java#elParseExceptionDefaultCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/elparseexception/URLClient.java#elParseExceptionMessageCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/expression/URLClient.java#expressionEvaluateTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/expressionevaluator/URLClient.java#expressionEvaluatorEvaluateTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/expressionevaluator/URLClient.java#expressionEvaluatorParseExpressionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/implicitobjelresolver/URLClient.java#implicitObjElResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/scopedattrelresolver/URLClient.java#scopedAttrElResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/el/variableresolver/URLClient.java#variableResolverResolveVariableTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/errordata/URLClient.java#errorDataConstructorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/errordata/URLClient.java#errorDataGetRequestURITest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/errordata/URLClient.java#errorDataGetServletNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/errordata/URLClient.java#errorDataGetStatusCodeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/errordata/URLClient.java#errorDataGetThrowableTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspapplicationcontext/URLClient.java#addELResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspapplicationcontext/URLClient.java#invokeIllegalStateExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspengineinfo/URLClient.java#jspEngineInfoGetSpecificationVersionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspexception/URLClient.java#jspExceptionCauseCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspexception/URLClient.java#jspExceptionCauseMessageCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspexception/URLClient.java#jspExceptionDefaultCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspexception/URLClient.java#jspExceptionGetRootCauseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspexception/URLClient.java#jspExceptionMessageCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspfactory/URLClient.java#jspFactoryGetDefaultFactoryTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspfactory/URLClient.java#jspFactoryGetEngineInfoTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspfactory/URLClient.java#jspFactoryGetPageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jsptagexception/URLClient.java#jspTagExceptionCauseCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jsptagexception/URLClient.java#jspTagExceptionCauseMessageCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jsptagexception/URLClient.java#jspTagExceptionDefaultCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jsptagexception/URLClient.java#jspTagExceptionMessageCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterClearBufferTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterClearIOExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterClearTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterCloseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterFlushTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterGetBufferSizeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterGetRemainingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterIsAutoFlushTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterNewLineTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintBooleanTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintCharArrayTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintCharTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintDoubleTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintFloatTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintIntTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnBooleanTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnCharArrayTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnCharTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnDoubleTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnFloatTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnIntTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnLongTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnNullStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnObjectTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintlnTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintLongTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintNullStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintObjectTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/jspwriter/URLClient.java#jspWriterPrintStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextFindAttributeNullNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextFindAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextForwardContextPathTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextForwardIllegalStateExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextForwardPagePathTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetAttributeInScopeIllegalArgumentExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetAttributeNamesInScopeIllegalScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetAttributeNamesInScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetAttributeNPETest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetAttributeScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetAttributesScopeNullNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetErrorDataTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetExpressionEvaluatorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetOutTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetRequestTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetResponseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetServletConfigTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetServletContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetSessionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetSetAttributeInScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetSetAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextGetVariableResolverTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextHandlePageExceptionExcNPETest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextHandlePageExceptionExcTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextHandlePageExceptionThrNPETest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextHandlePageExceptionThrTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextIncludeContextPathTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextIncludeFlushFalseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextIncludeFlushIOExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextIncludeFlushServletExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextIncludeFlushTrueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextIncludeIOExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextIncludePagePathTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextIncludeServletExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextPushPopBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextRemoveAttributeFromScopeIllegalScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextRemoveAttributeFromScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextRemoveAttributeNullNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextRemoveAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextSetAttributeInScopeIllegalArgumentExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextSetAttributeInScopeNPETest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextSetAttributeNPETest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/pagecontext/URLClient.java#pageContextSetAttributeNullValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/skippageexception/URLClient.java#skipPageExceptionCauseCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/skippageexception/URLClient.java#skipPageExceptionCauseMessageCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/skippageexception/URLClient.java#skipPageExceptionDefaultCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/skippageexception/URLClient.java#skipPageExceptionMessageCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodycontent/URLClient.java#bodyContentClearBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodycontent/URLClient.java#bodyContentFlushTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodycontent/URLClient.java#bodyContentGetStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodycontent/URLClient.java#bodyContentReadWriteTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodycontent/URLClient.java#bodyContentWriteOutTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportDoAfterBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportDoEndTagTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportDoStartTagTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportEmptyTagTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportEvalBodyBufferedTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportEvalBodyIncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportGetBodyContentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportGetPreviousOutTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportSkipBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/bodytagsupport/URLClient.java#bodyTagSupportVariableSynchronizationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/dynamicattributes/URLClient.java#dynamicAttributesExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/dynamicattributes/URLClient.java#dynamicAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/functioninfo/URLClient.java#functionInfoGetFunctionClassTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/functioninfo/URLClient.java#functionInfoGetFunctionSignatureTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/functioninfo/URLClient.java#functionInfoGetNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/jspidconsumer/URLClient.java#multipleJspIdTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/jspidconsumer/URLClient.java#sameJspIdTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/jspidconsumer/URLClient.java#setJspIdTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/pagedata/URLClient.java#pageDataTagFileTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/pagedata/URLClient.java#pageDataTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#emptySetJspBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#jspFragmentGetJspContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#noParentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#simpleTagSupportDoTagDefaultTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#simpleTagSupportFindAncestorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#simpleTagSupportGetSetJspBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#simpleTagSupportGetSetJspContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#simpleTagSupportGetSetParentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#simpleTagSupportSkipPageExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#simpleTagSupportVariableSynchronizationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/simpletagsupport/URLClient.java#tagHandlerCacheTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagadapter/URLClient.java#tagAdapterCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagadapter/URLClient.java#tagAdapterDoEndTagTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagadapter/URLClient.java#tagAdapterDoStartTagTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagadapter/URLClient.java#tagAdapterGetParentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagadapter/URLClient.java#tagAdapterReleaseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagadapter/URLClient.java#tagAdapterSetPageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagadapter/URLClient.java#tagAdapterSetParentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagadapter/URLClient.java#tagAdapterValidationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagattributeinfo/URLClient.java#tagAttributeInfoCanBeRequestTimeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagattributeinfo/URLClient.java#tagAttributeInfoGetIdAttribute
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagattributeinfo/URLClient.java#tagAttributeInfoGetNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagattributeinfo/URLClient.java#tagAttributeInfoGetTypeNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagattributeinfo/URLClient.java#tagAttributeInfoIsFragmentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagattributeinfo/URLClient.java#tagAttributeInfoIsRequiredTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagattributeinfo/URLClient.java#tagAttributeInfoToStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagdata/URLClient.java#tagDataConstructorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagdata/URLClient.java#tagDataGetAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagdata/URLClient.java#tagDataGetAttributeStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagdata/URLClient.java#tagDataGetAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagdata/URLClient.java#tagDataSetAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagextrainfo/URLClient.java#tagExtraInfoTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagfileinfo/URLClient.java#tagFileInfoGetNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagfileinfo/URLClient.java#tagFileInfoGetPathTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagfileinfo/URLClient.java#tagFileInfoGetTagInfoTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetBodyContentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetDisplayNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetInfoStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetLargeIconTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetSmallIconTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetTagClassNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetTagExtraInfoTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetTagLibraryTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetTagNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoGetTagVariableInfosTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoHasDynamicAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoSetTagExtraInfoTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taginfo/URLClient.java#tagInfoSetTagLibraryTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetFunctionsTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetFunctionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetInfoStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetPrefixStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetReliableURNTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetRequiredVersionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetShortNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetTagFilesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetTagFileTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetTagLibraryInfosTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetTagsTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetTagTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryinfo/URLClient.java#tagLibraryInfoGetURITest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryvalidator/URLClient.java#tagLibraryValidatorAPITest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/taglibraryvalidator/URLClient.java#tagLibraryValidatorTranslationFailureTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportDoAfterBodyDefaultValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportDoAfterBodyEvalBodyAgainTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportDoAfterBodySkipBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportDoEndTagDefaultValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportDoEndTagEvalPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportDoEndTagSkipPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportDoStartEvalBodyIncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportDoStartSkipBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportDoStartTagDefaultValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportFindAncestorWithClassTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportGetSetValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportGetValuesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportRemoveValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportTagInitializationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagsupport/URLClient.java#tagSupportVariableSynchronizationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagvariableinfo/URLClient.java#tagVariableInfoGetClassNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagvariableinfo/URLClient.java#tagVariableInfoGetDeclareTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagvariableinfo/URLClient.java#tagVariableInfoGetNameFromAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagvariableinfo/URLClient.java#tagVariableInfoGetNameGivenTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/tagvariableinfo/URLClient.java#tagVariableInfoGetScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/trycatchfinally/URLClient.java#tryCatchFinallyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/variableinfo/URLClient.java#variableInfoCtorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/variableinfo/URLClient.java#variableInfoGetClassNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/variableinfo/URLClient.java#variableInfoGetDeclareTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/variableinfo/URLClient.java#variableInfoGetScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/api/javax_servlet/jsp/tagext/variableinfo/URLClient.java#variableInfoGetVarNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/charsequence/URLClient.java#deferredSyntaxAllowedAsLiteralFalseActionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/charsequence/URLClient.java#deferredSyntaxAllowedAsLiteralFalseTemplateTextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/charsequence/URLClient.java#deferredSyntaxAllowedAsLiteralTrueActionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/charsequence/URLClient.java#deferredSyntaxAllowedAsLiteralTrueTemplateTextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/charsequence/URLClient.java#noDeferredSyntaxAllowedAsLiteralActionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/charsequence/URLClient.java#noDeferredSyntaxAllowedAsLiteralTemplateTextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/elevaluation/URLClient.java#elEvaluation23WebApplicationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/elevaluation/URLClient.java#elEvaluationConfigurationFalseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/elevaluation/URLClient.java#elEvaluationConfigurationTrueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/elevaluation/URLClient.java#elEvaluationPageDirectiveOverrideTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/elevaluation/URLClient.java#elEvaluationUnspecifiedTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/encoding/URLClient.java#jspConfigurationDifferentEncodingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/encoding/URLClient.java#jspConfigurationEncodingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/encoding/URLClient.java#jspConfigurationSameEncodingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/general/URLClient.java#identicalMappingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/general/URLClient.java#moreSpecificMappingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/general/URLClient.java#mostSpecificMappingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/includes/URLClient.java#jspConfigurationIncludes2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/includes/URLClient.java#jspConfigurationIncludes3Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/includes/URLClient.java#jspConfigurationIncludesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/scripting/URLClient.java#jspConfigurationScriptingFalseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/scripting/URLClient.java#jspConfigurationScriptingTrueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/scripting/URLClient.java#jspConfigurationScriptingUnspecifiedTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/xml/URLClient.java#jspConfigurationIsXmlFalseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/xml/URLClient.java#jspConfigurationIsXmlTrueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/configuration/xml/URLClient.java#jspConfigurationIsXmlUnspecTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeDuplicatedAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeDynamicAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeElementInteractionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeEmptyBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeFragmentNonScriptingBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeFragmentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeNameRequiredAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeNoAttributeFoundTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeQNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeRtExprTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeTrimTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/attribute/URLClient.java#jspAttributeUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/body/URLClient.java#jspBodyEmptyBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/body/URLClient.java#jspBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/body/URLClient.java#jspBodyUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/declaration/URLClient.java#jspDeclarationUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyInvalidApplicationScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyInvalidPageScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyInvalidRequestScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyInvalidScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyInvalidSessionScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyJspAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyNonEmptyBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyNoVarVarReaderScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyVarReaderTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyVarTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#jspDoBodyVarVarReaderTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#negativeJspDoBodyUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/dobody/URLClient.java#positiveJspDoBodyUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/element/URLClient.java#jspElementDynamicAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/element/URLClient.java#jspElementJspAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/element/URLClient.java#jspElementJspBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/element/URLClient.java#jspElementNameReqAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/element/URLClient.java#jspElementTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/expression/URLClient.java#jspExpressionUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/forward/URLClient.java#positiveForwardCtxRelativeHtmlTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/forward/URLClient.java#positiveForwardCtxRelativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/forward/URLClient.java#positiveForwardPageRelativeHtmlTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/forward/URLClient.java#positiveForwardPageRelativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/forward/URLClient.java#positiveRequestAttrCtxRelativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/forward/URLClient.java#positiveRequestAttrPageRelativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/forward/URLClient.java#unbufferedWriteForwardTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/getproperty/URLClient.java#nullPropertyValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/getproperty/URLClient.java#positiveGetPropsTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#dynamicDynamicTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#dynamicStaticTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#includeMappedServletTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#positiveIncludeCtxRelativeHtmlTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#positiveIncludeCtxRelativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#positiveIncludeForwardTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#positiveIncludePageRelative2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#positiveIncludePageRelativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#positiveRequestAttrCtxRelativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#positiveRequestAttrPageRelativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#staticDynamicTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/include/URLClient.java#staticStaticTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspFragmentNullTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeFragmentReqAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeInvalidScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeJspAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeNonEmptyBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeNotInSessionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeNoVarVarReaderTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeVarReaderTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeVarTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/invoke/URLClient.java#jspInvokeVarVarReaderTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#doctypeSystemPublicTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#doctypeSystemTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#jspOutputBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#jspOutputJspRootOmitDeclDefaultTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#jspOutputOmitDeclDefaultTagTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#jspOutputOmitDeclDefaultTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#jspOutputOmitDeclValidValuesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#jspOutputUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#negativeDoctypePublicNoSystemTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#negativeDoctypeRootTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#negativeMultipleDoctypeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/output/URLClient.java#simpleDefaultTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/param/URLClient.java#jspParamAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/param/URLClient.java#jspParamForwardTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/param/URLClient.java#jspParamIncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/param/URLClient.java#jspParamUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/plugin/URLClient.java#jspFallbackBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/plugin/URLClient.java#jspFallbackUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/plugin/URLClient.java#jspParamsBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/plugin/URLClient.java#jspParamsUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/plugin/URLClient.java#jspPluginDynamicAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/plugin/URLClient.java#jspPluginInvalidTypeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/plugin/URLClient.java#jspPluginJspAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/plugin/URLClient.java#jspPluginTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/root/URLClient.java#jspRootJspBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/root/URLClient.java#jspRootUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/root/URLClient.java#jspRootVersionAttrAllowableValuesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/root/URLClient.java#jspRootVersionAttrInvalidValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/root/URLClient.java#jspRootVersionReqAttrTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/scriptlet/URLClient.java#jspScriptletUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveBeanPropertyEditorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetBooleanObjTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetBooleanPrimTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetByteObjTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetBytePrimTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetCharObjTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetCharPrimTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetDoubleObjTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetDoublePrimTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetFloatObjTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetFloatPrimTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetIndexedPropTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetIntObjTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetIntPrimTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetLongObjTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetLongPrimTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetPropAllTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetPropNoParamTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetPropParamTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetPropReqTimeDoubleQuotesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetPropReqTimeSingleQuotesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/setproperty/URLClient.java#positiveSetPropValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/text/URLClient.java#jspTextBodyRestrictionsTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/text/URLClient.java#jspTextUsageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#defaultScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#negativeClassCastExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#negativeDuplicateIDFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#negativeInvalidScopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#negativeSessionScopeFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#negativeTypeAssignableTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#positiveApplicationScopedObjectTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#positiveBeanNameTypeCastTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#positiveBeanNameTypeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#positiveBodyNewTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#positiveClassTypeCastTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#positiveNoBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#positivePageScopedObjectTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#positiveRequestScopedObjectTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#positiveSessionScopedObjectTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#requestTimeBeanNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean/URLClient.java#serBeanNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean2/URLClient.java#blockSCopeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean2/URLClient.java#existingWithBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean2/URLClient.java#inScriptlessTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean2/URLClient.java#noClassNoBeanNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/actions/usebean2/URLClient.java#unrestrictedBodyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/include/URLClient.java#positiveIncludeCtxRelativeDirectiveTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/include/URLClient.java#positiveIncludePageRelativeDirectiveTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#deferredSyntaxAllowedAsLiteralFalseActionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#deferredSyntaxAllowedAsLiteralFalseTemplateTextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#deferredSyntaxAllowedAsLiteralTrueActionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#deferredSyntaxAllowedAsLiteralTrueTemplateTextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#errorPageExceptionAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#implicitImportHttpTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#implicitImportJspTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#implicitImportLangTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#implicitImportServletTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#isELIgnoredFalseActionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#isELIgnoredFalseTemplateTextDollarTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#isELIgnoredFalseTemplateTextPoundTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#isELIgnoredTrueActionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#isELIgnoredTrueTemplateTextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeBuffAutoflushTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeBufferOverflowExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeBufferSuffixTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateAutoFlushFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateAutoFlushFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateBufferFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateBufferFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateContentFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateContentFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateErrorPageFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateErrorPageFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateExtendsFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateExtendsFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateInfoFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateInfoFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateIsELIgnoredFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateIsELIgnoredFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateIsErrorPageFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateIsErrorPageFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateIsThreadSafeFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateIsThreadSafeFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateLanguageFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateLanguageFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateSessionFatalTranslationError2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeDuplicateSessionFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeImportIoTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeImportUtilTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeMultiplePageEncodingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#negativeSessionFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveBuffAutoflushTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveBuffCreateTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveContentTypeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDefaultIsErrorPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateAutoFlushTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateBufferTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateContentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateErrorPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateExtendsTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateInfoTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateIsELIgnoredTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateIsErrorPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateIsThreadSafeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateLanguageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveDuplicateSessionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveErrorPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveExtendsTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveImportTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveInfoTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveLangTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveMultipleImportTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveSessionDefaultTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/page/URLClient.java#positiveSessionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/directives/taglib/URLClient.java#positiveTagLibTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/implicitobjects/URLClient.java#checkApplicationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/implicitobjects/URLClient.java#checkConfigTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/implicitobjects/URLClient.java#checkExceptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/implicitobjects/URLClient.java#checkOutTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/implicitobjects/URLClient.java#checkPageContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/implicitobjects/URLClient.java#checkPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/implicitobjects/URLClient.java#checkRequestTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/implicitobjects/URLClient.java#checkResponseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/implicitobjects/URLClient.java#checkSessionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/declaration/URLClient.java#positiveDeclarationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elAttributeSearchTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elBinaryOperatorParenthesesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elBinaryOperators1Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elBinaryOperators2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elBinaryOperators3Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elBinaryOperators4Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elBooleanCoercionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elBooleanLiteralTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elCharacterCoercionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elEmptyOperatorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elFloatingPointLiteralTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elFunctionInvocationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elIntegerLiteralTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elInvocationAndUsageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elNonExistingFunctionNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elNonMatchingFunctionSignatureTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elNonStaticPublicFunctionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elNullLiteralTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elNumberCoercionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elOtherTypeCoercionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elPrimitiveBoxedTypeConversionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elRelationalOperators1Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elRelationalOperators2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elStaticAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elStringCoercionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elStringLiteralTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elTernaryOperatorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elUnaryOperators1Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/el/URLClient.java#elUnaryOperators2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/escaping/URLClient.java#positiveEscapingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/expressions/URLClient.java#positiveExprCommentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/expressions/URLClient.java#positiveExprTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/expressions/URLClient.java#positiveExprWhiteSpaceTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/core_syntax/scripting/scriptlet/URLClient.java#positiveScriptletTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#allowedDynamicAttributeValueTypesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#dynamicAttributeSetterMethodTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#eLDeferredMethodStringLiteralErrorTest1
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#eLDeferredMethodStringLiteralErrorTest2
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#eLDeferredMethodStringLiteralTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#eLDeferredValueCoercionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#eLJspVersionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#negativeELDeferredMethodValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#negativeELDeferredValueValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#positiveELDeferredMethodValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#positiveELDeferredValueValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#tagLibraryPoundTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/jsp/URLClient.java#templateTextPoundTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#compositeExprEval1Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#compositeExprEval2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#dotAndIndexOperatorsSameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#eLSyntaxEscapeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#literalExprAsMethodExpr1Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#literalExprAsMethodExpr2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#literalExprEval1Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#literalExprEval2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#parseOnceEvalManyTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#poundDollarSameMeaningTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#rValueCoercion1Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/el/language/URLClient.java#rValueCoercion2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nBomByteSequencesUTF16BETest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nBomByteSequencesUTF16LETest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nBomByteSequencesUTF8Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nBomErrorReportingTest1
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nBomErrorReportingTest2
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nBomErrorReportingTest3
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nBomLegalCharacterEncodingTest1
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nBomLegalCharacterEncodingTest2
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nEncodingMismatchTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nIncludedContentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nStandardPageResponseEncodingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nUnsupportedEncodingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/i18n/URLClient.java#i18nXmlPageResponseEncodingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/elements/URLClient.java#directiveIncludeInJspPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/elements/URLClient.java#directiveIncludeLocationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/elements/URLClient.java#directivePageInJspPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/elements/URLClient.java#jspRootPrefixTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/elements/URLClient.java#negativeJspRootTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/elements/URLClient.java#scriptingInJspPageTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/elements/URLClient.java#scriptingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/general/URLClient.java#identifyByConfigTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/general/URLClient.java#identifyByExtensionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/general/URLClient.java#identifyByJspRootTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/general/URLClient.java#invalidPlainURITest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/general/URLClient.java#negativeDTDValidationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/general/URLClient.java#negativeWellFormednessTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/jspdocument/general/URLClient.java#tagDependentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/misc/precompilation/URLClient.java#precompileFalseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/misc/precompilation/URLClient.java#precompileNegativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/misc/precompilation/URLClient.java#precompileNoValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/misc/precompilation/URLClient.java#precompileTrueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#defaultFragmentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#defaultRequiredTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#defaultRtexprvalueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#defaultTypeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#deferredMethodMinimumJspVersionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#deferredMethodSignatureMinimumJspVersionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#deferredValueMinimumJspVersionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#deferredValueTypeMinimumJspVersionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#negativeFragmentRtexprvalueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#negativeFragmentTypeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#negativeName1IncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#negativeName1Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#negativeName2IncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#negativeName2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#negativeName3IncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#negativeName3Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute20/URLClient.java#negativeTypeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute21/URLClient.java#bothDeferredMethodAndSignatureTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute21/URLClient.java#bothDeferredValueTypeAndDeferredValueTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute21/URLClient.java#defaultDeferredMethod1Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute21/URLClient.java#defaultDeferredMethod2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute21/URLClient.java#defaultDeferredMethodSignatureTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute21/URLClient.java#defaultDeferredValue1Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute21/URLClient.java#defaultDeferredValue2Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute21/URLClient.java#deferredValueTypeNotSpecifiedTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/attribute21/URLClient.java#onlyOneOfDeferredValueOrDeferredMethodTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/general/URLClient.java#negativeAttributeDirectiveTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/general/URLClient.java#negativeIncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/general/URLClient.java#negativePageDirectiveTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/general/URLClient.java#negativeTagDirectiveTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/general/URLClient.java#negativeVariableDirectiveTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/general/URLClient.java#positiveIncludeContextRelativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/general/URLClient.java#positiveIncludePageRelativeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/general/URLClient.java#positiveTaglibTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#deferredValueMinimumJspVersionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#dynamicAttributesNoUriTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#implicitImportHttpTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#implicitImportJspTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#implicitImportLangTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#implicitImportServletTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeBodyContentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeDuplicateBodyContentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeDuplicateDescriptionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeDuplicateDisplayNameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeDuplicateDynamicAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeDuplicateExampleTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeDuplicateIsELIgnoredFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeDuplicateLanguageFatalTranslationErrorTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeDuplicateLargeIconTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeDuplicateSmallIconTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeMultiplePageEncodingTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#negativeUnrecognizedAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#positiveDuplicateAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#positiveImportTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#positiveLangTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag20/URLClient.java#positiveMultipleImportTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag21/URLClient.java#deferredSyntaxAllowedAsLiteralFalseActionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag21/URLClient.java#deferredSyntaxAllowedAsLiteralFalseTemplateTextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag21/URLClient.java#deferredSyntaxAllowedAsLiteralTrueActionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/tag21/URLClient.java#deferredSyntaxAllowedAsLiteralTrueTemplateTextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#falseDeclareTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeAliasAttributeSameIncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeAliasAttributeSameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeAliasNameGivenTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameFromAttributeNoAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameFromAttributeNotRequiredTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameFromAttributeNotStringTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameFromAttributeRtexprTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameFromAttributeSameIncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameFromAttributeSameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameGivenBothTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameGivenDynamicIncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameGivenDynamicTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameGivenNeitherTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameGivenSameIncludeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#negativeNameGivenSameTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#positiveDeclareTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#positiveVariableClassTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#syncAtBeginNameFromAttributeTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#syncAtBeginTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#syncAtEndTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#syncNestedTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#syncRemoveAtBeginTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#syncRemoveAtEndTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/directives/variable/URLClient.java#syncRemoveNestedTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/implicitobjects/URLClient.java#checkApplicationTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/implicitobjects/URLClient.java#checkConfigTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/implicitobjects/URLClient.java#checkJspContextTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/implicitobjects/URLClient.java#checkOutTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/implicitobjects/URLClient.java#checkRequestTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/implicitobjects/URLClient.java#checkResponseTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/implicitobjects/URLClient.java#checkSessionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/packaging/URLClient.java#implicitTldAdditionalElementsTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/packaging/URLClient.java#implicitTldDefaultJspVersionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/packaging/URLClient.java#implicitTldMinimumJspVersionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/packaging/URLClient.java#implicitTldReservedName20Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/packaging/URLClient.java#implicitTldReservedName21Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/packaging/URLClient.java#jspTagFilePackagedJarIgnoredTagTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/packaging/URLClient.java#jspTagFilePackagedJarTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/packaging/URLClient.java#jspTagFilePackagedWarTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/packaging/URLClient.java#jspTagFilePackagedWarTldTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/packaging/URLClient.java#tldImplicitTldJspVersionNotMatchTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/semantics/URLClient.java#jspTagSemanticsAttributeNotSpecifiedTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/semantics/URLClient.java#jspTagSemanticsDeclaredAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/semantics/URLClient.java#jspTagSemanticsDynamicAttributesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/semantics/URLClient.java#jspTagSemanticsJspContextWrapperScopesTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/semantics/URLClient.java#jspTagSemanticsJspContextWrapperTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/semantics/URLClient.java#semanticsInvokeClassicTagTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/semantics/URLClient.java#semanticsInvokeSimpleTagTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tagfiles/semantics/URLClient.java#semanticsJspForwardTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#listenerTldTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#negativeJSPPrefixTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#negativeTaglibAfterActionTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#tld12DefaultBodyContentTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#tldExplicitWebXmlPrecedenceTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#tldResourcePathDirectTldReference
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#tldResourcePathJsp11Test
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#tldResourcePathMultiTldJarTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#tldResourcePathWebInfUriTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#tldResourcePathWebXmlTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#tldResPathAbsUriNotFoundTest
[javatest.batch] PASSED........com/sun/ts/tests/jsp/spec/tldres/URLClient.java#tldResPathRelativeUriTest
[javatest.batch] PASSED........com/sun/ts/tests/signaturetest/jsp/JSPSigTest.java#signatureTest
[javatest.batch] 
[javatest.batch] Sep 2, 2019 10:20:19 AM Finished executing all tests, wait for cleanup...
[javatest.batch] Sep 2, 2019 10:20:19 AM Harness done with cleanup from test run.
[javatest.batch] Total time = 1,150s
[javatest.batch] Setup time = 0s
[javatest.batch] Cleanup time = 0s
[javatest.batch] Test results: passed: 704
```
