/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.full.deployment;

import com.sun.enterprise.deployment.EarType;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Service;

@Service(name="ear")
public class EarSniffer
extends GenericSniffer {
    @Inject
    EarType earType;
    @Inject
    ServiceLocator locator;
    private static final List<String> deploymentConfigurationPaths = EarSniffer.initDeploymentConfigurationPaths();

    public EarSniffer() {
        super("ear", "META-INF/application.xml", null);
    }

    public String[] getContainersNames() {
        return new String[]{"org.glassfish.javaee.full.deployment.EarContainer"};
    }

    public boolean handles(DeploymentContext context) {
        ArchiveType archiveType = (ArchiveType)this.habitat.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        if (archiveType != null && !this.supportsArchiveType(archiveType)) {
            return false;
        }
        return DeploymentUtils.isArchiveOfType((ReadableArchive)context.getSource(), (ArchiveType)this.earType, (DeploymentContext)context, (ServiceLocator)this.locator);
    }

    public boolean handles(ReadableArchive location) {
        return DeploymentUtils.isArchiveOfType((ReadableArchive)location, (ArchiveType)this.earType, (ServiceLocator)this.locator);
    }

    public boolean isUserVisible() {
        return true;
    }

    public boolean isJavaEE() {
        return true;
    }

    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.equals((Object)this.earType);
    }

    private static List<String> initDeploymentConfigurationPaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("META-INF/application.xml");
        result.add("META-INF/sun-application.xml");
        result.add("META-INF/glassfish-application.xml");
        result.add("META-INF/weblogic-application.xml");
        return result;
    }

    protected List<String> getDeploymentConfigurationPaths() {
        return deploymentConfigurationPaths;
    }
}

