/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-libraries")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-libraries", description="List libraries")})
public class ListLibrariesCommand
implements AdminCommand {
    @Param(optional=true, acceptableValues="common, ext, app")
    String type = "common";
    @Inject
    ServerEnvironment env;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListLibrariesCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        File libDir = this.env.getLibPath();
        if (this.type.equals("ext")) {
            libDir = new File(libDir, "ext");
        } else if (this.type.equals("app")) {
            libDir = new File(libDir, "applibs");
        }
        ActionReport.MessagePart part = report.getTopMessagePart();
        for (File libFile : FileUtils.listFiles((File)libDir)) {
            if (!libFile.isFile()) continue;
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(libFile.getName());
        }
    }
}

