/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import java.io.Serializable;

public abstract class BaseConfig
implements Serializable {
    protected String jndiName = null;
    protected String contextInfo = null;
    protected String contextInfoEnabled;

    public int parseInt(String strValue, int defaultValue) {
        if (strValue != null) {
            try {
                int intValue = Integer.parseInt(strValue);
                return intValue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public long parseLong(String strValue, long defaultValue) {
        if (strValue != null) {
            try {
                long longValue = Long.parseLong(strValue);
                return longValue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public BaseConfig(String jndiName, String contextInfo, String contextInfoEnabled) {
        this.jndiName = jndiName;
        this.contextInfo = contextInfo;
        this.contextInfoEnabled = contextInfoEnabled;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getContextInfo() {
        return this.contextInfo;
    }

    public String getContextInfoEnabled() {
        return this.contextInfoEnabled;
    }

    abstract TYPE getType();

    public static enum TYPE {
        MANAGED_EXECUTOR_SERVICE,
        MANAGED_SCHEDULED_EXECUTOR_SERVICE,
        MANAGED_THREAD_FACTORY,
        CONTEXT_SERVICE;

    }
}

