/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.beans.Introspector;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.glassfish.api.Param;
import org.glassfish.api.admin.ExecuteOn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandModel {
    private static final String ASADMIN_CMD_PREFIX = "AS_ADMIN_";

    public abstract String getCommandName();

    public abstract String getLocalizedDescription();

    public abstract String getUsageText();

    public abstract ParamModel getModelFor(String var1);

    public abstract Collection<String> getParametersNames();

    public abstract Class<?> getCommandClass();

    public abstract ExecuteOn getClusteringAttributes();

    public Collection<ParamModel> getParameters() {
        ArrayList<ParamModel> copy = new ArrayList<ParamModel>();
        for (String name : this.getParametersNames()) {
            copy.add(this.getModelFor(name));
        }
        return copy;
    }

    public static String getParamName(Param param, AnnotatedElement annotated) {
        String name = param.name();
        if (name.equals("")) {
            if (annotated instanceof Field) {
                name = ((Field)annotated).getName();
            }
            if (annotated instanceof Method) {
                name = ((Method)annotated).getName().substring(3);
                name = Introspector.decapitalize(name);
            }
        }
        if (param.password()) {
            name = ASADMIN_CMD_PREFIX + name.toUpperCase(Locale.ENGLISH);
        }
        return name;
    }

    public boolean unknownOptionsAreOperands() {
        return false;
    }

    public static abstract class ParamModel {
        public abstract String getName();

        public abstract Param getParam();

        public abstract String getLocalizedDescription();

        public abstract Class getType();

        public boolean isParamId(String key) {
            if (this.getParam().primary()) {
                return "DEFAULT".equals(key) || this.getName().equalsIgnoreCase(key);
            }
            if (this.getParam().password()) {
                return key.startsWith(CommandModel.ASADMIN_CMD_PREFIX);
            }
            return this.getName().equalsIgnoreCase(key) || this.getParam().shortName().equals(key) || this.getParam().alias().equalsIgnoreCase(key);
        }
    }
}

