/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ha.commands;

import com.sun.enterprise.config.serverbeans.Domain;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.ha.commands.Strings;
import org.glassfish.ha.store.spi.BackingStoreFactoryRegistry;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-persistence-types")
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.persistence.types.command")
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-persistence-types", description="list-persistence-types")})
public class ListPersistenceTypesCommand
implements AdminCommand {
    @Param(name="type", optional=false, primary=false)
    @I18n(value="list.persistence.types.container")
    @Pattern(regexp="(ejb|web)")
    private @Pattern(regexp="(ejb|web)") String containerType = "";
    private Logger logger;
    private static final String EOL = "\n";
    private static final String SEPARATOR = "\n";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.logger = context.getLogger();
        if (!this.checkEnvAndParams(report)) {
            return;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, Strings.get("list.persistence.types.called", this.containerType));
        }
        Set allPersistenceTypes = BackingStoreFactoryRegistry.getRegisteredTypes();
        allPersistenceTypes.remove("noop");
        if (this.containerType.equals("ejb")) {
            allPersistenceTypes.remove("memory");
        }
        StringBuilder sb = new StringBuilder("");
        boolean removeTrailingSeparator = false;
        for (String type : allPersistenceTypes) {
            sb.append(type).append("\n");
            removeTrailingSeparator = true;
        }
        String output = sb.toString();
        if (removeTrailingSeparator) {
            output = output.substring(0, output.length() - 1);
        }
        Properties extraProperties = new Properties();
        extraProperties.put("types", new ArrayList(allPersistenceTypes));
        report.setExtraProperties(extraProperties);
        report.setMessage(output);
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean checkEnvAndParams(ActionReport report) {
        if (this.containerType == null) {
            return this.fail(report, Strings.get("list.persistence.types.null.parameter"));
        }
        if (!this.containerType.equals("ejb") && !this.containerType.equals("web")) {
            return this.fail(report, Strings.get("list.persistence.types.invalid.parameter", this.containerType));
        }
        return true;
    }

    private boolean fail(ActionReport report, String s) {
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setMessage(s);
        return false;
    }
}

