/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.i18n;

import com.sun.enterprise.util.CULoggerInfo;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringManager
extends StringManagerBase {
    private static final Logger _logger = CULoggerInfo.getLogger();
    private static final String RES_BUNDLE_NM = ".LocalStrings";
    private static Hashtable managers = new Hashtable();

    private StringManager(String packageName, ClassLoader classLoader) {
        super(packageName + RES_BUNDLE_NM, classLoader);
    }

    public static synchronized StringManager getManager(String packageName, ClassLoader classLoader) {
        StringManager mgr = (StringManager)managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName, classLoader);
            try {
                managers.put(packageName, mgr);
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "NCLS-COMUTIL-0027", e);
            }
        }
        return mgr;
    }

    public static synchronized StringManager getManager(Class callerClass) {
        try {
            Package pkg = callerClass.getPackage();
            if (pkg != null) {
                String pkgName = pkg.getName();
                return StringManager.getManager(pkgName, callerClass.getClassLoader());
            }
            String pkgName = callerClass.getName();
            return StringManager.getManager(pkgName, callerClass.getClassLoader());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "NCLS-COMUTIL-0028", e);
            return StringManager.getManager("", callerClass.getClassLoader());
        }
    }
}

