/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFile;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileSystem;
import com.sun.enterprise.util.cluster.windows.process.WindowsCredentials;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import com.sun.enterprise.util.cluster.windows.process.WindowsRemoteScripter;
import com.sun.enterprise.util.cluster.windows.process.WindowsWmi;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.util.DcomUtils;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="validate-dcom")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Nodes.class, opType=RestEndpoint.OpType.GET, path="validate-dcom", description="Validate DCOM")})
public class ValidateDcom
implements AdminCommand {
    @Param(name="windowsuser", shortName="w", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(name="windowspassword", optional=true, password=true)
    private String password;
    @Param(name="host", optional=false, primary=true)
    private String host;
    @Param(name="windowsdomain", shortName="d", optional=true)
    private String windowsdomain;
    @Param(name="remotetestdir", optional=true, defaultValue="C:\\")
    private String testdir;
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;
    private boolean debug;
    private TokenResolver resolver = new TokenResolver();
    private ActionReport report;
    private WindowsRemoteFileSystem wrfs;
    private WindowsCredentials creds;
    private StringBuilder out = new StringBuilder();
    private WindowsRemoteFile wrf;
    private WindowsRemoteFile script;
    private static final String SCRIPT_NAME = "delete_me.bat";
    private String scriptFullPath;

    public final void execute(AdminCommandContext context) {
        this.debug = Boolean.parseBoolean(System.getenv("AS_DEBUG")) && this.verbose;
        try {
            if (!this.init(context)) {
                return;
            }
            if (!this.testNotLocal()) {
                return;
            }
            if (!this.testDcomPort()) {
                return;
            }
            if (!this.testDcomFileAccess()) {
                return;
            }
            if (!this.testDcomFileWrite()) {
                return;
            }
            if (!this.testWMI()) {
                return;
            }
            if (!this.testRemoteScript()) {
                return;
            }
            if (!this.testJdkAvailable()) {
                return;
            }
        }
        finally {
            if (this.report.getActionExitCode() != ActionReport.ExitCode.SUCCESS || this.verbose) {
                this.report.setMessage(this.out.toString());
            }
        }
    }

    private boolean init(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        this.user = this.resolver.resolve(this.user);
        this.password = DcomUtils.resolvePassword((String)this.resolver.resolve(this.password));
        if (!StringUtils.ok((String)this.password)) {
            this.setError(Strings.get("dcom.nopassword"));
            return false;
        }
        this.testdir = this.resolver.resolve(this.testdir).replace('/', '\\');
        if (this.testdir.endsWith("\\")) {
            this.testdir = this.testdir.substring(0, this.testdir.length() - 1);
        }
        if (!StringUtils.ok((String)this.windowsdomain)) {
            this.windowsdomain = this.host;
        }
        this.creds = new WindowsCredentials(this.host, this.windowsdomain, this.user, this.password);
        try {
            this.wrfs = new WindowsRemoteFileSystem(this.creds);
        }
        catch (WindowsException ex) {
            this.setError(ex.getMessage());
            return false;
        }
        this.scriptFullPath = this.testdir + "\\" + SCRIPT_NAME;
        return true;
    }

    private boolean testDcomPort() {
        try {
            InetAddress ia = InetAddress.getByName(this.host);
            this.out.append(Strings.get("validate.dcom.getbyname", ia)).append('\n');
        }
        catch (UnknownHostException e) {
            this.setError(e, Strings.get("unknown.host", this.host));
            return false;
        }
        boolean b135 = this.testPort(135, "DCOM Port");
        boolean b139 = this.testPort(139, "NetBIOS Session Service");
        boolean b445 = this.testPort(445, "Windows Shares");
        return b135 && b139 && b445;
    }

    private boolean testDcomFileAccess() {
        try {
            this.wrf = new WindowsRemoteFile(this.wrfs, this.testdir);
        }
        catch (WindowsException ex) {
            this.setError((Exception)((Object)ex), Strings.get("dcom.no.remote.access", this.testdir, this.host));
            return false;
        }
        try {
            if (!this.wrf.exists()) {
                this.setError(Strings.get("dcom.no.remote.file", this.testdir, this.host));
                return false;
            }
        }
        catch (WindowsException ex) {
            this.setError((Exception)((Object)ex), Strings.get("dcom.no.remote.file.access", this.testdir, this.host));
            return false;
        }
        this.out.append(Strings.get("dcom.access.ok", this.testdir, this.host)).append('\n');
        return true;
    }

    private boolean testDcomFileWrite() {
        try {
            this.script = new WindowsRemoteFile(this.wrf, SCRIPT_NAME);
            this.script.copyFrom("dir " + this.testdir + "\\\n");
            this.out.append(Strings.get("dcom.write.ok", SCRIPT_NAME, this.testdir, this.host)).append('\n');
        }
        catch (WindowsException ex) {
            this.setError((Exception)((Object)ex), Strings.get("dcom.no.write", SCRIPT_NAME, this.testdir, this.host));
            return false;
        }
        return true;
    }

    private boolean testWMI() {
        int count = -1;
        try {
            WindowsWmi ww = new WindowsWmi(this.creds);
            count = ww.getCount();
            if (this.debug) {
                String[] info = ww.getInfo();
                this.out.append(Strings.get("dcom.wmi.procinfolegend"));
                block2: for (String s : info) {
                    String[] lines;
                    for (String line : lines = s.split("[\t\n\r]")) {
                        if (!line.startsWith("CommandLine")) continue;
                        this.out.append("    ").append(line).append('\n');
                        continue block2;
                    }
                }
            }
        }
        catch (WindowsException ex) {
            this.setError((Exception)((Object)ex), Strings.get("dcom.no.wmi", this.host));
            return false;
        }
        this.out.append(Strings.get("dcom.wmi.ok", this.host, count)).append('\n');
        return true;
    }

    private boolean testRemoteScript() {
        String scriptOut = null;
        try {
            WindowsRemoteScripter scripter = new WindowsRemoteScripter(this.creds);
            scriptOut = scripter.run(this.scriptFullPath);
            this.script.delete();
        }
        catch (WindowsException ex) {
            this.setError((Exception)((Object)ex), Strings.get("dcom.no.run", this.host));
            return false;
        }
        this.out.append(Strings.get("dcom.run.ok", this.host, this.crunch(12, scriptOut))).append('\n');
        return true;
    }

    private void setError(Exception e, String msg) {
        this.setError(msg + " : " + e.getMessage());
        if (this.debug) {
            Throwable t = e;
            do {
                this.dumpStack(t);
            } while ((t = t.getCause()) != null);
        }
    }

    private void setError(String msg) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.out.append(msg).append('\n');
    }

    private String crunch(int numlines, String big) {
        if (!StringUtils.ok((String)big)) {
            return big;
        }
        StringBuilder sb = new StringBuilder();
        String[] ss = big.split("\n");
        for (int i = 0; i < numlines && i < ss.length; ++i) {
            sb.append("    ").append(ss[i]).append('\n');
        }
        return sb.toString();
    }

    private void dumpStack(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.close();
        this.out.append(sw.toString());
    }

    private boolean testPort(int port, String description) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(this.host, port), 4000);
            socket.close();
            this.out.append(Strings.get("validate.dcom.connect", description, port, this.host)).append('\n');
            return true;
        }
        catch (IOException e) {
            this.setError(e, Strings.get("validate.dcom.no.connect", description, port, this.host));
            return false;
        }
    }

    private boolean testJdkAvailable() {
        try {
            this.script = new WindowsRemoteFile(this.wrf, SCRIPT_NAME);
            this.script.copyFrom("javac -version \r\n");
            WindowsRemoteScripter scripter = new WindowsRemoteScripter(this.creds);
            scripter.wantStdErr();
            String scriptOut = scripter.run(this.scriptFullPath);
            this.script.delete();
            this.out.append(Strings.get("dcom.yes.jdk", this.host, scriptOut));
            this.out.append('\n');
            return true;
        }
        catch (WindowsException ex) {
            this.setError((Exception)((Object)ex), Strings.get("dcom.no.jdk", this.host));
            return false;
        }
    }

    private boolean testNotLocal() {
        if (NetUtils.isThisHostLocal((String)this.host)) {
            this.setError(Strings.get("dcom.yes.local", this.host));
            return false;
        }
        this.out.append(Strings.get("dcom.no.local", this.host));
        this.out.append('\n');
        return true;
    }
}

