/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.hk2.component.InjectionResolver;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.admin.SupplementalCommandExecutor;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.common.util.admin.MapInjectionResolver;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="SupplementalCommandExecutorImpl")
public class SupplementalCommandExecutorImpl
implements SupplementalCommandExecutor {
    @Inject
    private Domain domain;
    @Inject
    private ExecutorService threadExecutor;
    @Inject
    private Habitat habitat;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ServerContext sc;
    private final Logger logger = LogDomains.getLogger(SupplementalCommandExecutorImpl.class, (String)"javax.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(SupplementalCommandExecutor.class);
    private Map<String, List<Inhabitant<? extends Supplemental>>> supplementalCommandsMap = null;

    public ActionReport.ExitCode execute(String commandName, Supplemental.Timing time, AdminCommandContext context, ParameterMap parameters, MultiMap<String, File> optionFileMap) {
        ActionReport.ExitCode finalResult = ActionReport.ExitCode.SUCCESS;
        if (!this.getSupplementalCommandsList().isEmpty() && this.getSupplementalCommandsList().containsKey(commandName)) {
            List<Inhabitant<? extends Supplemental>> supplementalList = this.getSupplementalCommandsList().get(commandName);
            for (Inhabitant<? extends Supplemental> inh : supplementalList) {
                AdminCommand cmdObject = (AdminCommand)inh.get();
                Supplemental ann = cmdObject.getClass().getAnnotation(Supplemental.class);
                SupplementalCommand aCmd = new SupplementalCommand(cmdObject, ann.on(), ann.ifFailure());
                if ((!this.serverEnv.isDas() || !aCmd.whereToRun().contains(RuntimeType.DAS)) && (!this.serverEnv.isInstance() || !aCmd.whereToRun().contains(RuntimeType.INSTANCE)) || (!time.equals((Object)Supplemental.Timing.Before) || !aCmd.toBeExecutedBefore()) && (!time.equals((Object)Supplemental.Timing.After) || !aCmd.toBeExecutedAfter())) continue;
                ActionReport.ExitCode result = FailurePolicy.applyFailurePolicy((FailurePolicy)aCmd.onFailure(), (ActionReport.ExitCode)this.inject(aCmd, this.getInjector(aCmd.command, parameters, optionFileMap), context.getActionReport()));
                if (!result.equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    if (!finalResult.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
                    finalResult = result;
                    continue;
                }
                this.logger.fine(strings.getLocalString("dynamicreconfiguration.diagnostics.supplementalexec", "Executing supplemental command " + aCmd.getClass().getCanonicalName()));
                aCmd.execute(context);
                if (context.getActionReport().hasFailures()) {
                    result = FailurePolicy.applyFailurePolicy((FailurePolicy)aCmd.onFailure(), (ActionReport.ExitCode)ActionReport.ExitCode.FAILURE);
                } else if (context.getActionReport().hasWarnings()) {
                    result = FailurePolicy.applyFailurePolicy((FailurePolicy)aCmd.onFailure(), (ActionReport.ExitCode)ActionReport.ExitCode.WARNING);
                }
                if (result.equals((Object)ActionReport.ExitCode.SUCCESS) || !finalResult.equals((Object)ActionReport.ExitCode.SUCCESS)) continue;
                finalResult = result;
            }
        }
        return finalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<Inhabitant<? extends Supplemental>>> getSupplementalCommandsList() {
        if (this.supplementalCommandsMap == null) {
            SupplementalCommandExecutorImpl supplementalCommandExecutorImpl = this;
            synchronized (supplementalCommandExecutorImpl) {
                if (this.supplementalCommandsMap == null) {
                    this.supplementalCommandsMap = new ConcurrentHashMap<String, List<Inhabitant<? extends Supplemental>>>();
                    Collection supplementals = this.habitat.getInhabitants(Supplemental.class);
                    if (!supplementals.isEmpty()) {
                        for (Inhabitant inh : supplementals) {
                            String commandName = (String)inh.metadata().getOne((Object)"target");
                            if (this.supplementalCommandsMap.containsKey(commandName)) {
                                this.supplementalCommandsMap.get(commandName).add((Inhabitant<? extends Supplemental>)inh);
                                continue;
                            }
                            ArrayList<Inhabitant> inhList = new ArrayList<Inhabitant>();
                            inhList.add(inh);
                            this.supplementalCommandsMap.put(commandName, inhList);
                        }
                    }
                }
            }
        }
        return this.supplementalCommandsMap;
    }

    private InjectionResolver<Param> getInjector(AdminCommand command, ParameterMap parameters, MultiMap<String, File> map) {
        CommandModel model;
        try {
            CommandModelProvider c = (CommandModelProvider)CommandModelProvider.class.cast(command);
            model = c.getModel();
        }
        catch (ClassCastException e) {
            model = new CommandModelImpl(command.getClass());
        }
        return new MapInjectionResolver(model, parameters, map);
    }

    private ActionReport.ExitCode inject(SupplementalCommand cmd, InjectionResolver<Param> injector, ActionReport subActionReport) {
        ActionReport.ExitCode result = ActionReport.ExitCode.SUCCESS;
        try {
            new InjectionManager().inject((Object)cmd.command, new InjectionResolver[]{injector});
        }
        catch (Exception e) {
            result = ActionReport.ExitCode.FAILURE;
            subActionReport.setActionExitCode(result);
            subActionReport.setMessage(e.getMessage());
            subActionReport.setFailureCause((Throwable)e);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SupplementalCommand {
        private AdminCommand command;
        private Supplemental.Timing timing;
        private FailurePolicy failurePolicy;
        private List<RuntimeType> whereToRun = new ArrayList<RuntimeType>();

        public SupplementalCommand(AdminCommand cmd, Supplemental.Timing time, FailurePolicy onFail) {
            this.command = cmd;
            this.timing = time;
            this.failurePolicy = onFail;
            ExecuteOn ann = cmd.getClass().getAnnotation(ExecuteOn.class);
            if (ann == null) {
                this.whereToRun.add(RuntimeType.DAS);
                this.whereToRun.add(RuntimeType.INSTANCE);
            } else if (ann.value().length == 0) {
                this.whereToRun.add(RuntimeType.DAS);
                this.whereToRun.add(RuntimeType.INSTANCE);
            } else {
                for (RuntimeType t : ann.value()) {
                    this.whereToRun.add(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(AdminCommandContext ctxt) {
            ClassLoader ccl;
            Thread thread = Thread.currentThread();
            ClassLoader origCL = thread.getContextClassLoader();
            if (origCL != (ccl = SupplementalCommandExecutorImpl.this.sc.getCommonClassLoader())) {
                try {
                    thread.setContextClassLoader(ccl);
                    this.command.execute(ctxt);
                }
                finally {
                    thread.setContextClassLoader(origCL);
                }
            } else {
                this.command.execute(ctxt);
            }
        }

        public boolean toBeExecutedBefore() {
            return this.timing.equals((Object)Supplemental.Timing.Before);
        }

        public boolean toBeExecutedAfter() {
            return this.timing.equals((Object)Supplemental.Timing.After);
        }

        public FailurePolicy onFailure() {
            return this.failurePolicy;
        }

        public List<RuntimeType> whereToRun() {
            return this.whereToRun;
        }
    }
}

