/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.jws.boot;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.security.Policy;
import java.security.Security;
import org.glassfish.appclient.client.acc.Util;

public class LaunchSecurityHelper {
    private static final String PERMISSIONS_TEMPLATE_NAME = "jwsclient.policy";
    private static final String SYSTEM_CODEBASE_PROPERTY = "appclient.system.codebase";
    private static final int BUFFER_SIZE = 1024;

    public static void setPermissions() {
        try {
            String permissionsTemplate = LaunchSecurityHelper.loadResource(LaunchSecurityHelper.class, PERMISSIONS_TEMPLATE_NAME);
            boolean retainTempFiles = Boolean.getBoolean("com.sun.aas.jws.retainTempFiles");
            File policyFile = Util.writeTextToTempFile(permissionsTemplate, "jwsacc", ".policy", retainTempFiles);
            LaunchSecurityHelper.refreshPolicy(policyFile);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error loading permissions template", ioe);
        }
    }

    private static String loadResource(Class contextClass, String resourcePath) throws IOException {
        String result = null;
        InputStream is = null;
        BufferedReader reader = null;
        try {
            int charsRead;
            is = contextClass.getResourceAsStream(resourcePath);
            if (is == null) {
                throw new IOException("Could not locate the requested resource relative to class " + contextClass.getName());
            }
            StringBuilder sb = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader(is));
            char[] buffer = new char[1024];
            while ((charsRead = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, charsRead);
            }
            String string = result = sb.toString();
            return string;
        }
        catch (IOException ioe) {
            throw new IOException("Error loading resource " + resourcePath, ioe);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static int firstFreePolicyIndex() {
        String propValue;
        int i = 0;
        while ((propValue = Security.getProperty("policy.url." + String.valueOf(++i))) != null && !propValue.equals("")) {
        }
        return i;
    }

    private static void refreshPolicy(File policyFile) {
        int idx = LaunchSecurityHelper.firstFreePolicyIndex();
        URI policyFileURI = policyFile.toURI();
        Security.setProperty("policy.url." + idx, policyFileURI.toASCIIString());
        Policy p = Policy.getPolicy();
        p.refresh();
    }
}

