/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.deploy.shared.MemoryMappedArchive;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.appclient.client.acc.Launchable;
import org.glassfish.appclient.client.acc.Util;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

public class MainClassLaunchable
implements Launchable {
    private final Class mainClass;
    private ApplicationClientDescriptor acDesc = null;
    private ClassLoader classLoader = null;
    private AppClientArchivist archivist = null;
    private final Habitat habitat;

    MainClassLaunchable(Habitat habitat, Class mainClass) {
        this.mainClass = mainClass;
        this.habitat = habitat;
    }

    public Class getMainClass() throws ClassNotFoundException {
        return this.mainClass;
    }

    public ApplicationClientDescriptor getDescriptor(final URLClassLoader loader) throws IOException, SAXParseException {
        if (this.acDesc == null) {
            ReadableArchive tempArchive = null;
            ACCClassLoader tempLoader = AccessController.doPrivileged(new PrivilegedAction<ACCClassLoader>(){

                @Override
                public ACCClassLoader run() {
                    return new ACCClassLoader(loader.getURLs(), loader.getParent());
                }
            });
            tempArchive = this.createArchive(tempLoader, this.mainClass);
            AppClientArchivist acArchivist = this.getArchivist(tempArchive, tempLoader);
            this.archivist.setClassLoader((ClassLoader)tempLoader);
            this.archivist.setDescriptor((RootDeploymentDescriptor)this.acDesc);
            this.archivist.setAnnotationProcessingRequested(true);
            this.acDesc = (ApplicationClientDescriptor)acArchivist.open(tempArchive);
            Application.createVirtualApplication(null, (ModuleDescriptor)this.acDesc.getModuleDescriptor());
            this.acDesc.getApplication().setAppName(this.appNameFromMainClass(this.mainClass));
            this.classLoader = loader;
        }
        return this.acDesc;
    }

    private String appNameFromMainClass(Class c) {
        return c.getName();
    }

    private ReadableArchive createArchive(ClassLoader loader, Class mainClass) throws IOException {
        int bytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Manifest mf = new Manifest();
        Attributes mainAttrs = mf.getMainAttributes();
        mainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttrs.put(Attributes.Name.MAIN_CLASS, mainClass.getName());
        JarOutputStream jos = new JarOutputStream((OutputStream)baos, mf);
        String mainClassResourceName = mainClass.getName().replace('.', '/') + ".class";
        ZipEntry mainClassEntry = new ZipEntry(mainClassResourceName);
        jos.putNextEntry(mainClassEntry);
        InputStream is = loader.getResourceAsStream(mainClassResourceName);
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            jos.write(buffer, 0, bytesRead);
        }
        is.close();
        jos.closeEntry();
        jos.close();
        MemoryMappedArchive mma = new MemoryMappedArchive(baos.toByteArray());
        mma.setURI(URI.create("file:///tempClient.jar"));
        return mma;
    }

    private AppClientArchivist getArchivist(ReadableArchive clientRA, ClassLoader classLoader) throws IOException {
        if (this.archivist == null) {
            ArchivistFactory af = Util.getArchivistFactory();
            this.archivist = this.completeInit((AppClientArchivist)af.getArchivist(DeploymentUtils.carType()));
        }
        return this.archivist;
    }

    private AppClientArchivist completeInit(AppClientArchivist arch) {
        arch.setAnnotationProcessingRequested(true);
        return arch;
    }

    public void validateDescriptor() {
        this.archivist.validate(this.classLoader);
    }

    public URI getURI() {
        return null;
    }

    public String getAnchorDir() {
        return null;
    }
}

