/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.servermgmt.pe.ProfileTransformationException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

final class ProfileTransformer {
    private final File baseXml;
    private final List<File> styleSheets;
    private final File destDir;
    private final EntityResolver er;
    private final Properties op;
    private static final StringManager sm = StringManager.getManager(ProfileTransformer.class);

    ProfileTransformer(File baseXml, List<File> styleSheets, File destDir, EntityResolver er, Properties op) {
        if (baseXml == null || styleSheets == null || destDir == null) {
            throw new IllegalArgumentException("null arguments");
        }
        this.baseXml = baseXml;
        this.styleSheets = Collections.unmodifiableList(styleSheets);
        this.destDir = destDir;
        this.er = er;
        this.op = new Properties(op);
    }

    File transform() throws ProfileTransformationException {
        if (this.styleSheets.isEmpty()) {
            return this.baseXml;
        }
        FilterOutputStream bos = null;
        try {
            String fn = this.baseXml.getName();
            DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = bf.newDocumentBuilder();
            builder.setEntityResolver(this.er);
            TransformerFactory tf = TransformerFactory.newInstance();
            Document doc = null;
            int cnt = 0;
            File rfn = null;
            for (File ss : this.styleSheets) {
                if (cnt == 0) {
                    doc = builder.parse(this.baseXml);
                }
                DOMSource src = new DOMSource(doc);
                rfn = new File(this.destDir, fn + "transformed" + cnt);
                bos = new BufferedOutputStream(new FileOutputStream(rfn));
                StreamResult result = new StreamResult(bos);
                StreamSource sss = new StreamSource(ss);
                Transformer xf = tf.newTransformer(sss);
                xf.setURIResolver(new TemplateUriResolver());
                xf.setOutputProperties(this.op);
                xf.transform(src, result);
                doc = builder.parse(rfn);
                ++cnt;
                String msg = sm.getString("xformPhaseComplete", (Object)ss.getAbsolutePath(), (Object)rfn.getAbsolutePath());
                System.out.println(msg);
            }
            File file = rfn;
            return file;
        }
        catch (Exception e) {
            throw new ProfileTransformationException(e);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static class TemplateUriResolver
    implements URIResolver {
        private TemplateUriResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            try {
                File f;
                StreamSource source = null;
                URI baseUri = new URI(base);
                URI tbResolved = baseUri.resolve(href);
                boolean isFileUri = tbResolved.toString().toLowerCase(Locale.ENGLISH).startsWith("file:");
                if (isFileUri && (f = new File(tbResolved)).exists()) {
                    source = new StreamSource(f);
                }
                return source;
            }
            catch (Exception e) {
                throw new TransformerException(e);
            }
        }
    }
}

