/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.testing;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.glassfish.admin.rest.testing.BooleanValue;
import org.glassfish.admin.rest.testing.Common;
import org.glassfish.admin.rest.testing.DoubleValue;
import org.glassfish.admin.rest.testing.IndentingStringBuffer;
import org.glassfish.admin.rest.testing.IntValue;
import org.glassfish.admin.rest.testing.LongValue;
import org.glassfish.admin.rest.testing.NilValue;
import org.glassfish.admin.rest.testing.ObjectValue;
import org.glassfish.admin.rest.testing.StringValue;
import org.glassfish.admin.rest.testing.Value;

public class ArrayValue
extends Value {
    private boolean ignoreExtra;
    private boolean ordered;
    private List<Value> values = new ArrayList<Value>();

    ArrayValue() {
    }

    public boolean isIgnoreExtra() {
        return this.ignoreExtra;
    }

    public ArrayValue ignoreExtra(boolean val) {
        this.ignoreExtra = val;
        return this;
    }

    public ArrayValue ignoreExtra() {
        return this.ignoreExtra(true);
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public ArrayValue ordered(boolean val) {
        this.ordered = val;
        return this;
    }

    public ArrayValue ordered() {
        return this.ordered(true);
    }

    List<Value> getValues() {
        return this.values;
    }

    public ArrayValue add(Value value) {
        if (value == null) {
            value = Common.nilVal();
        }
        this.getValues().add(value);
        return this;
    }

    public ArrayValue add(String propertyValue) {
        StringValue val = propertyValue != null ? Common.stringVal(propertyValue) : null;
        return this.add(val);
    }

    public ArrayValue add(long propertyValue) {
        return this.add(Common.longVal(propertyValue));
    }

    public ArrayValue add(int propertyValue) {
        return this.add(Common.intVal(propertyValue));
    }

    public ArrayValue add(double propertyValue) {
        return this.add(Common.doubleVal(propertyValue));
    }

    public ArrayValue add(boolean propertyValue) {
        return this.add(Common.booleanVal(propertyValue));
    }

    public ArrayValue add() {
        return this.add(Common.nilVal());
    }

    public ArrayValue remove(int index) {
        if (0 <= index && index < this.getValues().size()) {
            this.getValues().remove(index);
        }
        return this;
    }

    public int size() {
        return this.getValues().size();
    }

    public Value get(int index) {
        return index < this.getValues().size() ? this.getValues().get(index) : null;
    }

    public ObjectValue getObjectVal(int index) {
        return (ObjectValue)this.get(index);
    }

    public StringValue getStringVal(int index) {
        return (StringValue)this.get(index);
    }

    public LongValue getLongVal(int index) {
        return (LongValue)this.get(index);
    }

    public IntValue getIntVal(int index) {
        return (IntValue)this.get(index);
    }

    public DoubleValue getDoubleVal(int index) {
        return (DoubleValue)this.get(index);
    }

    public BooleanValue getBooleanVal(int index) {
        return (BooleanValue)this.get(index);
    }

    public NilValue getNilVal(int index) {
        return (NilValue)this.get(index);
    }

    @Override
    Object getJsonValue() throws Exception {
        if (this.isIgnoreExtra()) {
            throw new IllegalStateException("Cannot be converted to json because ignoreExtra is true");
        }
        JSONArray a = new JSONArray();
        for (Value v : this.getValues()) {
            a.put(v.getJsonValue());
        }
        return a;
    }

    public JSONArray toJSONArray() throws Exception {
        return (JSONArray)this.getJsonValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void print(IndentingStringBuffer sb) {
        sb.println("arrayValue ignoreExtra=" + this.isIgnoreExtra() + " ordered=" + this.isOrdered());
        sb.indent();
        try {
            for (Value value : this.getValues()) {
                value.print(sb);
            }
        }
        finally {
            sb.undent();
        }
    }
}

