/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.ws.rs.core.Application;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.adapter.AdminJerseyServiceIteratorProvider;
import org.glassfish.admin.rest.adapter.JerseyContainer;
import org.glassfish.admin.rest.adapter.RestAdapter;
import org.glassfish.admin.rest.adapter.RestCommandResourceProvider;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.internal.api.InternalSystemAdministrator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=10)
public class JerseyContainerCommandService
implements PostConstruct {
    @Inject
    protected ServiceLocator habitat;
    @Inject
    private InternalSystemAdministrator kernelIdentity;
    private Future<JerseyContainer> future = null;

    public void postConstruct() {
        if (Boolean.valueOf(System.getenv("AS_INIT_REST_EAGER")).booleanValue()) {
            ExecutorService executor = Executors.newFixedThreadPool(2);
            this.future = executor.submit(new Callable<JerseyContainer>(){

                @Override
                public JerseyContainer call() throws Exception {
                    JerseyContainer result = JerseyContainerCommandService.this.exposeContext();
                    return result;
                }
            });
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    CommandRunner cr = (CommandRunner)JerseyContainerCommandService.this.habitat.getService(CommandRunner.class, new Annotation[0]);
                    CommandRunner.CommandInvocation invocation = cr.getCommandInvocation("uptime", (ActionReport)new PropsFileActionReporter(), JerseyContainerCommandService.this.kernelIdentity.getSubject());
                    invocation.parameters(new ParameterMap());
                    invocation.execute();
                }
            });
            executor.shutdown();
        }
    }

    public JerseyContainer getJerseyContainer() throws EndpointRegistrationException {
        try {
            if (this.future == null) {
                return this.exposeContext();
            }
            return this.future.get();
        }
        catch (InterruptedException ex) {
            return this.exposeContext();
        }
        catch (ExecutionException ex) {
            Throwable orig = ex.getCause();
            if (orig instanceof EndpointRegistrationException) {
                throw (EndpointRegistrationException)orig;
            }
            RestLogging.restLogger.log(Level.INFO, "NCLS-REST-00015", orig);
            return null;
        }
    }

    private ServerContext getServerContext() {
        return (ServerContext)this.habitat.getService(ServerContext.class, new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JerseyContainer exposeContext() throws EndpointRegistrationException {
        Set<Class<?>> classes = RestCommandResourceProvider.getResourceClasses();
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader apiClassLoader = this.getServerContext().getCommonClassLoader();
            Thread.currentThread().setContextClassLoader(apiClassLoader);
            ResourceConfig rc = new RestCommandResourceProvider().getResourceConfig(classes, this.getServerContext(), this.habitat, this.getAdditionalBinders());
            JerseyContainer jerseyContainer = this.getJerseyContainer(rc);
            return jerseyContainer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JerseyContainer getJerseyContainer(ResourceConfig rc) {
        AdminJerseyServiceIteratorProvider iteratorProvider = new AdminJerseyServiceIteratorProvider();
        try {
            ServiceFinder.setIteratorProvider((ServiceFinder.ServiceIteratorProvider)iteratorProvider);
            final HttpHandler httpHandler = (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (Application)rc);
            JerseyContainer jerseyContainer = new JerseyContainer(){

                @Override
                public void service(Request request, Response response) throws Exception {
                    httpHandler.service(request, response);
                }
            };
            return jerseyContainer;
        }
        finally {
            iteratorProvider.disable();
        }
    }

    private Set<? extends Binder> getAdditionalBinders() {
        return Collections.singleton(new AbstractBinder(){

            protected void configure() {
                this.bindFactory(RestAdapter.SubjectReferenceFactory.class).to((TypeLiteral)new TypeLiteral<Ref<Subject>>(){}).in(PerLookup.class);
                this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<Subject>>(){}).in(RequestScoped.class);
            }
        });
    }
}

