/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.GenericCrudCommand;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.config.TransactionFailure;

public abstract class CopyConfig
implements AdminCommand {
    @Param(primary=true, multiple=true)
    protected List<String> configs;
    @Inject
    protected Domain domain;
    @Param(optional=true, separator=58)
    protected String systemproperties;
    protected Config copyOfConfig;
    @Inject
    ServerEnvironment env;
    @Inject
    ServerEnvironmentImpl envImpl;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CopyConfig.class);

    public Config copyConfig(Configs configs, Config config, String destConfigName, Logger logger) throws PropertyVetoException, TransactionFailure {
        Config destCopy = (Config)config.deepCopy(configs);
        if (this.systemproperties != null) {
            Properties properties = GenericCrudCommand.convertStringToProperties(this.systemproperties, ':');
            for (Object key : properties.keySet()) {
                String propName = (String)key;
                List<SystemProperty> sysprops = destCopy.getSystemProperty();
                for (SystemProperty sysprop : sysprops) {
                    if (!propName.equals(sysprop.getName())) continue;
                    sysprops.remove(sysprop);
                    break;
                }
                SystemProperty newSysProp = (SystemProperty)destCopy.createChild(SystemProperty.class);
                newSysProp.setName(propName);
                newSysProp.setValue(properties.getProperty(propName));
                destCopy.getSystemProperty().add(newSysProp);
            }
        }
        String configName = destConfigName;
        destCopy.setName(configName);
        configs.getConfig().add(destCopy);
        this.copyOfConfig = destCopy;
        String srcConfig = "";
        srcConfig = config.getName();
        try {
            File configConfigDir = new File(this.env.getConfigDirPath(), configName);
            if (!new File(configConfigDir, "docroot").mkdirs() || !new File(configConfigDir, "lib/ext").mkdirs()) {
                throw new IOException(localStrings.getLocalString("config.mkdirs", "error creating config specific directories"));
            }
            String srcConfigLoggingFile = this.env.getInstanceRoot().getAbsolutePath() + File.separator + "config" + File.separator + srcConfig + File.separator + "logging.properties";
            File src = new File(srcConfigLoggingFile);
            if (!src.exists()) {
                src = new File(this.env.getConfigDirPath(), "logging.properties");
            }
            File dest = new File(configConfigDir, "logging.properties");
            FileUtils.copy((File)src, (File)dest);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "NCLS-ADMIN-00006", e.getLocalizedMessage());
        }
        return destCopy;
    }
}

