/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.parser;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.ByteArrayInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

public class ConfigurationPopulator {
    private static final Logger LOG = Logger.getLogger(ConfigurationPopulator.class.getName());
    private final DomDocument doc;
    private final ConfigBeanProxy parent;
    private final String xmlContent;

    public ConfigurationPopulator(String xmlContent, DomDocument doc, ConfigBeanProxy parent) {
        this.xmlContent = xmlContent;
        this.doc = doc;
        this.parent = parent;
    }

    public void run(ConfigParser parser) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.xmlContent.getBytes());
            XMLStreamReader reader = XMLInputFactory.newFactory().createXMLStreamReader(is, "utf-8");
            parser.parse(reader, this.doc, Dom.unwrap((ConfigBeanProxy)this.parent));
        }
        catch (XMLStreamException e) {
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConfigurationPopulator.class);
            String msg = localStrings.getLocalString("can.not.get.default.configuration.for", "Can not read default configuration");
            LOG.log(Level.SEVERE, msg, e);
        }
    }
}

