/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.ConfigurationPersistence;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

public class GlassFishDocument
extends DomDocument<GlassFishConfigBean> {
    Logger logger = LogDomains.getLogger(GlassFishDocument.class, (String)"javax.enterprise.system.core");

    public GlassFishDocument(final ServiceLocator habitat, ExecutorService executor) {
        super(habitat);
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)habitat, (Object)executor, (String)"transactions-executor", (Type[])new Type[]{ExecutorService.class});
        ServiceLocatorUtilities.addOneConstant((ServiceLocator)habitat, (Object)((Object)this), null, (Type[])new Type[]{DomDocument.class});
        final GlassFishDocument doc = this;
        ((Transactions)habitat.getService(Transactions.class, new Annotation[0])).addTransactionsListener(new TransactionListener(){

            public void transactionCommited(List<PropertyChangeEvent> changes) {
                for (ConfigurationPersistence pers : habitat.getAllServices(ConfigurationPersistence.class, new Annotation[0])) {
                    try {
                        if (doc.getRoot().getProxyType().equals(Domain.class)) {
                            Dom domainRoot = doc.getRoot();
                            domainRoot.attribute("version", Version.getBuildVersion());
                        }
                        pers.save(doc);
                    }
                    catch (IOException e) {
                        GlassFishDocument.this.logger.log(Level.SEVERE, "GlassFishDocument.IOException", new String[]{e.getMessage()});
                        GlassFishDocument.this.logger.log(Level.FINE, e.getMessage(), e);
                    }
                    catch (XMLStreamException e) {
                        GlassFishDocument.this.logger.log(Level.SEVERE, "GlassFishDocument.XMLException", new String[]{e.getMessage()});
                        GlassFishDocument.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }

            public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
            }
        });
    }

    public GlassFishConfigBean make(ServiceLocator habitat, XMLStreamReader xmlStreamReader, GlassFishConfigBean dom, ConfigModel configModel) {
        return new GlassFishConfigBean(habitat, this, dom, configModel, xmlStreamReader);
    }
}

