/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.Ref;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.customvalidators.RefConstraint;
import com.sun.enterprise.config.serverbeans.customvalidators.RefValidator;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Payload;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.DeletionDecorator;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
@RefConstraint(message="{ref.invalid}", payload={RefValidator.class})
public interface LbConfig
extends ConfigBeanProxy,
Injectable,
PropertyBag,
Payload {
    public static final String LAST_APPLIED_PROPERTY = "last-applied";
    public static final String LAST_EXPORTED_PROPERTY = "last-exported";

    @Attribute(key=true)
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\./;#]*", message="{lbconfig.invalid.name}", payload={LbConfig.class})
    @NotNull
    public String getName();

    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="60")
    @Min(value=0L)
    public String getResponseTimeoutInSeconds();

    @Param(name="responsetimeout", optional=true)
    public void setResponseTimeoutInSeconds(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getHttpsRouting();

    @Param(name="httpsrouting", optional=true)
    public void setHttpsRouting(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="60")
    public String getReloadPollIntervalInSeconds();

    @Param(name="reloadinterval", optional=true)
    public void setReloadPollIntervalInSeconds(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getMonitoringEnabled();

    @Param(name="monitor", optional=true)
    public void setMonitoringEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getRouteCookieEnabled();

    @Param(name="routecookie", optional=true)
    public void setRouteCookieEnabled(String var1) throws PropertyVetoException;

    @Element(value="*")
    public List<Ref> getClusterRefOrServerRef();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    @DuckTyped
    public <T> List<T> getRefs(Class<T> var1);

    @DuckTyped
    public <T> T getRefByRef(Class<T> var1, String var2);

    @DuckTyped
    public Date getLastExported();

    @DuckTyped
    public Date getLastApplied();

    @DuckTyped
    public boolean setLastExported();

    @DuckTyped
    public boolean setLastApplied();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class DeleteDecorator
    implements DeletionDecorator<LbConfigs, LbConfig> {
        @Inject
        private Domain domain;

        @Override
        public void decorate(AdminCommandContext context, LbConfigs parent, LbConfig child) throws PropertyVetoException, TransactionFailure {
            Logger logger = LogDomains.getLogger(LbConfig.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LbConfig.class);
            String lbConfigName = child.getName();
            LbConfig lbConfig = this.domain.getLbConfigs().getLbConfig(lbConfigName);
            if (lbConfig.getClusterRefOrServerRef().size() != 0) {
                String msg = localStrings.getLocalString("LbConfigNotEmpty", lbConfigName);
                throw new TransactionFailure(msg);
            }
            logger.info(localStrings.getLocalString("http_lb_admin.LbConfigDeleted", lbConfigName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    @Scoped(value=PerLookup.class)
    public static class Decorator
    implements CreationDecorator<LbConfig> {
        @Param(name="name", optional=true)
        String config_name;
        @Param(optional=true)
        String target;
        @Param(optional=true, defaultValue="60")
        String responsetimeout;
        @Param(optional=true, defaultValue="false")
        Boolean httpsrouting;
        @Param(optional=true, defaultValue="60")
        String reloadinterval;
        @Param(optional=true, defaultValue="false")
        Boolean monitor;
        @Param(optional=true, defaultValue="true")
        Boolean routecookie;
        @Param(optional=true, name="property", separator=58)
        Properties properties;
        @Inject
        Domain domain;
        @Inject
        LbConfigs lbconfigs;

        @Override
        public void decorate(AdminCommandContext context, LbConfig instance) throws TransactionFailure, PropertyVetoException {
            Logger logger = LogDomains.getLogger(LbConfig.class, (String)"javax.enterprise.system.tools.admin");
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LbConfig.class);
            if (this.config_name == null && this.target == null) {
                String msg = localStrings.getLocalString("RequiredTargetOrConfig", "Neither LB config name nor target specified");
                throw new TransactionFailure(msg);
            }
            if (this.config_name == null) {
                this.config_name = this.target + "_LB_CONFIG";
            }
            if (this.lbconfigs.getLbConfig(this.config_name) != null) {
                String msg = localStrings.getLocalString("LbConfigExists", this.config_name);
                throw new TransactionFailure(msg);
            }
            instance.setName(this.config_name);
            instance.setResponseTimeoutInSeconds(this.responsetimeout);
            instance.setReloadPollIntervalInSeconds(this.reloadinterval);
            instance.setMonitoringEnabled(this.monitor == null ? null : this.monitor.toString());
            instance.setRouteCookieEnabled(this.routecookie == null ? null : this.routecookie.toString());
            instance.setHttpsRouting(this.httpsrouting == null ? null : this.httpsrouting.toString());
            if (this.target != null) {
                if (this.domain.getClusterNamed(this.target) != null) {
                    ClusterRef cRef = (ClusterRef)instance.createChild(ClusterRef.class);
                    cRef.setRef(this.target);
                    instance.getClusterRefOrServerRef().add(cRef);
                } else if (this.domain.isServer(this.target)) {
                    ServerRef sRef = (ServerRef)instance.createChild(ServerRef.class);
                    sRef.setRef(this.target);
                    instance.getClusterRefOrServerRef().add(sRef);
                } else {
                    String msg = localStrings.getLocalString("InvalidTarget", this.target);
                    throw new TransactionFailure(msg);
                }
            }
            if (this.properties != null) {
                for (Object propname : this.properties.keySet()) {
                    Property newprop = (Property)instance.createChild(Property.class);
                    newprop.setName((String)propname);
                    newprop.setValue(this.properties.getProperty((String)propname));
                    instance.getProperty().add(newprop);
                }
            }
            logger.info(localStrings.getLocalString("http_lb_admin.LbConfigCreated", "Load balancer configuration {0} created.", new Object[]{this.config_name}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Duck {
        public static <T> List<T> getRefs(LbConfig lc, Class<T> type) {
            ArrayList<T> refs = new ArrayList<T>();
            for (Ref r : lc.getClusterRefOrServerRef()) {
                if (!type.isInstance(r)) continue;
                refs.add(type.cast(r));
            }
            return Collections.unmodifiableList(refs);
        }

        public static <T> T getRefByRef(LbConfig lc, Class<T> type, String ref) {
            if (ref == null) {
                return null;
            }
            for (Ref r : lc.getClusterRefOrServerRef()) {
                if (!type.isInstance(r) || !r.getRef().equals(ref)) continue;
                return type.cast(r);
            }
            return null;
        }

        public static Date getLastExported(LbConfig lc) {
            return Duck.getInternalPropertyValue(lc, LbConfig.LAST_EXPORTED_PROPERTY);
        }

        public static Date getLastApplied(LbConfig lc) {
            return Duck.getInternalPropertyValue(lc, LbConfig.LAST_APPLIED_PROPERTY);
        }

        private static Date getInternalPropertyValue(LbConfig lc, String propertyName) {
            String propertyValue = lc.getPropertyValue(propertyName);
            if (propertyValue == null) {
                return null;
            }
            return new Date(Long.valueOf(propertyValue));
        }

        public static boolean setLastExported(LbConfig lc) {
            return Duck.setInternalProperty(lc, LbConfig.LAST_EXPORTED_PROPERTY);
        }

        public static boolean setLastApplied(LbConfig lc) {
            return Duck.setInternalProperty(lc, LbConfig.LAST_APPLIED_PROPERTY);
        }

        private static boolean setInternalProperty(LbConfig lc, String propertyName) {
            Property property = lc.getProperty(propertyName);
            Transaction transaction = new Transaction();
            try {
                if (property == null) {
                    ConfigBeanProxy lcProxy = transaction.enroll((ConfigBeanProxy)lc);
                    property = (Property)lcProxy.createChild(Property.class);
                    property.setName(propertyName);
                    property.setValue(String.valueOf(new Date().getTime()));
                    ((LbConfig)lcProxy).getProperty().add(property);
                } else {
                    ConfigBeanProxy propertyProxy = transaction.enroll((ConfigBeanProxy)property);
                    ((Property)propertyProxy).setValue(String.valueOf(new Date().getTime()));
                }
                transaction.commit();
            }
            catch (Exception ex) {
                transaction.rollback();
                Logger logger = LogDomains.getLogger(LbConfig.class, (String)"javax.enterprise.system.tools.admin");
                LocalStringManagerImpl localStrings = new LocalStringManagerImpl(LbConfig.class);
                String msg = localStrings.getLocalString("UnableToSetPropertyInLbconfig", "Unable to set property {0} in lbconfig with name {1}", (Object[])new String[]{propertyName, lc.getName()});
                logger.log(Level.SEVERE, msg);
                logger.log(Level.FINE, "Exception when trying to set property " + propertyName + " in lbconfig " + lc.getName(), ex);
                return false;
            }
            return true;
        }
    }
}

