/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.util.io.DomainDirs;
import com.sun.enterprise.util.io.InstanceDirs;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.admin.CommandException;

public class ServerDirsSelector {
    private File userSpecifiedDomainDirParent;
    private String userSpecifiedServerName;
    private String userSpecifiedNodeDir;
    private String userSpecifiedNode;
    private DomainDirs domainDirs = null;
    private InstanceDirs instanceDirs = null;

    public static ServerDirsSelector getInstance(File domainDirParent, String serverName, String nodeDir, String node) throws CommandException, IOException {
        ServerDirsSelector helper = new ServerDirsSelector(domainDirParent, serverName, nodeDir, node);
        helper.validateDomainOrInstance();
        return helper;
    }

    public ServerDirs dirs() {
        return this.selectDirs();
    }

    private ServerDirsSelector(File domainDirParent, String serverName, String nodeDir, String node) {
        this.userSpecifiedDomainDirParent = domainDirParent;
        this.userSpecifiedServerName = serverName;
        this.userSpecifiedNodeDir = nodeDir;
        this.userSpecifiedNode = node;
    }

    private void validateDomainOrInstance() throws CommandException, IOException {
        if (this.userSpecifiedDomainDirParent != null) {
            this.domainDirs = new DomainDirs(this.userSpecifiedDomainDirParent, this.userSpecifiedServerName);
        } else if (this.userSpecifiedNode != null || this.userSpecifiedNodeDir != null) {
            this.instanceDirs = new InstanceDirs(this.userSpecifiedNodeDir, this.userSpecifiedNode, this.userSpecifiedServerName);
        } else if (this.userSpecifiedServerName == null) {
            this.domainDirs = new DomainDirs(this.userSpecifiedDomainDirParent, this.userSpecifiedServerName);
        } else {
            try {
                this.domainDirs = new DomainDirs(this.userSpecifiedDomainDirParent, this.userSpecifiedServerName);
                return;
            }
            catch (IOException iOException) {
                this.instanceDirs = new InstanceDirs(this.userSpecifiedNodeDir, this.userSpecifiedNode, this.userSpecifiedServerName);
            }
        }
    }

    public boolean isInstance() {
        return this.instanceDirs != null;
    }

    private ServerDirs selectDirs() {
        if (this.isInstance()) {
            return this.instanceDirs.getServerDirs();
        }
        return this.domainDirs.getServerDirs();
    }
}

