/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.ClassLineageIterator;
import com.sun.enterprise.admin.util.NamedResourceManager;
import com.sun.enterprise.admin.util.Strings;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.security.auth.Subject;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.AuthorizationPreprocessor;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.EmbeddedSystemAdministrator;
import org.glassfish.security.services.api.authorization.AuthorizationService;
import org.glassfish.security.services.api.authorization.AzAction;
import org.glassfish.security.services.api.authorization.AzResource;
import org.glassfish.security.services.api.authorization.AzResult;
import org.glassfish.security.services.api.authorization.AzSubject;
import org.glassfish.security.services.api.common.Attributes;
import org.glassfish.security.services.api.context.SecurityContextService;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

@Service
@Singleton
public class CommandSecurityChecker
implements PostConstruct {
    private static final String ADMSEC_AUTHZ_LOGGER_NAME = "javax.enterprise.system.tools.admin.security.authorization";
    private static final String LOG_MESSAGES_RB = "com.sun.enterprise.admin.util.LogMessages";
    static final Logger ADMSEC_AUTHZ_LOGGER = Logger.getLogger("javax.enterprise.system.tools.admin.security.authorization", "com.sun.enterprise.admin.util.LogMessages");
    private static final String RESOURCE_NAME_URL_ENCODING = "UTF-8";
    private static final Level PROGRESS_LEVEL = Level.FINE;
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ADMIN_RESOURCE_SCHEME = "admin";
    @Inject
    private ServiceLocator locator;
    @Inject
    private AuthorizationService authService;
    @Inject
    private NamedResourceManager namedResourceMgr;
    @Inject
    private IterableProvider<AuthorizationPreprocessor> authPreprocessors;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private SecurityContextService securityContextService;
    @Inject
    private EmbeddedSystemAdministrator embeddedSystemAdministrator;
    private static final Map<RestEndpoint.OpType, String> optypeToAction = CommandSecurityChecker.initOptypeMap();
    private static final Pattern TOKEN_PATTERN = Pattern.compile("(?:\\$(\\w+))|(?:\\$\\{(\\w+)\\})");

    public void postConstruct() {
        this.securityContextService.getEnvironmentAttributes().addAttribute("isDAS", Boolean.toString(this.serverEnv.isDas()), true);
    }

    private static EnumMap<RestEndpoint.OpType, String> initOptypeMap() {
        EnumMap<RestEndpoint.OpType, String> result = new EnumMap<RestEndpoint.OpType, String>(RestEndpoint.OpType.class);
        result.put(RestEndpoint.OpType.DELETE, "delete");
        result.put(RestEndpoint.OpType.GET, "read");
        result.put(RestEndpoint.OpType.POST, "update");
        result.put(RestEndpoint.OpType.PUT, "create");
        return result;
    }

    public boolean authorize(Subject subject, Map<String, Object> env, final AdminCommand command, final AdminCommandContext adminCommandContext) throws SecurityException {
        boolean result;
        if (subject == null) {
            ADMSEC_AUTHZ_LOGGER.log(Level.WARNING, command.getClass().getName(), new IllegalArgumentException("subject"));
            subject = new Subject();
        }
        try {
            if (command instanceof AdminCommandSecurity.Preauthorization && !(result = Subject.doAs(subject, new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return ((AdminCommandSecurity.Preauthorization)command).preAuthorization(adminCommandContext);
                }
            }).booleanValue())) {
                return false;
            }
            List<AccessCheckWork> accessChecks = this.assembleAccessCheckWork(command, subject);
            result = this.embeddedSystemAdministrator.matches(subject) || this.checkAccessRequired(subject, env, command, accessChecks);
        }
        catch (Exception ex) {
            ADMSEC_AUTHZ_LOGGER.log(Level.SEVERE, "NCLS-ADMIN-00011", ex);
            throw new RuntimeException(ex);
        }
        if (!result) {
            throw new SecurityException();
        }
        return result;
    }

    private List<AccessCheckWork> assembleAccessCheckWork(AdminCommand command, Subject subject) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        boolean isTaggable = ADMSEC_AUTHZ_LOGGER.isLoggable(PROGRESS_LEVEL);
        ArrayList<AccessCheckWork> accessChecks = new ArrayList<AccessCheckWork>();
        this.addChecksFromAccessCheckProvider(command, accessChecks, isTaggable, subject);
        this.addChecksFromExplicitAccessRequiredAnnos(command, accessChecks, isTaggable);
        this.addChecksFromReSTEndpoints(command, accessChecks, isTaggable);
        if (accessChecks.isEmpty()) {
            accessChecks.add(new UnguardedCommandAccessCheckWork(command));
        }
        return accessChecks;
    }

    private boolean checkAccessRequired(Subject subject, Map<String, Object> env, AdminCommand command, List<AccessCheckWork> accessChecks) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException, URISyntaxException, UnsupportedEncodingException {
        boolean isTaggable = ADMSEC_AUTHZ_LOGGER.isLoggable(PROGRESS_LEVEL);
        boolean result = true;
        StringBuilder sb = isTaggable ? new StringBuilder(LINE_SEP).append("AccessCheck processing on ").append(command.getClass().getName()).append(LINE_SEP) : null;
        for (AccessCheckWork a : accessChecks) {
            URI resourceURI = this.resourceURIFromAccessCheck(a.accessCheck);
            AzSubject azSubject = this.authService.makeAzSubject(subject);
            AzResource azResource = this.authService.makeAzResource(resourceURI);
            AzAction azAction = this.authService.makeAzAction(a.accessCheck.action());
            HashMap<String, String> subjectAttrs = new HashMap<String, String>();
            HashMap<String, String> resourceAttrs = new HashMap<String, String>();
            HashMap<String, String> actionAttrs = new HashMap<String, String>();
            for (AuthorizationPreprocessor ap : this.authPreprocessors) {
                ap.describeAuthorization(subject, a.accessCheck.resourceName(), a.accessCheck.action(), command, env, subjectAttrs, resourceAttrs, actionAttrs);
            }
            this.mapToAzAttrs(subjectAttrs, (Attributes)azSubject);
            this.mapToAzAttrs(resourceAttrs, (Attributes)azResource);
            this.mapToAzAttrs(actionAttrs, (Attributes)azAction);
            AzResult azResult = this.authService.getAuthorizationDecision(azSubject, azResource, azAction);
            a.accessCheck.setSuccessful(azResult.getDecision() == AzResult.Decision.PERMIT);
            if (isTaggable) {
                sb.append(a.tag).append(LINE_SEP).append("    ").append(this.formattedAccessCheck(resourceURI, a.accessCheck)).append(LINE_SEP);
            }
            result &= !a.accessCheck.isFailureFinal() || a.accessCheck.isSuccessful();
        }
        if (isTaggable) {
            sb.append(LINE_SEP).append("...final result: ").append(result).append(LINE_SEP);
            ADMSEC_AUTHZ_LOGGER.log(PROGRESS_LEVEL, sb.toString());
        }
        return result;
    }

    private String formattedAccessCheck(URI resourceURI, AccessRequired.AccessCheck a) {
        return "AccessCheck " + resourceURI.toASCIIString() + "=" + a.action() + ", isSuccessful=" + a.isSuccessful() + ", isFailureFatal=" + a.isFailureFinal() + "//" + a.note();
    }

    private void mapToAzAttrs(Map<String, String> info, Attributes attrs) {
        for (Map.Entry<String, String> i : info.entrySet()) {
            attrs.addAttribute(i.getKey(), i.getValue(), false);
        }
    }

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks(AdminCommand command, Subject subject) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        List<AccessCheckWork> work = this.assembleAccessCheckWork(command, subject);
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        for (AccessCheckWork w : work) {
            accessChecks.add(w.accessCheck());
        }
        return accessChecks;
    }

    private boolean addChecksFromAccessCheckProvider(final AdminCommand command, List<AccessCheckWork> accessChecks, boolean isTaggable, Subject subject) {
        if (command instanceof AdminCommandSecurity.AccessCheckProvider) {
            Collection<? extends AccessRequired.AccessCheck> checks = Subject.doAs(subject, new PrivilegedAction<Collection<? extends AccessRequired.AccessCheck>>(){

                @Override
                public Collection<? extends AccessRequired.AccessCheck> run() {
                    return ((AdminCommandSecurity.AccessCheckProvider)command).getAccessChecks();
                }
            });
            for (AccessRequired.AccessCheck accessCheck : checks) {
                accessChecks.add(new AccessCheckWork(accessCheck, isTaggable ? "  Class's getAccessChecks()" : null));
            }
            return !checks.isEmpty();
        }
        return false;
    }

    private URI resourceURIFromAccessCheck(AccessRequired.AccessCheck c) throws URISyntaxException, UnsupportedEncodingException {
        return new URI(ADMIN_RESOURCE_SCHEME, this.resourceNameFromAccessCheck(c), null);
    }

    private String resourceNameFromAccessCheck(AccessRequired.AccessCheck c) throws UnsupportedEncodingException {
        String resourceName = c.resourceName();
        if (resourceName == null) {
            resourceName = AccessRequired.Util.resourceNameFromConfigBeanType((ConfigBeanProxy)c.parent(), null, (Class)c.childType());
        }
        if (!resourceName.startsWith("/")) {
            resourceName = '/' + resourceName;
        }
        return URLEncoder.encode(resourceName, RESOURCE_NAME_URL_ENCODING);
    }

    private boolean addChecksFromExplicitAccessRequiredAnnos(AdminCommand command, List<AccessCheckWork> accessChecks, boolean isTaggable) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        boolean isAnnotated = false;
        ClassLineageIterator cIt = new ClassLineageIterator(command.getClass());
        while (cIt.hasNext()) {
            AccessRequired.List arList;
            Object c = cIt.next();
            AccessRequired ar = ((Class)c).getAnnotation(AccessRequired.class);
            if (ar != null) {
                isAnnotated = true;
                this.addAccessChecksFromAnno(ar, command, accessChecks, (Class<?>)c, isTaggable);
            }
            if ((arList = ((Class)c).getAnnotation(AccessRequired.List.class)) != null) {
                isAnnotated = true;
                for (AccessRequired repeatedAR : arList.value()) {
                    this.addAccessChecksFromAnno(repeatedAR, command, accessChecks, (Class<?>)c, isTaggable);
                }
            }
            isAnnotated |= this.addAccessChecksFromFields((Class<?>)c, command, accessChecks, isTaggable);
        }
        return isAnnotated;
    }

    private boolean addAccessChecksFromFields(Class<?> c, AdminCommand command, List<AccessCheckWork> accessChecks, boolean isTaggable) throws IllegalArgumentException, IllegalAccessException {
        boolean isAnnotatedOnFields = false;
        for (Field f : c.getDeclaredFields()) {
            isAnnotatedOnFields |= this.addAccessChecksFromAnno(f, command, accessChecks, isTaggable);
        }
        return isAnnotatedOnFields;
    }

    private void addAccessChecksFromAnno(AccessRequired ar, AdminCommand command, List<AccessCheckWork> accessChecks, Class<?> currentClass, boolean isTaggable) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        for (String resource : ar.resource()) {
            String translatedResource = this.processTokens(resource, command);
            for (String action : ar.action()) {
                AccessRequired.AccessCheck a = new AccessRequired.AccessCheck(translatedResource, action);
                String tag = null;
                if (isTaggable) {
                    tag = "  @AccessRequired on " + currentClass.getName() + LINE_SEP;
                }
                accessChecks.add(new AccessCheckWork(a, tag));
            }
        }
    }

    private boolean addAccessChecksFromAnno(Field f, AdminCommand command, List<AccessCheckWork> accessChecks, boolean isTaggable) throws IllegalArgumentException, IllegalAccessException {
        AccessRequired.NewChild arNC;
        boolean isAnnotated = false;
        f.setAccessible(true);
        AccessRequired.To arTo = f.getAnnotation(AccessRequired.To.class);
        if (arTo != null) {
            isAnnotated = true;
            String resourceNameForField = this.resourceNameFromField(f, command);
            for (String access : arTo.value()) {
                AccessRequired.AccessCheck a = new AccessRequired.AccessCheck(resourceNameForField, access);
                String tag = null;
                if (isTaggable) {
                    tag = "  @AccessRequired.To on field " + f.getDeclaringClass().getName() + "#" + f.getName();
                }
                accessChecks.add(new AccessCheckWork(a, tag));
            }
        }
        if ((arNC = f.getAnnotation(AccessRequired.NewChild.class)) != null) {
            isAnnotated = true;
            String resourceNameForField = this.resourceNameFromNewChildAnno(arNC, f, command);
            for (String action : arNC.action()) {
                AccessRequired.AccessCheck a = new AccessRequired.AccessCheck(resourceNameForField, action);
                String tag = null;
                if (isTaggable) {
                    tag = "  @AccessRequired.NewChild on field " + f.getDeclaringClass().getName() + "#" + f.getName();
                }
                accessChecks.add(new AccessCheckWork(a, tag));
            }
        }
        return isAnnotated;
    }

    private String resourceNameFromNewChildAnno(AccessRequired.NewChild arNC, Field f, AdminCommand command) throws IllegalArgumentException, IllegalAccessException {
        StringBuilder sb = new StringBuilder();
        Object parent = f.get(command);
        Class childType = arNC.type();
        if (!ConfigBeanProxy.class.isAssignableFrom(childType)) {
            throw new SecurityException(Strings.get("secure.admin.childNotConfigBeanProxy", childType.getName()));
        }
        if (ConfigBeanProxy.class.isAssignableFrom(parent.getClass())) {
            sb.append(AccessRequired.Util.resourceNameFromConfigBeanType((ConfigBeanProxy)((ConfigBeanProxy)parent), (String)arNC.collection(), (Class)childType));
        } else if (ConfigBean.class.isAssignableFrom(parent.getClass())) {
            sb.append(AccessRequired.Util.resourceNameFromConfigBeanType((Dom)((ConfigBean)parent), (String)arNC.collection(), (Class)childType));
        }
        return sb.toString();
    }

    private String processTokens(String expr, AdminCommand command) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Matcher m = TOKEN_PATTERN.matcher(expr);
        StringBuffer translated = new StringBuffer();
        while (m.find()) {
            String token;
            String replacementValue = token = m.group(1) != null ? m.group(1) : m.group(2);
            Field f = this.findField(command, token);
            if (f != null) {
                f.setAccessible(true);
                replacementValue = this.resourceNameFromField(f, command);
            }
            m.appendReplacement(translated, replacementValue);
        }
        m.appendTail(translated);
        return translated.toString();
    }

    private Field findField(AdminCommand command, String fieldName) throws NoSuchFieldException {
        Field result = null;
        for (Class<?> c = command.getClass(); c != null; c = c.getSuperclass()) {
            try {
                result = c.getDeclaredField(fieldName);
                return result;
            }
            catch (NoSuchFieldException ex) {
                continue;
            }
        }
        return result;
    }

    private String resourceNameFromField(Field f, AdminCommand command) throws IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        if (ConfigBeanProxy.class.isAssignableFrom(f.getType())) {
            return AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)((ConfigBeanProxy)f.get(command)));
        }
        if (ConfigBean.class.isAssignableFrom(f.getType())) {
            return AccessRequired.Util.resourceNameFromDom((Dom)((ConfigBean)f.get(command)));
        }
        String savedResourceName = this.namedResourceMgr.find(f.get(command));
        if (savedResourceName != null) {
            return savedResourceName;
        }
        return f.get(command).toString();
    }

    private void addChecksFromReSTEndpoints(AdminCommand command, List<AccessCheckWork> accessChecks, boolean isTaggable) {
        ClassLineageIterator cIt = new ClassLineageIterator(command.getClass());
        while (cIt.hasNext()) {
            RestEndpoints restEndpoints;
            Object c = cIt.next();
            RestEndpoint restEndpoint = ((Class)c).getAnnotation(RestEndpoint.class);
            if (restEndpoint != null) {
                this.addAccessChecksFromReSTEndpoint(restEndpoint, accessChecks, isTaggable);
            }
            if ((restEndpoints = ((Class)c).getAnnotation(RestEndpoints.class)) == null) continue;
            for (RestEndpoint re : restEndpoints.value()) {
                this.addAccessChecksFromReSTEndpoint(re, accessChecks, isTaggable);
            }
        }
    }

    private void addAccessChecksFromReSTEndpoint(RestEndpoint restEndpoint, List<AccessCheckWork> accessChecks, boolean isTaggable) {
        if (!restEndpoint.useForAuthorization()) {
            return;
        }
        String action = optypeToAction.get(restEndpoint.opType());
        String resource = CommandSecurityChecker.resourceNameFromRestEndpoint(restEndpoint.configBean(), restEndpoint.path(), this.locator);
        AccessRequired.AccessCheck a = new AccessRequired.AccessCheck(resource, action);
        String tag = null;
        if (isTaggable) {
            tag = "  @RestEndpoint " + restEndpoint.configBean().getName() + ", op=" + restEndpoint.opType();
        }
        accessChecks.add(new AccessCheckWork(a, tag));
    }

    private static String resourceNameFromRestEndpoint(Class<? extends ConfigBeanProxy> c, String path, ServiceLocator locator) {
        String name;
        ConfigBeanProxy b = (ConfigBeanProxy)locator.getService(c, new Annotation[0]);
        String string = name = b != null ? AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)b) : "?";
        if (path != null) {
            name = name + '/' + path;
        }
        return name;
    }

    private static String getCommandName(AdminCommand c) {
        Service serviceAnno = c.getClass().getAnnotation(Service.class);
        if (serviceAnno == null) {
            return "no-name";
        }
        return serviceAnno.name();
    }

    private static class UnguardedCommandAccessCheckWork
    extends AccessCheckWork {
        private UnguardedCommandAccessCheckWork(AdminCommand c) {
            super(new AccessRequired.AccessCheck("unguarded/" + CommandSecurityChecker.getCommandName(c), "execute"), "  Unguarded access control on " + c.getClass().getName());
        }
    }

    private static class AccessCheckWork {
        private final AccessRequired.AccessCheck accessCheck;
        private final String tag;

        private AccessCheckWork(AccessRequired.AccessCheck accessCheck, String tag) {
            this.accessCheck = accessCheck;
            this.tag = tag;
        }

        private AccessRequired.AccessCheck accessCheck() {
            return this.accessCheck;
        }
    }
}

