/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.sun.enterprise.admin.remote.reader.CliActionReport;
import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.api.ActionReport;

@Provider
@Consumes(value={"application/json", "application/x-javascript"})
public class ActionReportJsonReader
implements MessageBodyReader<ActionReport> {
    private static final Logger logger = AdminLoggerInfo.getLogger();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(ActionReport.class);
    }

    public ActionReport readFrom(Class<ActionReport> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)entityStream, (OutputStream)baos, (long)0L);
        String str = baos.toString("UTF-8");
        try {
            JSONObject json = new JSONObject(str);
            CliActionReport result = new CliActionReport();
            ActionReportJsonReader.fillActionReport(result, json);
            return result;
        }
        catch (JSONException ex) {
            logger.log(Level.SEVERE, "NCLS-ADMIN-0011", ex);
            throw new IOException(ex);
        }
    }

    public static void fillActionReport(ActionReport ar, JSONObject json) throws JSONException {
        ar.setActionExitCode(ActionReport.ExitCode.valueOf((String)json.getString("exit_code")));
        ar.setActionDescription(json.optString("command"));
        String failure = json.optString("failure_cause");
        if (failure != null && !failure.isEmpty()) {
            ar.setFailureCause((Throwable)new Exception(failure));
        }
        ar.setExtraProperties((Properties)ActionReportJsonReader.extractMap(json.optJSONObject("extraProperties"), new Properties()));
        ar.getTopMessagePart().setMessage(json.optString("top_message", json.optString("message")));
        Properties props = (Properties)ActionReportJsonReader.extractMap(json.optJSONObject("properties"), new Properties());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            ar.getTopMessagePart().addProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        ActionReportJsonReader.fillSubMessages(ar.getTopMessagePart(), json.optJSONArray("children"));
        JSONArray subJsons = json.optJSONArray("subReports");
        if (subJsons != null) {
            for (int i = 0; i < subJsons.length(); ++i) {
                JSONObject subJson = subJsons.getJSONObject(i);
                ActionReportJsonReader.fillActionReport(ar.addSubActionsReport(), subJson);
            }
        }
    }

    private static void fillSubMessages(ActionReport.MessagePart mp, JSONArray json) throws JSONException {
        if (json == null) {
            return;
        }
        for (int i = 0; i < json.length(); ++i) {
            JSONObject subJson = json.getJSONObject(i);
            ActionReport.MessagePart child = mp.addChild();
            child.setMessage(subJson.optString("message"));
            Properties props = (Properties)ActionReportJsonReader.extractMap(subJson.optJSONObject("properties"), new Properties());
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                child.addProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            ActionReportJsonReader.fillSubMessages(child, subJson.optJSONArray("children"));
        }
    }

    private static Object extractGeneral(Object obj) throws JSONException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONObject) {
            return ActionReportJsonReader.extractMap((JSONObject)obj, null);
        }
        if (obj instanceof JSONArray) {
            return ActionReportJsonReader.extractCollection((JSONArray)obj, null);
        }
        return obj;
    }

    private static Map extractMap(JSONObject json, Map preferredResult) throws JSONException {
        if (json == null) {
            return preferredResult;
        }
        if (preferredResult == null) {
            preferredResult = new HashMap<String, Object>();
        }
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            preferredResult.put(key, ActionReportJsonReader.extractGeneral(json.get(key)));
        }
        return preferredResult;
    }

    private static Collection extractCollection(JSONArray array, Collection preferredResult) throws JSONException {
        if (array == null) {
            return preferredResult;
        }
        if (preferredResult == null) {
            preferredResult = new ArrayList<Object>(array.length());
        }
        for (int i = 0; i < array.length(); ++i) {
            preferredResult.add(ActionReportJsonReader.extractGeneral(array.get(i)));
        }
        return preferredResult;
    }
}

