/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.StringUtils;
import java.util.List;
import org.jvnet.hk2.component.Habitat;

public final class RemoteInstanceCommandHelper {
    private final List<Server> servers;
    private final Nodes nodes;
    private final Habitat habitat;
    private final Domain domain;

    public RemoteInstanceCommandHelper(Habitat habitatIn) {
        try {
            this.habitat = habitatIn;
            this.servers = ((Servers)this.habitat.getByType(Servers.class)).getServer();
            this.domain = (Domain)this.habitat.getByType(Domain.class);
            this.nodes = (Nodes)this.habitat.getByType(Nodes.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final String getHost(String serverName) {
        String host = null;
        Server server = this.getServer(serverName);
        if (server != null) {
            host = server.getAdminHost();
        }
        return host;
    }

    public final Server getServer(String serverName) {
        for (Server server : this.servers) {
            String name = server.getName();
            if (!(serverName == null ? name == null : serverName.equals(name))) continue;
            return server;
        }
        return null;
    }

    public final String getNode(Server server) {
        if (server == null) {
            return null;
        }
        String node = server.getNodeRef();
        if (StringUtils.ok((String)node)) {
            return node;
        }
        return "no node";
    }

    public final int getAdminPort(String serverName) {
        return this.getAdminPort(this.getServer(serverName));
    }

    public final int getAdminPort(Server server) {
        return server.getAdminPort();
    }
}

