/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.ClassUtil;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class ArrayConversion {
    private ArrayConversion() {
    }

    private static Object[] convert(Object simpleArray) {
        String className = simpleArray.getClass().getName();
        Class theClass = ClassUtil.getArrayElementClass(simpleArray.getClass());
        int numItems = Array.getLength(simpleArray);
        Class elementClass = ClassUtil.PrimitiveClassToObjectClass(theClass);
        Object[] result = (Object[])Array.newInstance(elementClass, numItems);
        for (int i = 0; i < numItems; ++i) {
            result[i] = Array.get(simpleArray, i);
        }
        return result;
    }

    public static Object[] toAppropriateType(Object array) {
        return ArrayConversion.convert(array);
    }

    public static Boolean[] toBooleans(boolean[] array) {
        return (Boolean[])ArrayConversion.convert(array);
    }

    public static Character[] toCharacters(char[] array) {
        return (Character[])ArrayConversion.convert(array);
    }

    public static Byte[] toBytes(byte[] array) {
        return (Byte[])ArrayConversion.convert(array);
    }

    public static Short[] toShorts(short[] array) {
        return (Short[])ArrayConversion.convert(array);
    }

    public static Integer[] toIntegers(int[] array) {
        return (Integer[])ArrayConversion.convert(array);
    }

    public static Long[] toLongs(long[] array) {
        return (Long[])ArrayConversion.convert(array);
    }

    public static Float[] toFloats(float[] array) {
        return (Float[])ArrayConversion.convert(array);
    }

    public static Double[] toDoubles(double[] array) {
        return (Double[])ArrayConversion.convert(array);
    }

    public static Object[] createObjectArrayType(Class elementType, int size) throws Exception {
        Object[] result = (Object[])Array.newInstance(elementType, size);
        return result;
    }

    public static Set toSet(Object[] array) {
        Set<Object> theSet = null;
        if (array.length == 0) {
            theSet = Collections.EMPTY_SET;
        } else if (array.length == 1) {
            theSet = Collections.singleton(array[0]);
        } else {
            theSet = new HashSet();
            for (int i = 0; i < array.length; ++i) {
                theSet.add(array[i]);
            }
        }
        return theSet;
    }

    public static Object[] setToArray(Set s) {
        Iterator iter = s.iterator();
        Object[] out = new Object[s.size()];
        return ArrayConversion.setToArray(s, out);
    }

    public static Object[] setToArray(Set s, Object[] out) {
        Iterator iter = s.iterator();
        if (out.length != s.size()) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (iter.hasNext()) {
            out[i] = iter.next();
            ++i;
        }
        return out;
    }
}

