/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

public final class TokenValue
implements Comparable {
    public final String token;
    public final String value;
    public final String delimiter;
    public final String delimitedToken;
    public static final String DEFAULT_DELIMITER = "%%%";

    public TokenValue(String token, String value) {
        this(token, value, DEFAULT_DELIMITER);
    }

    public TokenValue(String token, String value, String delimiter) {
        if (token == null || value == null || delimiter == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        this.token = token;
        this.value = this.escapeBackslashes(value);
        this.delimiter = delimiter;
        this.delimitedToken = delimiter + token + delimiter;
    }

    public TokenValue(TokenValue other) {
        this.token = other.token;
        this.value = other.value;
        this.delimiter = other.delimiter;
        this.delimitedToken = other.delimitedToken;
    }

    public int compareTo(Object other) {
        TokenValue otherTokenValue = (TokenValue)other;
        return this.token.compareTo(otherTokenValue.token);
    }

    public boolean equals(Object other) {
        boolean same = false;
        if (other instanceof TokenValue) {
            same = this.token.equals(((TokenValue)other).token) && this.delimiter.equals(((TokenValue)other).value);
        }
        return same;
    }

    public int hashCode() {
        int result = 43;
        result = 17 * result + this.token.hashCode();
        result = 17 * result + this.delimiter.hashCode();
        result = 17 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return this.delimiter + this.token + this.delimiter + "=" + this.value;
    }

    private String escapeBackslashes(String anyString) {
        int BACK_SLASH = 92;
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < anyString.length(); ++i) {
            char ch = anyString.charAt(i);
            escaped.append(ch);
            if (ch != '\\') continue;
            escaped.append('\\');
        }
        return escaped.toString();
    }
}

