/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.Strings;
import java.util.ArrayList;
import java.util.List;

public class ColumnFormatter {
    private int numCols = -1;
    private String[] headings;
    private List<String[]> valList = new ArrayList<String[]>();

    public ColumnFormatter(String[] headings) {
        this.headings = headings;
        this.numCols = headings.length;
    }

    public ColumnFormatter() {
        this.headings = null;
    }

    public void addRow(Object[] values) throws IllegalArgumentException {
        if (this.numCols != -1 && values.length != this.numCols) {
            throw new IllegalArgumentException(Strings.get("column.internal", values.length, this.numCols));
        }
        this.numCols = values.length;
        String[] v = new String[this.numCols];
        for (int i = 0; i < v.length; ++i) {
            v[i] = values[i] == null ? "" : values[i].toString();
        }
        this.valList.add(v);
    }

    public String toString() {
        if (this.numCols == -1) {
            return "";
        }
        int[] longestValue = new int[this.numCols];
        for (String[] v : this.valList) {
            for (int i = 0; i < v.length; ++i) {
                if (v[i].length() <= longestValue[i]) continue;
                longestValue[i] = v[i].length();
            }
        }
        StringBuilder formattedLineBuf = new StringBuilder();
        for (int i = 0; i < this.numCols; ++i) {
            if (this.headings != null && this.headings[i].length() > longestValue[i]) {
                longestValue[i] = this.headings[i].length();
            }
            int n = i;
            longestValue[n] = longestValue[n] + 2;
            formattedLineBuf.append("%-").append(longestValue[i]).append("s");
        }
        String formattedLine = formattedLineBuf.toString();
        StringBuilder sb = new StringBuilder();
        boolean havePrev = false;
        if (this.headings != null) {
            sb.append(String.format(formattedLine, this.headings));
            havePrev = true;
        }
        for (String[] v : this.valList) {
            if (havePrev) {
                sb.append('\n');
            }
            sb.append(String.format(formattedLine, v));
            havePrev = true;
        }
        return sb.toString();
    }
}

