/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.schemadoc;

import com.sun.enterprise.admin.cli.schemadoc.ClassDef;
import com.sun.enterprise.admin.cli.schemadoc.Context;
import com.sun.enterprise.admin.cli.schemadoc.SchemaOutputFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.admin.config.PropertyDesc;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.types.Property;

@Service(name="html")
public class HtmlFormat
implements SchemaOutputFormat {
    private PrintWriter tocWriter;
    private PrintWriter detail;
    private Set<ClassDef> toc = new HashSet<ClassDef>();
    private File dir;
    private Map<String, ClassDef> defs;

    public void output(Context context) {
        this.dir = context.getDocDir();
        this.defs = context.getClassDefs();
        try {
            try {
                this.tocWriter = new PrintWriter(new FileWriter(new File(this.dir, "toc.HTML")));
                this.detail = new PrintWriter(new FileWriter(new File(this.dir, "detail.HTML")));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            this.println(this.tocWriter, "<HTML><head><link rel=\"stylesheet\" type=\"text/css\" href=\"schemadoc.css\"><style>body{margin-left:-1em;}</style></head><body>");
            this.println(this.detail, "<HTML><head><link rel=\"stylesheet\" type=\"text/css\" href=\"schemadoc.css\"></head><body>");
            this.copyResources();
            this.buildToc(this.defs.get(context.getRootClassName()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.println(this.tocWriter, "</ul>");
            this.footer(this.tocWriter);
            this.footer(this.detail);
            if (this.tocWriter != null) {
                this.tocWriter.close();
            }
            if (this.detail != null) {
                this.detail.close();
            }
        }
    }

    private void buildDetail(ClassDef def) {
        this.println(this.detail, "<p><table><tr>");
        this.println(this.detail, "<a name=\"" + def.getXmlName() + "\">");
        this.println(this.detail, String.format("<th colspan=\"4\" class=\"TableHeadingColor entity %s\">%s%s", def.isDeprecated() ? "deprecated" : "", def.getXmlName(), def.isDeprecated() ? " - DEPRECATED" : ""));
        this.println(this.detail, "</th></tr>");
        this.println(this.detail, "<colgroup><col width=\"35%\"></colgroup>");
        this.printHeaderRow(this.detail, "attribute", "type", "default", "required");
        Map<String, Attribute> map = def.getAttributes();
        if (map != null) {
            for (Map.Entry<String, Attribute> entry : map.entrySet()) {
                this.println(this.detail, String.format("<tr><td class=\"TableSubHeadingColor\">%s</td>", entry.getKey()));
                this.printAttributeData(entry.getValue());
            }
        }
        this.println(this.detail, "</table>");
        this.printPropertyData(def);
    }

    private void println(PrintWriter writer, String text) {
        writer.println(text);
        writer.flush();
    }

    private void printAttributeData(Attribute annotation) {
        this.printKeyValue(this.detail, annotation != null ? annotation.dataType().getName() : null);
        this.printKeyValue(this.detail, annotation != null ? annotation.defaultValue() : null);
        this.printKeyValue(this.detail, annotation != null && annotation.required());
    }

    private void printPropertyData(ClassDef def) {
        Set<PropertyDesc> properties = def.getProperties();
        if (properties != null && !properties.isEmpty()) {
            this.println(this.detail, "<tr><td colspan=\"2\">");
            this.println(this.detail, "<table>");
            this.println(this.detail, "<tr class=\"TableHeadingColor\">");
            this.println(this.detail, "<th colspan=\"4\">Properties</th>");
            this.println(this.detail, "</tr>");
            this.println(this.detail, "<tr class=\"TableHeadingColor\">");
            this.println(this.detail, "<th>name</th>");
            this.println(this.detail, "<th>default</th>");
            this.println(this.detail, "<th>values</th>");
            this.println(this.detail, "<th>description</th>");
            this.println(this.detail, "</tr>");
            for (PropertyDesc property : properties) {
                this.println(this.detail, "<tr>");
                this.println(this.detail, String.format("<td class=\"TableSubHeadingColor\">%s</td>", property.name()));
                this.println(this.detail, String.format("<td class=\"nobreak\">%s</td>", property.defaultValue()));
                this.println(this.detail, String.format("<td>%s</td>", property.values().length == 0 ? "" : Arrays.toString(property.values())));
                this.println(this.detail, String.format("<td>%s</td>", property.description()));
                this.println(this.detail, "</tr>");
            }
            this.println(this.detail, "</table>");
            this.println(this.detail, "</td></tr>");
        }
    }

    private void buildToc(ClassDef def) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (def != null) {
            if (!this.toc.contains(def)) {
                this.buildDetail(def);
            }
            this.toc.add(def);
            this.println(this.tocWriter, "<ul>");
            this.println(this.tocWriter, "<li>" + this.link(def));
            for (Map.Entry<String, String> aggType : def.getAggregatedTypes().entrySet()) {
                if (Property.class.getName().equals(aggType.getValue())) continue;
                this.buildToc(this.defs.get(aggType.getValue()));
            }
            for (ClassDef subclass : def.getSubclasses()) {
                this.buildToc(subclass);
            }
            this.println(this.tocWriter, "</ul>");
        }
    }

    private String link(ClassDef def) {
        return String.format("<a %s target=\"detail\" href=\"detail.html#%s\">%s</a>", def.isDeprecated() ? "class=\"deprecated\"" : "", def.getXmlName(), def.getXmlName());
    }

    private void footer(PrintWriter writer) {
        writer.println("</body></HTML>");
        writer.flush();
        writer.close();
    }

    private void copyResources() throws IOException {
        this.copy("/schemadoc.css");
        this.copy("/index.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String resource) throws IOException {
        InputStreamReader reader = null;
        PrintWriter writer = null;
        try {
            int read;
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resource);
            reader = new InputStreamReader(stream);
            writer = new PrintWriter(new File(this.dir, resource));
            char[] bytes = new char[8192];
            while ((read = reader.read(bytes)) != -1) {
                writer.write(bytes, 0, read);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void printKeyValue(PrintWriter writer, Object value) {
        this.println(writer, "<td>");
        if (value != null) {
            if (value instanceof Class) {
                this.println(writer, ((Class)value).getSimpleName());
            } else {
                this.println(writer, value.toString().trim());
            }
        }
        this.println(writer, "</td>");
    }

    private void printHeaderRow(PrintWriter writer, String ... values) {
        writer.println("<tr class=\"TableHeadingColor\">");
        for (String value : values) {
            writer.println(String.format("<th>%s</th>", value != null ? value.trim() : " "));
        }
        writer.println("</tr>");
    }
}

