/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.schemadoc;

import com.sun.enterprise.admin.cli.schemadoc.ClassDef;
import com.sun.enterprise.admin.cli.schemadoc.Context;
import com.sun.enterprise.admin.cli.schemadoc.DocClassVisitor;
import com.sun.enterprise.admin.cli.schemadoc.SchemaOutputFormat;
import com.sun.enterprise.config.serverbeans.Domain;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="generate-domain-schema")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="generate-domain-schema", description="generate-domain-schema")})
public class GenerateDomainSchema
implements AdminCommand {
    @Inject
    private Domain domain;
    @Inject
    private Habitat habitat;
    @Param(name="format", defaultValue="html", optional=true)
    private String format;
    File docDir;
    private Map<String, ClassDef> classDefs = new HashMap<String, ClassDef>();
    @Param(name="showSubclasses", defaultValue="false", optional=true)
    private Boolean showSubclasses;
    @Param(name="showDeprecated", defaultValue="false", optional=true)
    private Boolean showDeprecated;

    public void execute(AdminCommandContext context) {
        try {
            URI uri = new URI(System.getProperty("com.sun.aas.instanceRootURI"));
            this.docDir = new File(new File(uri), "config");
            this.findClasses(this.classDefs, this.locateJarFiles(System.getProperty("com.sun.aas.installRoot") + "/modules"));
            this.getFormat().output(new Context(this.classDefs, this.docDir, this.showDeprecated, this.showSubclasses, Domain.class.getName()));
            context.getActionReport().setMessage("Finished generating " + this.format + " documentation in " + this.docDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private SchemaOutputFormat getFormat() {
        return (SchemaOutputFormat)this.habitat.getComponent(SchemaOutputFormat.class, this.format);
    }

    private List<JarFile> locateJarFiles(String modulesDir) throws IOException {
        File[] files;
        ArrayList<JarFile> result = new ArrayList<JarFile>();
        for (File f : files = new File(modulesDir).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            result.add(new JarFile(f));
        }
        return result;
    }

    private void findClasses(Map<String, ClassDef> classDefs, List<JarFile> jarFiles) throws IOException {
        for (JarFile jf : jarFiles) {
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                ClassDef def;
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class") || (def = this.parse(jf.getInputStream(entry))) == null) continue;
                classDefs.put(def.getDef(), def);
                for (String intf : def.getInterfaces()) {
                    ClassDef parent = classDefs.get(intf);
                    if (parent == null) continue;
                    parent.addSubclass(def);
                }
            }
        }
        if (this.showSubclasses.booleanValue()) {
            for (ClassDef def : classDefs.values()) {
                for (String anInterface : def.getInterfaces()) {
                    ClassDef parent = classDefs.get(anInterface);
                    if (parent == null) continue;
                    parent.addSubclass(def);
                }
            }
        }
    }

    private ClassDef parse(InputStream is) throws IOException {
        DocClassVisitor visitor = new DocClassVisitor(this.showDeprecated);
        new ClassReader(is).accept((ClassVisitor)visitor, 0);
        return visitor.isConfigured() ? visitor.getClassDef() : null;
    }

    public static String toClassName(String value) {
        int start = value.startsWith("()") ? 2 : 0;
        start = value.substring(start).startsWith("L") ? start + 1 : start;
        int end = value.endsWith(";") ? value.length() - 1 : value.length();
        return value.substring(start, end).replace('/', '.');
    }
}

