/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.hk2.component.InjectionResolver;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.common.util.admin.ManPageFinder;
import org.glassfish.common.util.admin.MapInjectionResolver;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.component.UnsatisfiedDependencyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contract
@Scoped(value=PerLookup.class)
public abstract class CLICommand
implements PostConstruct {
    public static final int ERROR = 1;
    public static final int CONNECTION_ERROR = 2;
    public static final int INVALID_COMMAND_ERROR = 3;
    public static final int SUCCESS = 0;
    public static final int WARNING = 4;
    private static final Set<String> unsupported;
    private static final String UNSUPPORTED_CMD_FILE_NAME = "unsupported-legacy-command-names";
    private static final String PACKAGE_NAME = "com.sun.enterprise.admin.cli";
    private static final LocalStringsImpl strings;
    private static final Map<String, String> systemProps;
    protected static final Logger logger;
    private static final InjectionManager injectionMgr;
    protected String name;
    @Inject
    protected ProgramOptions programOpts;
    @Inject
    protected Environment env;
    protected String[] argv;
    protected CommandModel commandModel;
    protected StringBuilder metadataErrors;
    protected ParameterMap options;
    protected List<String> operands;
    protected Map<String, String> passwords;

    public static CLICommand getCommand(Habitat habitat, String name) throws CommandException {
        CLICommand.checkUnsupportedLegacyCommand(name);
        CLICommand cmd = (CLICommand)habitat.getComponent(CLICommand.class, name);
        if (cmd != null) {
            return cmd;
        }
        logger.finer("Assuming it's a remote command: " + name);
        return new RemoteCommand(name, (ProgramOptions)habitat.getComponent(ProgramOptions.class), (Environment)habitat.getComponent(Environment.class));
    }

    protected CLICommand() {
        Service service = this.getClass().getAnnotation(Service.class);
        this.name = service == null ? "unknown-command" : service.name();
    }

    public void postConstruct() {
        this.initializeLogger();
    }

    protected CLICommand(String name, ProgramOptions programOpts, Environment env) {
        this.name = name;
        this.programOpts = programOpts;
        this.env = env;
        this.initializeLogger();
    }

    public int execute(String ... argv) throws CommandException {
        this.argv = argv;
        this.initializePasswords();
        logger.finer("Prepare");
        this.prepare();
        logger.finer("Process program options");
        this.processProgramOptions();
        logger.finer("Parse command options");
        this.parse();
        if (this.checkHelp()) {
            return 0;
        }
        logger.finer("Prevalidate command options");
        this.prevalidate();
        logger.finer("Inject command options");
        this.inject();
        logger.finer("Validate command options");
        this.validate();
        if (this.programOpts.isEcho()) {
            logger.info(this.echoCommand());
            this.programOpts.setEcho(false);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.echoCommand());
        }
        logger.finer("Execute command");
        return this.executeCommand();
    }

    public String getName() {
        return this.name;
    }

    public ProgramOptions getProgramOptions() {
        return this.programOpts;
    }

    public BufferedReader getManPage() {
        String commandName = this.getName();
        if (commandName.length() == 0) {
            throw new IllegalArgumentException("Command name cannot be empty");
        }
        if (commandName.equals("help")) {
            commandName = this.programOpts.getCommandName();
        }
        return ManPageFinder.getCommandManPage((String)commandName, (String)this.getClass().getName(), (Locale)Locale.getDefault(), (ClassLoader)this.getClass().getClassLoader(), (Logger)logger);
    }

    public String getUsage() {
        String usage;
        if (this.commandModel != null && CLICommand.ok(usage = this.commandModel.getUsageText())) {
            StringBuffer usageText = new StringBuffer();
            usageText.append(strings.get("Usage", new Object[]{strings.get("Usage.brief")}));
            usageText.append(" ");
            usageText.append(usage);
            return usageText.toString();
        }
        return this.generateUsageText();
    }

    private String generateUsageText() {
        String opname;
        StringBuilder usageText = new StringBuilder();
        usageText.append(strings.get("Usage", new Object[]{strings.get("Usage.brief")}));
        usageText.append(" ");
        usageText.append(this.getName());
        int len = usageText.length();
        StringBuilder optText = new StringBuilder();
        String lsep = System.getProperty("line.separator");
        for (CommandModel.ParamModel opt : this.usageOptions()) {
            String sn;
            optText.setLength(0);
            String optName = CLICommand.lc(opt.getName());
            if (optName.equals("terse") || optName.startsWith("_") || opt.getParam().password() || opt.getParam().obsolete() || opt.getParam().primary()) continue;
            boolean optional = opt.getParam().optional();
            String defValue = opt.getParam().defaultValue();
            if (optional) {
                optText.append("[");
            }
            if (CLICommand.ok(sn = opt.getParam().shortName())) {
                optText.append('-').append(sn).append('|');
            }
            optText.append("--").append(optName);
            if (opt.getType() == Boolean.class || opt.getType() == Boolean.TYPE) {
                defValue = CLICommand.ok(defValue) && Boolean.parseBoolean(defValue) ? "true" : "false";
                optText.append("[=<").append(optName);
                optText.append(strings.get("Usage.default", new Object[]{defValue}));
                optText.append(">]");
            } else if (CLICommand.ok(defValue)) {
                optText.append(" <").append(optName);
                optText.append(strings.get("Usage.default", new Object[]{defValue}));
                optText.append('>');
            } else {
                optText.append(" <").append(optName).append('>');
            }
            if (optional) {
                optText.append("]");
            }
            if (len + 1 + optText.length() > 80) {
                usageText.append(lsep).append('\t');
                len = 8;
            } else {
                usageText.append(' ');
                ++len;
            }
            usageText.append((CharSequence)optText);
            len += optText.length();
        }
        String helpText = "[-?|--help[=<help(default:false)>]]";
        if (len + 1 + helpText.length() > 80) {
            usageText.append(lsep).append('\t');
            len = 8;
        } else {
            usageText.append(' ');
            ++len;
        }
        usageText.append(helpText);
        len += helpText.length();
        optText.setLength(0);
        CommandModel.ParamModel operandParam = this.getOperandModel();
        String string = opname = operandParam != null ? CLICommand.lc(operandParam.getName()) : null;
        if (!CLICommand.ok(opname)) {
            opname = "operand";
        }
        boolean operandMin = false;
        int operandMax = 0;
        if (operandParam != null) {
            operandMin = !operandParam.getParam().optional();
            int n = operandMax = operandParam.getParam().multiple() ? Integer.MAX_VALUE : 1;
        }
        if (operandMax > 0) {
            if (!operandMin) {
                optText.append("[").append(opname);
                if (operandMax > 1) {
                    optText.append(" ...");
                }
                optText.append("]");
            } else {
                optText.append(opname);
                if (operandMax > 1) {
                    optText.append(" ...");
                }
            }
        }
        if (len + 1 + optText.length() > 80) {
            usageText.append(lsep).append('\t');
            len = 8;
        } else {
            usageText.append(' ');
            ++len;
        }
        usageText.append((CharSequence)optText);
        return usageText.toString();
    }

    protected Collection<CommandModel.ParamModel> usageOptions() {
        return this.commandModel.getParameters();
    }

    public String getCommandUsage() {
        return strings.get("Usage.full", new Object[]{this.programOpts.getCommandName()});
    }

    public String getBriefCommandUsage() {
        return strings.get("Usage.brief", new Object[]{this.programOpts.getCommandName()});
    }

    public String toString() {
        return this.echoCommand();
    }

    private String echoCommand() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.programOpts.getCommandName());
        sb.append(' ');
        sb.append(this.programOpts.toString()).append(' ');
        sb.append(this.name).append(' ');
        if (this.options != null && this.operands != null) {
            for (CommandModel.ParamModel opt : this.commandModel.getParameters()) {
                if (opt.getParam().password() || opt.getParam().primary()) continue;
                String value = this.getOption(opt.getName());
                if (value == null && (value = opt.getParam().defaultValue()) != null && value.length() == 0) {
                    value = null;
                }
                if (value == null) continue;
                sb.append("--").append(CLICommand.lc(opt.getName()));
                if (opt.getType() == Boolean.class || opt.getType() == Boolean.TYPE) {
                    if (Boolean.parseBoolean(value)) {
                        sb.append("=").append("true");
                    } else {
                        sb.append("=").append("false");
                    }
                } else {
                    sb.append(" ").append(CLICommand.quote(value));
                }
                sb.append(' ');
            }
            for (String o : this.operands) {
                sb.append(CLICommand.quote(o)).append(' ');
            }
        } else if (this.argv != null) {
            for (String arg : this.argv) {
                sb.append(CLICommand.quote(arg)).append(' ');
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String quote(String value) {
        int len = value.length();
        if (len == 0) {
            return "\"\"";
        }
        boolean needQuoting = false;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"' || c == '\\' || c == '\r' || c == '\n') {
                StringBuffer sb = new StringBuffer(len + 3);
                sb.append('\"');
                sb.append(value.substring(0, i));
                int lastc = 0;
                for (int j = i; j < len; ++j) {
                    char cc = value.charAt(j);
                    if (!(cc != '\"' && cc != '\\' && cc != '\r' && cc != '\n' || cc == '\n' && lastc == 13)) {
                        sb.append('\\');
                    }
                    sb.append(cc);
                    lastc = cc;
                }
                sb.append('\"');
                return sb.toString();
            }
            if (c > ' ' && c < '\u007f') continue;
            needQuoting = true;
        }
        if (needQuoting) {
            StringBuffer sb = new StringBuffer(len + 2);
            sb.append('\"').append(value).append('\"');
            return sb.toString();
        }
        return value;
    }

    protected void processProgramOptions() throws CommandException {
        if (!this.programOpts.isOptionsSet()) {
            logger.finer("Parsing program options");
            Parser rcp = new Parser(this.argv, 0, ProgramOptions.getValidOptions(), true);
            ParameterMap params = rcp.getOptions();
            List<String> operands = rcp.getOperands();
            this.argv = operands.toArray(new String[operands.size()]);
            if (params.size() > 0) {
                logger.finer("Update program options");
                this.programOpts.updateOptions(params);
                this.initializeLogger();
                this.initializePasswords();
                if (!(this.programOpts.isTerse() || params.size() == 1 && params.get((Object)"help") != null)) {
                    Collection<CommandModel.ParamModel> programOptions = ProgramOptions.getValidOptions();
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.programOpts.getCommandName());
                    for (Map.Entry p : params.entrySet()) {
                        CommandModel.ParamModel opt = null;
                        for (CommandModel.ParamModel vo : programOptions) {
                            if (!vo.getName().equalsIgnoreCase((String)p.getKey())) continue;
                            opt = vo;
                            break;
                        }
                        if (opt == null) continue;
                        sb.append(" --").append((String)p.getKey());
                        List pl = (List)p.getValue();
                        if (opt.getType() == Boolean.class || opt.getType() == Boolean.TYPE) {
                            if (((String)pl.get(0)).equalsIgnoreCase("true")) continue;
                            sb.append("=false");
                            continue;
                        }
                        if (pl == null || pl.size() <= 0) continue;
                        sb.append(" ").append((String)pl.get(0));
                    }
                    sb.append(" ").append(this.name).append(" [options] ...");
                    logger.info(strings.get("DeprecatedSyntax"));
                    logger.info(sb.toString());
                }
            }
        }
    }

    protected void initializeLogger() {
        if (!logger.isLoggable(Level.FINER)) {
            if (this.programOpts.isTerse()) {
                logger.setLevel(Level.INFO);
            } else {
                logger.setLevel(Level.FINE);
            }
        }
    }

    protected void initializePasswords() throws CommandException {
        this.passwords = new HashMap<String, String>();
        String pwfile = this.programOpts.getPasswordFile();
        if (CLICommand.ok(pwfile)) {
            this.passwords = CLIUtil.readPasswordFileOptions(pwfile, true);
            logger.finer("Passwords were read from password file: " + pwfile);
            String password = this.passwords.get(Environment.PREFIX + "PASSWORD");
            if (password != null && this.programOpts.getPassword() == null) {
                this.programOpts.setPassword(password, ProgramOptions.PasswordLocation.PASSWORD_FILE);
            }
        }
    }

    protected void prepare() throws CommandException {
        this.commandModel = new CommandModelImpl(this.getClass());
    }

    protected void parse() throws CommandException {
        if (this.programOpts.isHelp()) {
            this.options = new ParameterMap();
            this.options.set((Object)"help", (Object)"true");
            this.operands = Collections.emptyList();
        } else {
            Parser rcp = new Parser(this.argv, 1, this.commandModel.getParameters(), this.commandModel.unknownOptionsAreOperands());
            this.options = rcp.getOptions();
            this.operands = rcp.getOperands();
            if (this.commandModel.unknownOptionsAreOperands() && this.operands.size() > 0 && this.operands.get(0).equals("--")) {
                this.operands.remove(0);
            }
        }
        logger.finer("params: " + this.options);
        logger.finer("operands: " + this.operands);
    }

    protected boolean checkHelp() throws CommandException {
        if (this.programOpts.isHelp()) {
            BufferedReader br = this.getManPage();
            if (br == null) {
                throw new CommandException(strings.get("ManpageMissing", new Object[]{this.name}));
            }
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException ioex) {
                throw new CommandException(strings.get("ManpageMissing", new Object[]{this.name}), (Throwable)ioex);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
            return true;
        }
        return false;
    }

    protected void prevalidate() throws CommandException {
        if (!(this instanceof RemoteCommand)) {
            Scoped scoped = this.getClass().getAnnotation(Scoped.class);
            if (scoped == null) {
                throw new CommandException(strings.get("NoScope", new Object[]{this.name}));
            }
            if (scoped.value() == Singleton.class && this.commandModel.getParameters().size() > 0) {
                throw new CommandException(strings.get("HasParams", new Object[]{this.name}));
            }
        }
        Console cons = this.programOpts.isInteractive() ? System.console() : null;
        boolean missingOption = false;
        for (CommandModel.ParamModel opt : this.commandModel.getParameters()) {
            if (opt.getParam().password()) continue;
            if (opt.getParam().obsolete() && this.getOption(opt.getName()) != null) {
                logger.info(strings.get("ObsoleteOption", new Object[]{opt.getName()}));
            }
            if (opt.getParam().optional() || opt.getParam().primary()) continue;
            if (this.getOption(opt.getName()) == null && cons != null && !missingOption) {
                cons.printf("%s", strings.get("optionPrompt", new Object[]{CLICommand.lc(opt.getName())}));
                String val = cons.readLine();
                if (CLICommand.ok(val)) {
                    this.options.set((Object)opt.getName(), (Object)val);
                }
            }
            if (this.getOption(opt.getName()) == null) {
                missingOption = true;
                logger.info(strings.get("missingOption", new Object[]{"--" + opt.getName()}));
            }
            if (!opt.getParam().obsolete()) continue;
            logger.info(strings.get("ObsoleteOption", new Object[]{opt.getName()}));
        }
        if (missingOption) {
            throw new CommandValidationException(strings.get("missingOptions", new Object[]{this.name}));
        }
        int operandMin = 0;
        int operandMax = 0;
        CommandModel.ParamModel operandParam = this.getOperandModel();
        if (operandParam != null) {
            operandMin = operandParam.getParam().optional() ? 0 : 1;
            int n = operandMax = operandParam.getParam().multiple() ? Integer.MAX_VALUE : 1;
        }
        if (this.operands.size() < operandMin && cons != null) {
            cons.printf("%s", strings.get("operandPrompt", new Object[]{operandParam.getName()}));
            String val = cons.readLine();
            if (CLICommand.ok(val)) {
                this.operands = new ArrayList<String>();
                this.operands.add(val);
            }
        }
        if (this.operands.size() < operandMin) {
            throw new CommandValidationException(strings.get("notEnoughOperands", new Object[]{this.name, operandParam.getType()}));
        }
        if (this.operands.size() > operandMax) {
            if (operandMax == 0) {
                throw new CommandValidationException(strings.get("noOperandsAllowed", new Object[]{this.name}));
            }
            if (operandMax == 1) {
                throw new CommandValidationException(strings.get("tooManyOperands1", new Object[]{this.name}));
            }
            throw new CommandValidationException(strings.get("tooManyOperands", new Object[]{this.name, operandMax}));
        }
        this.initializeCommandPassword();
    }

    protected void inject() throws CommandException {
        this.options.set((Object)"DEFAULT", this.operands);
        if (this.commandModel.getModelFor("terse") != null) {
            this.options.set((Object)"terse", (Object)Boolean.toString(this.programOpts.isTerse()));
        }
        MapInjectionResolver injector = new MapInjectionResolver(this.commandModel, this.options);
        try {
            injectionMgr.inject((Object)this, new InjectionResolver[]{injector});
        }
        catch (UnsatisfiedDependencyException e) {
            throw new CommandValidationException(e.getMessage(), (Throwable)e);
        }
    }

    protected void validate() throws CommandException {
    }

    protected abstract int executeCommand() throws CommandException;

    private void initializeCommandPassword() throws CommandException {
        for (CommandModel.ParamModel opt : this.commandModel.getParameters()) {
            if (!opt.getParam().password()) continue;
            String pwdname = opt.getName();
            String pwd = this.getPassword(opt, null, true);
            if (pwd == null) {
                if (opt.getParam().optional()) continue;
                String msg = this.programOpts.isTerse() ? strings.get("missingPassword", new Object[]{this.name, pwdname}) : strings.get("missingPasswordAdvice", new Object[]{this.name, pwdname});
                throw new CommandValidationException(msg);
            }
            this.options.set((Object)pwdname, (Object)pwd);
        }
    }

    protected String getPassword(CommandModel.ParamModel opt, String defaultPassword, boolean create) throws CommandValidationException {
        String passwordName = opt.getName();
        String password = this.passwords.get(passwordName);
        if (password != null) {
            return password;
        }
        if (opt.getParam().optional()) {
            return null;
        }
        if (!this.programOpts.isInteractive()) {
            return null;
        }
        String description = null;
        if (opt instanceof CommandModelData.ParamModelData) {
            description = ((CommandModelData.ParamModelData)opt).getDescription();
        }
        String newprompt = CLICommand.ok(description) ? (defaultPassword != null ? (defaultPassword.length() == 0 ? strings.get("NewPasswordDescriptionDefaultEmptyPrompt", new Object[]{description}) : strings.get("NewPasswordDescriptionDefaultPrompt", new Object[]{description, defaultPassword})) : strings.get("NewPasswordDescriptionPrompt", new Object[]{description})) : (defaultPassword != null ? (defaultPassword.length() == 0 ? strings.get("NewPasswordDefaultEmptyPrompt", new Object[]{passwordName}) : strings.get("NewPasswordDefaultPrompt", new Object[]{passwordName, defaultPassword})) : strings.get("NewPasswordPrompt", new Object[]{passwordName}));
        String newpassword = this.readPassword(newprompt);
        if (defaultPassword != null) {
            if (newpassword == null) {
                newpassword = "";
            }
            if (newpassword.length() == 0) {
                newpassword = defaultPassword;
                this.passwords.put(passwordName, newpassword);
                return newpassword;
            }
        }
        if (!create) {
            this.passwords.put(passwordName, newpassword);
            return newpassword;
        }
        String confirmationPrompt = CLICommand.ok(description) ? strings.get("NewPasswordDescriptionConfirmationPrompt", new Object[]{description}) : strings.get("NewPasswordConfirmationPrompt", new Object[]{passwordName});
        String newpasswordAgain = this.readPassword(confirmationPrompt);
        if (!newpassword.equals(newpasswordAgain)) {
            throw new CommandValidationException(strings.get("OptionsDoNotMatch", new Object[]{CLICommand.ok(description) ? description : passwordName}));
        }
        this.passwords.put(passwordName, newpassword);
        return newpassword;
    }

    protected String readPassword(String prompt) {
        String password = null;
        Console cons = System.console();
        if (cons != null) {
            char[] pc = cons.readPassword("%s", prompt);
            password = new String(pc);
        }
        return password;
    }

    protected CommandModel.ParamModel getOperandModel() {
        for (CommandModel.ParamModel pm : this.commandModel.getParameters()) {
            if (!pm.getParam().primary()) continue;
            return pm;
        }
        return null;
    }

    protected String getOption(String name) {
        String def;
        CommandModel.ParamModel opt;
        String val = (String)this.options.getOne((Object)name);
        if (val == null) {
            val = this.env.getStringOption(name);
        }
        if (val == null && (opt = this.commandModel.getModelFor(name)) != null && CLICommand.ok(def = opt.getParam().defaultValue())) {
            val = def;
        }
        return val;
    }

    protected boolean getBooleanOption(String name) {
        String val = this.getOption(name);
        return val != null && Boolean.parseBoolean(val);
    }

    protected String getSystemProperty(String name) {
        return systemProps.get(name);
    }

    protected Map<String, String> getSystemProperties() {
        return systemProps;
    }

    private static void checkUnsupportedLegacyCommand(String cmd) throws CommandException {
        for (String c : unsupported) {
            if (!c.equals(cmd)) continue;
            throw new CommandException(strings.get("UnsupportedLegacyCommand", new Object[]{cmd}));
        }
    }

    protected void printExceptionStackTrace(Throwable e) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream(512);
        e.printStackTrace(new PrintStream(output));
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.finer(output.toString());
    }

    protected static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static String lc(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void file2Set(String file, Set<String> set) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = CLICommand.class.getClassLoader().getResourceAsStream(file);
            if (is == null) {
                return;
            }
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer tok = new StringTokenizer(line, " ");
                String cmd = tok.nextToken();
                set.add(cmd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        strings = new LocalStringsImpl(CLICommand.class);
        systemProps = Collections.unmodifiableMap(new ASenvPropertyReader().getProps());
        logger = Logger.getLogger(CLICommand.class.getPackage().getName());
        injectionMgr = new InjectionManager();
        HashSet<String> unsup = new HashSet<String>();
        CLICommand.file2Set(UNSUPPORTED_CMD_FILE_NAME, unsup);
        unsupported = Collections.unmodifiableSet(unsup);
    }
}

