/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.server.async;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.WebTarget;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Main {
    public static void main(String[] args) {
        System.exit(Main.runClient(args));
    }

    static int runClient(String[] args) {
        Config config = Config.parse(args);
        System.out.println(String.format("\nStarting to execute %d requests:\n", config.requests));
        Client client = ClientBuilder.newClient();
        final WebTarget echoResource = client.target(config.baseUri).path("long-running/{mode}/{echo}").resolveTemplate("mode", (Object)(config.sync ? "sync" : "async"));
        final CountDownLatch latch = new CountDownLatch(config.requests);
        final ConcurrentLinkedQueue<String> errors = new ConcurrentLinkedQueue<String>();
        final AtomicInteger requestCounter = new AtomicInteger(0);
        long tic = System.currentTimeMillis();
        int i = 0;
        while (i < config.requests) {
            final int reqId = i++;
            echoResource.resolveTemplate("echo", (Object)reqId).request().async().get((InvocationCallback)new InvocationCallback<String>(){
                private final AtomicInteger retries = new AtomicInteger(0);

                public void completed(String response) {
                    String requestId = Integer.toString(reqId);
                    if (requestId.equals(response)) {
                        System.out.print("*");
                        requestCounter.incrementAndGet();
                    } else {
                        System.out.print("!");
                        errors.offer(String.format("Echo response '%s' not equal to request '%s'", response, requestId));
                    }
                    latch.countDown();
                }

                public void failed(Throwable error) {
                    if (error.getCause() instanceof IOException && this.retries.getAndIncrement() < 3) {
                        echoResource.resolveTemplate("echo", (Object)reqId).request().async().get((InvocationCallback)this);
                    } else {
                        System.out.print("!");
                        errors.offer(String.format("Request '%d' has failed: %s", reqId, error.toString()));
                        latch.countDown();
                    }
                }
            });
        }
        try {
            if (!latch.await(60L, TimeUnit.SECONDS)) {
                errors.offer("Waiting for requests to complete has timed out.");
            }
        }
        catch (InterruptedException e) {
            errors.offer("Waiting for requests to complete has been interrupted.");
        }
        long toc = System.currentTimeMillis();
        System.out.println(String.format("\n\nExecution finished in %d ms.\nSuccess rate: %6.2f %%", toc - tic, (double)requestCounter.get() / (double)config.requests * 100.0));
        if (errors.size() > 0) {
            System.out.println("Following errors occurred during the request execution");
            for (String error : errors) {
                System.out.println("\t" + error);
            }
        }
        client.close();
        return errors.size() > 0 ? -1 : 0;
    }

    static class Config {
        public static final String DEFAULT_BASE_URI = "http://localhost:8080/server-async-standalone-webapp/";
        final String baseUri;
        final boolean sync;
        final int requests;

        Config(String baseUri, boolean sync, int requests) {
            this.baseUri = baseUri;
            this.sync = sync;
            this.requests = requests;
        }

        public static Config parse(String[] args) {
            String baseUri = DEFAULT_BASE_URI;
            boolean sync = false;
            int requests = 10;
            for (String arg : args) {
                String[] keyValuePair = arg.trim().split("=");
                if ("uri".equals(keyValuePair[0])) {
                    baseUri = keyValuePair[1];
                    continue;
                }
                if ("mode".equals(keyValuePair[0])) {
                    sync = "sync".equals(keyValuePair[1]);
                    continue;
                }
                if ("req".equals(keyValuePair[0])) {
                    requests = Integer.parseInt(keyValuePair[1]);
                    continue;
                }
                System.out.println("WARNING: Unknown parameter: " + keyValuePair[0]);
            }
            return new Config(baseUri, sync, requests);
        }

        public String toString() {
            return "Config{baseUri='" + this.baseUri + '\'' + ", sync=" + this.sync + ", requests=" + this.requests + '}';
        }
    }
}

