/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.examples.expect100continue.netty.connector;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ServerSocketFactory;

public class SocketServer {
    private static final String NO_CONTENT_HEADER = "HTTP/1.1 204 No Content";
    private static final String OK_HEADER = "HTTP/1.1 200 OK";
    private static final String EXPECT_HEADER = "HTTP/1.1 100 Continue";
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private AtomicBoolean expect_processed = new AtomicBoolean(false);
    private ServerSocket server;
    private static final boolean debug = true;
    private static final int port = 3000;
    private volatile boolean stopped = false;

    public static void main(String[] args) throws IOException {
        new SocketServer(3000).runServer();
    }

    SocketServer(int port) throws IOException {
        ServerSocketFactory socketFactory = ServerSocketFactory.getDefault();
        this.server = socketFactory.createServerSocket(port);
    }

    void stop() {
        this.stopped = true;
        try {
            this.server.close();
            this.executorService.shutdown();
            while (!this.executorService.isTerminated()) {
                this.executorService.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void runServer() {
        this.executorService.execute(() -> {
            block3: {
                try {
                    this.dumpServerReadMe();
                    while (!this.stopped) {
                        Socket socket = this.server.accept();
                        this.executorService.submit(() -> this.processRequest(socket));
                    }
                }
                catch (IOException e) {
                    if (this.stopped) break block3;
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(Socket request) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(request.getInputStream()));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(request.getOutputStream()));){
            while (!this.stopped) {
                Map<String, String> headers = this.mapHeaders(reader);
                if (headers.isEmpty()) continue;
                this.dumpHeaders(headers);
                boolean failed = this.processExpect100Continue(headers, writer);
                if (failed) continue;
                String http_header = this.expect_processed.get() ? NO_CONTENT_HEADER : OK_HEADER;
                boolean read = this.readBody(reader, headers);
                StringBuffer responseBuffer = new StringBuffer(http_header);
                this.addNewLineToResponse(responseBuffer);
                this.addServerHeaderToResponse(responseBuffer);
                this.addNewLineToResponse(responseBuffer);
                this.addNewLineToResponse(responseBuffer);
                this.dumpResponse(responseBuffer);
                writer.write(responseBuffer.toString());
                writer.flush();
                if (!read) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                request.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addNewLineToResponse(StringBuffer responseBuffer) {
        this.addToResponse("\r\n", responseBuffer);
    }

    private void addToResponse(String toBeAdded, StringBuffer responseBuffer) {
        responseBuffer.append(toBeAdded);
    }

    private void addServerHeaderToResponse(StringBuffer responseBuffer) {
        this.addToResponse("Server: Example Socket Server v.0.0.1", responseBuffer);
        this.addNewLineToResponse(responseBuffer);
    }

    private boolean processExpect100Continue(Map<String, String> headers, BufferedWriter writer) throws IOException {
        String http_header = EXPECT_HEADER;
        boolean failed = false;
        String continueHeader = headers.remove("expect");
        if (continueHeader != null && continueHeader.contains("100-continue")) {
            this.expect_processed.set(http_header.equals(EXPECT_HEADER));
            StringBuffer responseBuffer = new StringBuffer(http_header);
            this.addNewLineToResponse(responseBuffer);
            this.addToResponse("Connection: keep-alive", responseBuffer);
            this.addNewLineToResponse(responseBuffer);
            this.addNewLineToResponse(responseBuffer);
            this.dumpResponse(responseBuffer);
            writer.write(responseBuffer.toString());
            writer.flush();
        }
        return failed;
    }

    private Map<String, String> mapHeaders(BufferedReader reader) throws IOException {
        String line;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!reader.ready()) {
            return headers;
        }
        while ((line = reader.readLine()) != null && !line.isEmpty()) {
            int pos = line.indexOf(58);
            if (pos <= -1) continue;
            headers.put(line.substring(0, pos).toLowerCase(Locale.ROOT), line.substring(pos + 2).toLowerCase(Locale.ROOT).trim());
        }
        return headers;
    }

    private boolean readBody(BufferedReader reader, Map<String, String> headers) throws IOException {
        if (headers.containsKey("content-length")) {
            int contentLength = Integer.valueOf(headers.get("content-length"));
            int actualLength = 0;
            int readingByte = 0;
            int[] buffer = new int[contentLength];
            while (actualLength < contentLength && (readingByte = reader.read()) != -1) {
                buffer[actualLength++] = readingByte;
            }
            System.out.println("Reading " + actualLength + " of " + contentLength + " bytes/chars");
            return actualLength == contentLength;
        }
        if (headers.containsKey("transfer-encoding")) {
            String line;
            while ((line = reader.readLine()) != null && !line.equals("0")) {
                System.out.println(line);
            }
            return true;
        }
        return false;
    }

    private void dumpHeaders(Map<String, String> headers) {
        System.out.println("==== DUMPING HEADERS ====");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            System.out.println(entry.getKey() + ", " + entry.getValue());
        }
        System.out.println("==== HEADERS DUMPED =====");
    }

    private void dumpResponse(StringBuffer responseBuffer) {
        System.out.println("==== DUMPING RESPONSE ====");
        System.out.println(responseBuffer);
        System.out.println("==== RESPONSE DUMPED =====");
    }

    private void dumpServerReadMe() {
        System.out.println("==================================Server is running========================================");
        System.out.println("=                                       ***                                               =");
        System.out.println("= ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ =");
        System.out.println("=  You can send requests to it either using Netty Client or curl or any other http tool.  =");
        System.out.println("=  Try to modify it to see how Expect: 100-continue header works.                         =");
        System.out.println("= ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ =");
        System.out.println("=                               stop server by Ctrl-c                                     =");
        System.out.println("= ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ =");
        System.out.println("=  Run server using maven:                                                                =");
        System.out.println("=          mvn clean package exec:java                                                    =");
        System.out.println("=  Run client using maven:                                                                =");
        System.out.println("=          mvn clean package exec:java -Pclient                                           =");
        System.out.println("= ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ =");
        System.out.println("=                                       ***                                               =");
        System.out.println("===========================================================================================");
    }
}

