/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.examples.configuration.webserver.internal;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.glassfish.examples.configuration.webserver.WebServer;
import org.glassfish.examples.configuration.webserver.internal.SSLCertificateService;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.configuration.api.Configured;
import org.glassfish.hk2.configuration.api.ConfiguredBy;
import org.jvnet.hk2.annotations.Service;

@Service
@ConfiguredBy(value="WebServerBean")
public class WebServerImpl
implements WebServer {
    @Configured
    private String name;
    @Configured
    private int adminPort;
    private int openAdminPort = -1;
    @Configured(dynamicity=Configured.Dynamicity.FULLY_DYNAMIC)
    private String address;
    private int sslPort;
    private int openSSLPort = -1;
    private int port;
    private int openPort = -1;
    private boolean opened = false;
    @Inject
    private IterableProvider<SSLCertificateService> certificates;

    private void setUserPorts(@Configured(value="SSLPort", dynamicity=Configured.Dynamicity.FULLY_DYNAMIC) int sslPort, @Configured(value="port", dynamicity=Configured.Dynamicity.FULLY_DYNAMIC) int port) {
        this.sslPort = sslPort;
        this.port = port;
        if (this.opened) {
            this.openSSLPort = sslPort;
            this.openPort = port;
        }
    }

    @PostConstruct
    private void postConstruct() {
        this.opened = true;
    }

    @PreDestroy
    private void preDestroy() {
        this.openPort = -1;
        this.openSSLPort = -1;
        this.openAdminPort = -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int openAdminPort() {
        this.openAdminPort = this.adminPort;
        return this.adminPort;
    }

    @Override
    public int openSSLPort() {
        this.openSSLPort = this.sslPort;
        return this.sslPort;
    }

    @Override
    public int openPort() {
        this.openPort = this.port;
        return this.port;
    }

    @Override
    public int getAdminPort() {
        return this.openAdminPort;
    }

    @Override
    public int getSSLPort() {
        return this.openSSLPort;
    }

    @Override
    public int getPort() {
        return this.openPort;
    }

    @Override
    public List<File> getCertificates() {
        LinkedList<File> retVal = new LinkedList<File>();
        for (SSLCertificateService certService : this.certificates) {
            retVal.add(certService.getCertificate());
        }
        return retVal;
    }
}

