/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.pbuf.internal;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildDescriptor;
import org.glassfish.hk2.xml.internal.ChildType;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;
import org.glassfish.hk2.xml.spi.Model;
import org.glassfish.hk2.xml.spi.PreGenerationRequirement;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

@Singleton
@Named(value="PBufXmlParser")
public class PBufParser
implements XmlServiceParser {
    private final HashMap<Class<?>, Descriptors.Descriptor> allProtos = new HashMap();
    @Inject
    @Named(value="PBufXmlParser")
    private IterableProvider<XmlService> xmlService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T parseRoot(Model rootModel, URI location, Unmarshaller.Listener listener) throws Exception {
        InputStream is = location.toURL().openStream();
        try {
            T t = this.parseRoot(rootModel, is, listener);
            return t;
        }
        finally {
            is.close();
        }
    }

    public <T> T parseRoot(Model rootModel, InputStream input, Unmarshaller.Listener listener) throws Exception {
        try {
            LinkedList<Descriptors.FileDescriptor> protoFiles = new LinkedList<Descriptors.FileDescriptor>();
            this.convertAllModels((ModelImpl)rootModel, protoFiles);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        DynamicMessage message = this.internalUnmarshal((ModelImpl)rootModel, input);
        XmlHk2ConfigurationBean retVal = this.parseDynamicMessage((ModelImpl)rootModel, null, message, listener);
        return (T)retVal;
    }

    public PreGenerationRequirement getPreGenerationRequirement() {
        return PreGenerationRequirement.MUST_PREGENERATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void marshal(OutputStream outputStream, XmlRootHandle<T> root) throws IOException {
        Object rootObject = root.getRoot();
        if (rootObject == null) {
            return;
        }
        XmlHk2ConfigurationBean rootBean = (XmlHk2ConfigurationBean)rootObject;
        ModelImpl model = rootBean._getModel();
        try {
            LinkedList<Descriptors.FileDescriptor> protoFiles = new LinkedList<Descriptors.FileDescriptor>();
            this.convertAllModels(model, protoFiles);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        DynamicMessage dynamicMessage = this.internalMarshal(rootBean);
        CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)outputStream);
        try {
            dynamicMessage.writeTo(cos);
        }
        finally {
            cos.flush();
        }
    }

    private XmlHk2ConfigurationBean parseDynamicMessage(ModelImpl model, XmlHk2ConfigurationBean parent, DynamicMessage message, Unmarshaller.Listener listener) throws IOException {
        BaseHK2JAXBBean bean = (BaseHK2JAXBBean)((XmlService)this.xmlService.get()).createBean(model.getOriginalInterfaceAsClass());
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        listener.beforeUnmarshal((Object)bean, (Object)parent);
        block5: for (Map.Entry entry : model.getAllChildrenDescriptors().entrySet()) {
            QName qname = (QName)entry.getKey();
            ChildDescriptor childDescriptor = (ChildDescriptor)entry.getValue();
            String localPart = qname.getLocalPart();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(localPart);
            if (fieldDescriptor == null) {
                throw new IOException("Unknown field " + localPart + " in " + bean);
            }
            Object value = message.getField(fieldDescriptor);
            if (value == null) continue;
            ChildDataModel childDataModel = childDescriptor.getChildDataModel();
            if (childDataModel != null) {
                value = PBufParser.convertFieldForUnmarshal(value, childDataModel);
                bean._setProperty(qname, value);
                continue;
            }
            ParentedModel parentedNode = childDescriptor.getParentedModel();
            DynamicMessage dynamicChild = null;
            XmlHk2ConfigurationBean child = null;
            int repeatedFieldCount = 0;
            switch (parentedNode.getChildType()) {
                case DIRECT: {
                    if (!(value instanceof DynamicMessage)) {
                        throw new AssertionError((Object)("Do not know how to handle a non-dynamic direct message " + value));
                    }
                    dynamicChild = (DynamicMessage)value;
                    child = this.parseDynamicMessage(parentedNode.getChildModel(), (XmlHk2ConfigurationBean)bean, dynamicChild, listener);
                    bean._setProperty(qname, (Object)child);
                    continue block5;
                }
                case LIST: {
                    repeatedFieldCount = message.getRepeatedFieldCount(fieldDescriptor);
                    ArrayList<XmlHk2ConfigurationBean> list = new ArrayList<XmlHk2ConfigurationBean>(repeatedFieldCount);
                    for (int lcv = 0; lcv < repeatedFieldCount; ++lcv) {
                        Object childBean = message.getRepeatedField(fieldDescriptor, lcv);
                        if (!(childBean instanceof DynamicMessage)) {
                            throw new AssertionError((Object)("Do not know how to handle a non-dynamic list message " + childBean));
                        }
                        dynamicChild = (DynamicMessage)childBean;
                        child = this.parseDynamicMessage(parentedNode.getChildModel(), (XmlHk2ConfigurationBean)bean, dynamicChild, listener);
                        list.add(child);
                    }
                    bean._setProperty(qname, list);
                    continue block5;
                }
                case ARRAY: {
                    ModelImpl childModel = parentedNode.getChildModel();
                    repeatedFieldCount = message.getRepeatedFieldCount(fieldDescriptor);
                    Object array = Array.newInstance(childModel.getOriginalInterfaceAsClass(), repeatedFieldCount);
                    for (int lcv = 0; lcv < repeatedFieldCount; ++lcv) {
                        Object childBean = message.getRepeatedField(fieldDescriptor, lcv);
                        if (!(childBean instanceof DynamicMessage)) {
                            throw new AssertionError((Object)("Do not know how to handle a non-dynamic array message " + childBean));
                        }
                        dynamicChild = (DynamicMessage)childBean;
                        child = this.parseDynamicMessage(parentedNode.getChildModel(), (XmlHk2ConfigurationBean)bean, dynamicChild, listener);
                        Array.set(array, lcv, child);
                    }
                    bean._setProperty(qname, array);
                    continue block5;
                }
            }
            throw new IOException("Unknown child type: " + parentedNode.getChildType());
        }
        listener.afterUnmarshal((Object)bean, (Object)parent);
        return bean;
    }

    private synchronized DynamicMessage internalUnmarshal(ModelImpl model, InputStream is) throws Exception {
        Class originalAsClass = model.getOriginalInterfaceAsClass();
        String originalInterface = model.getOriginalInterface();
        String protoName = PBufParser.getSimpleName(originalInterface);
        Descriptors.Descriptor descriptor = this.allProtos.get(originalAsClass);
        if (descriptor == null) {
            throw new IOException("Unknown model: " + originalInterface + " with protoName=" + protoName);
        }
        DynamicMessage retVal = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (InputStream)is);
        return retVal;
    }

    private synchronized <T> DynamicMessage internalMarshal(XmlHk2ConfigurationBean bean) throws IOException {
        Map blm = bean._getBeanLikeMap();
        ModelImpl model = bean._getModel();
        Class originalAsClass = model.getOriginalInterfaceAsClass();
        String originalInterface = model.getOriginalInterface();
        String protoName = PBufParser.getSimpleName(originalInterface);
        Descriptors.Descriptor descriptor = this.allProtos.get(originalAsClass);
        if (descriptor == null) {
            throw new IOException("Unknown model: " + originalInterface + " with protoName=" + protoName);
        }
        DynamicMessage.Builder retValBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        block5: for (Map.Entry allEntry : model.getAllChildrenDescriptors().entrySet()) {
            QName qname = (QName)allEntry.getKey();
            ChildDescriptor childDescriptor = (ChildDescriptor)allEntry.getValue();
            String localPart = qname.getLocalPart();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(localPart);
            if (fieldDescriptor == null) {
                throw new IOException("Unknown field " + localPart + " in " + bean);
            }
            ChildDataModel childDataModel = childDescriptor.getChildDataModel();
            if (childDataModel != null) {
                Object value = blm.get(localPart);
                Object convertedValue = PBufParser.convertFieldForMarshal(value);
                retValBuilder.setField(fieldDescriptor, convertedValue);
                continue;
            }
            ParentedModel parentedModel = childDescriptor.getParentedModel();
            switch (parentedModel.getChildType()) {
                case DIRECT: {
                    Object directValue = blm.get(localPart);
                    if (directValue == null) continue block5;
                    DynamicMessage subMessage = this.internalMarshal((XmlHk2ConfigurationBean)directValue);
                    retValBuilder.setField(fieldDescriptor, (Object)subMessage);
                    break;
                }
                case LIST: {
                    Object listValue = blm.get(localPart);
                    if (listValue == null) continue block5;
                    List asList = (List)listValue;
                    for (XmlHk2ConfigurationBean child : asList) {
                        DynamicMessage subMessage = this.internalMarshal(child);
                        retValBuilder.addRepeatedField(fieldDescriptor, (Object)subMessage);
                    }
                    continue block5;
                }
                case ARRAY: {
                    Object arrayValue = blm.get(localPart);
                    if (arrayValue == null) continue block5;
                    int count = Array.getLength(arrayValue);
                    for (int lcv = 0; lcv < count; ++lcv) {
                        XmlHk2ConfigurationBean child = (XmlHk2ConfigurationBean)Array.get(arrayValue, lcv);
                        DynamicMessage subMessage = this.internalMarshal(child);
                        retValBuilder.addRepeatedField(fieldDescriptor, (Object)subMessage);
                    }
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)("Unknown child type: " + parentedModel.getChildType()));
                }
            }
        }
        return retValBuilder.build();
    }

    private synchronized void convertAllModels(ModelImpl model, List<Descriptors.FileDescriptor> protoFiles) throws Exception {
        Class modelClass = model.getOriginalInterfaceAsClass();
        if (this.allProtos.containsKey(modelClass)) {
            return;
        }
        for (ParentedModel pModel : model.getAllChildren()) {
            this.convertAllModels(pModel.getChildModel(), protoFiles);
        }
        if (this.allProtos.containsKey(modelClass)) {
            return;
        }
        Descriptors.Descriptor converted = PBufParser.convertModelToDescriptor(model, protoFiles);
        protoFiles.add(converted.getFile());
        this.allProtos.put(modelClass, converted);
    }

    private static DescriptorProtos.FieldDescriptorProto.Type convertChildDataModelToType(ChildDataModel cdm) {
        Class childClass = cdm.getChildTypeAsClass();
        if (childClass.equals(String.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
        }
        if (childClass.equals(Integer.TYPE) || childClass.equals(Integer.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
        }
        if (childClass.equals(Long.TYPE) || childClass.equals(Long.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
        }
        if (childClass.equals(Boolean.TYPE) || childClass.equals(Boolean.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL;
        }
        if (childClass.equals(Double.TYPE) || childClass.equals(Double.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
        }
        if (childClass.equals(Float.TYPE) || childClass.equals(Float.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT;
        }
        if (childClass.equals(Byte.TYPE) || childClass.equals(Byte.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES;
        }
        if (childClass.equals(Character.TYPE) || childClass.equals(Character.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
        }
        if (childClass.equals(Short.TYPE) || childClass.equals(Short.class)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
        }
        throw new AssertionError((Object)("Unknown type to convert " + childClass.getName()));
    }

    private static String getSimpleName(String dotDelimitedName) {
        int index = dotDelimitedName.lastIndexOf(46);
        if (index < 0) {
            return dotDelimitedName;
        }
        return dotDelimitedName.substring(index + 1);
    }

    private static String getPackageName(String dotDelimitedName) {
        int index = dotDelimitedName.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return dotDelimitedName.substring(0, index);
    }

    private static String getProtoNameFromModel(ModelImpl mi) {
        String originalInterface = mi.getOriginalInterface();
        String protoName = PBufParser.getSimpleName(originalInterface);
        return protoName;
    }

    private static String getPackageNameFromModel(ModelImpl mi) {
        String originalInterface = mi.getOriginalInterface();
        String packageName = PBufParser.getPackageName(originalInterface);
        return packageName;
    }

    private static Descriptors.Descriptor convertModelToDescriptor(ModelImpl model, List<Descriptors.FileDescriptor> knownFiles) throws Exception {
        Map allChildren = model.getAllChildrenDescriptors();
        String protoName = PBufParser.getProtoNameFromModel(model);
        String packageName = PBufParser.getPackageNameFromModel(model);
        DescriptorProtos.DescriptorProto.Builder builder = DescriptorProtos.DescriptorProto.newBuilder();
        builder.setName(protoName);
        QName keyProperty = model.getKeyProperty();
        int number = 1;
        for (Map.Entry entry : allChildren.entrySet()) {
            ChildDataModel dataModel;
            QName entryKey = (QName)entry.getKey();
            String localPart = entryKey.getLocalPart();
            ChildDescriptor childDescriptor = (ChildDescriptor)entry.getValue();
            DescriptorProtos.FieldDescriptorProto.Builder fBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(localPart);
            fBuilder.setNumber(number);
            ++number;
            if (keyProperty != null && keyProperty.equals(entryKey)) {
                fBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
            }
            if ((dataModel = childDescriptor.getChildDataModel()) != null) {
                if (dataModel.getDefaultAsString() != null) {
                    fBuilder.setDefaultValue(dataModel.getDefaultAsString());
                }
                DescriptorProtos.FieldDescriptorProto.Type fieldType = PBufParser.convertChildDataModelToType(dataModel);
                fBuilder.setType(fieldType);
            } else {
                ParentedModel pm = childDescriptor.getParentedModel();
                ModelImpl childModel = pm.getChildModel();
                String childTypeName = childModel.getOriginalInterface();
                fBuilder.setTypeName(childTypeName);
                ChildType childType = pm.getChildType();
                if (childType.equals((Object)ChildType.ARRAY) || childType.equals((Object)ChildType.LIST)) {
                    fBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
                }
            }
            builder.addField(fBuilder.build());
        }
        DescriptorProtos.DescriptorProto proto = builder.build();
        DescriptorProtos.FileDescriptorProto.Builder fileBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
        fileBuilder.addMessageType(proto);
        if (packageName != null) {
            fileBuilder.setPackage(packageName);
        }
        DescriptorProtos.FileDescriptorProto fProto = fileBuilder.build();
        Descriptors.FileDescriptor fDesc = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fProto, (Descriptors.FileDescriptor[])knownFiles.toArray(new Descriptors.FileDescriptor[knownFiles.size()]));
        Descriptors.Descriptor fD = fDesc.findMessageTypeByName(protoName);
        return fD;
    }

    private static Object convertFieldForMarshal(Object field) {
        if (field == null) {
            return null;
        }
        if (field instanceof Short) {
            Short s = (Short)field;
            return new Integer(s.intValue());
        }
        if (field instanceof Character) {
            Character c = (Character)field;
            return new String(c.toString());
        }
        if (field instanceof Byte) {
            Byte b = (Byte)field;
            byte[] retVal = new byte[]{b};
            return retVal;
        }
        return field;
    }

    private static Object convertFieldForUnmarshal(Object field, ChildDataModel expected) {
        if (field == null) {
            return null;
        }
        Class expectedType = expected.getChildTypeAsClass();
        if (expectedType.equals(Short.TYPE) || expectedType.equals(Short.class)) {
            Integer i = (Integer)field;
            return i.shortValue();
        }
        if (expectedType.equals(Character.TYPE) || expectedType.equals(Character.class)) {
            String s = (String)field;
            return Character.valueOf(s.charAt(0));
        }
        if (expectedType.equals(Byte.TYPE) || expectedType.equals(Byte.class)) {
            ByteString b = (ByteString)field;
            return b.byteAt(0);
        }
        return field;
    }

    public String toString() {
        return "PBufParser(" + System.identityHashCode(this) + ")";
    }
}

